//----------------------------------------------------------------------------------
// File:        gl4-kepler\WeightedBlendedOIT\assets\shaders/weighted_final_fragment.glsl
// SDK Version: v3.00 
// Email:       gameworks@nvidia.com
// Site:        http://developer.nvidia.com/
//
// Copyright (c) 2014-2015, NVIDIA CORPORATION. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//----------------------------------------------------------------------------------
#version 410
layout(location=0) out vec4 outColor;

uniform sampler2DRect ColorTex0;
uniform sampler2DRect ColorTex1;
uniform vec3 uBackgroundColor;

void main(void)
{
    vec4 sumColor = texture(ColorTex0, gl_FragCoord.xy);
    float transmittance = texture(ColorTex1, gl_FragCoord.xy).r;
    vec3 averageColor = sumColor.rgb / max(sumColor.a, 0.00001);
    // vec3 averageColor = sumColor.rgb / max(sumColor.a, 1);
    // outColor.rgb = averageColor * (1.0 - transmittance) + uBackgroundColor * transmittance;
    outColor.rgb = averageColor * (1.0 - transmittance) + uBackgroundColor * transmittance;

    // outColor.rgb = sumColor.rgb;

    // outColor.rgb = uBackgroundColor;

    // outColor.rgb = vec3(1.0, 1.0, 1.0);


    // outColor.rgb = texture(ColorTex1, gl_FragCoord.xy).xyz;

}
