#version 330
uniform sampler2D texture0;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fs_in;

out vec4 FragColor;

uniform vec3 lightPos;
uniform vec3 viewPos;
uniform vec4 externalColor;
uniform int lines;

out vec4 color;
void main() {
        vec3 ecolor = externalColor.xyz;

        if (lines == 1) {
                FragColor = vec4(ecolor, 1.0);
        }
        else {
                vec3 color = texture(texture0, fs_in.TexCoords).rgb;
                // ambient
                vec3 ambient = 0.15 * color;
                // diffuse
                vec3 lightDir = normalize(lightPos - fs_in.FragPos);
                vec3 normal = normalize(fs_in.Normal);
                float diff = max(dot(lightDir, normal), 0.0);
                vec3 diffuse = diff * color;
                // specular
                vec3 viewDir = normalize(viewPos - fs_in.FragPos);
                vec3 reflectDir = reflect(-lightDir, normal);
                float spec = 0.0;
                vec3 halfwayDir = normalize(lightDir + viewDir);
                spec = pow(max(dot(normal, halfwayDir), 0.0), 128.0);
                vec3 specular = vec3(0.3) * (spec*ecolor);// assuming bright white light color
                FragColor = vec4(ambient + diffuse + specular, 1.0);
        }
}
