#version 330
layout (location=0) in vec3 position;
layout (location=1) in vec3 interpolation;
layout (location=2) in float shading;

out float vShading;

uniform mat4 projectionMatrix;
uniform mat4 worldMatrix;

const int NUM_BIRDS = 15;
// uniform int NUM_BIRDS;
uniform float birdAnimation[NUM_BIRDS];
// uniform vec4 birdPosition[NUM_BIRDS];
uniform mat4 birdMatrix[NUM_BIRDS];

void main() {
    // vec4 positionVec = birdMatrix[gl_InstanceID][3].xyzw;
    // vec3 fpos = position + birdPosition[gl_InstanceID].xyz + interpolation * birdAnimation[gl_InstanceID];
    // vec3 fpos = position + positionVec.xyz + interpolation * birdAnimation[gl_InstanceID];
    vec3 fpos = position + interpolation * birdAnimation[gl_InstanceID];
    vShading = shading;

    gl_Position = projectionMatrix * worldMatrix * birdMatrix[gl_InstanceID] * vec4(fpos, 1.0);
    // gl_Position = projectionMatrix * worldMatrix * vec4(fpos, 1.0);
    // gl_Position = projectionMatrix * worldMatrix * modelMatrix * vec4(position + birdPosition[gl_InstanceID].xyz, 1.0);
    // gl_Position = projectionMatrix * worldMatrix * modelMatrix * vec4(position, 1.0);
}
