#version 330

layout (location=0) in vec3 position;
layout (location=1) in vec3 interpolation;

uniform mat4 projectionMatrix;
uniform mat4 worldMatrix;
uniform mat4 modelMatrix;

uniform float wingPosition;

void main() {
    vec3 fpos = position + interpolation * wingPosition;
    gl_Position = projectionMatrix * worldMatrix * modelMatrix * vec4(fpos, 1.0);
}
