/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVertexWeight")
public class AIVertexWeight
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MVERTEXID;
    public static final int MWEIGHT;

    public AIVertexWeight(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIVertexWeight.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mVertexId() {
        return AIVertexWeight.nmVertexId(this.address());
    }

    public float mWeight() {
        return AIVertexWeight.nmWeight(this.address());
    }

    public AIVertexWeight mVertexId(@NativeType(value="unsigned int") int value) {
        AIVertexWeight.nmVertexId(this.address(), value);
        return this;
    }

    public AIVertexWeight mWeight(float value) {
        AIVertexWeight.nmWeight(this.address(), value);
        return this;
    }

    public AIVertexWeight set(int mVertexId, float mWeight) {
        this.mVertexId(mVertexId);
        this.mWeight(mWeight);
        return this;
    }

    public AIVertexWeight set(AIVertexWeight src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIVertexWeight malloc() {
        return AIVertexWeight.wrap(AIVertexWeight.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIVertexWeight calloc() {
        return AIVertexWeight.wrap(AIVertexWeight.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIVertexWeight create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIVertexWeight.wrap(AIVertexWeight.class, MemoryUtil.memAddress(container), container);
    }

    public static AIVertexWeight create(long address) {
        return AIVertexWeight.wrap(AIVertexWeight.class, address);
    }

    @Nullable
    public static AIVertexWeight createSafe(long address) {
        return address == 0L ? null : AIVertexWeight.wrap(AIVertexWeight.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIVertexWeight.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIVertexWeight.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVertexWeight.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVertexWeight.__create(capacity, SIZEOF);
        return AIVertexWeight.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIVertexWeight.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIVertexWeight.wrap(Buffer.class, address, capacity);
    }

    public static AIVertexWeight mallocStack() {
        return AIVertexWeight.mallocStack(MemoryStack.stackGet());
    }

    public static AIVertexWeight callocStack() {
        return AIVertexWeight.callocStack(MemoryStack.stackGet());
    }

    public static AIVertexWeight mallocStack(MemoryStack stack) {
        return AIVertexWeight.wrap(AIVertexWeight.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVertexWeight callocStack(MemoryStack stack) {
        return AIVertexWeight.wrap(AIVertexWeight.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIVertexWeight.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIVertexWeight.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmVertexId(long struct) {
        return UNSAFE.getInt(null, struct + (long)MVERTEXID);
    }

    public static float nmWeight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MWEIGHT);
    }

    public static void nmVertexId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MVERTEXID, value);
    }

    public static void nmWeight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MWEIGHT, value);
    }

    static {
        Struct.Layout layout = AIVertexWeight.__struct(AIVertexWeight.__member(4), AIVertexWeight.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MVERTEXID = layout.offsetof(0);
        MWEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVertexWeight, Buffer>
    implements NativeResource {
        private static final AIVertexWeight ELEMENT_FACTORY = AIVertexWeight.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIVertexWeight getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mVertexId() {
            return AIVertexWeight.nmVertexId(this.address());
        }

        public float mWeight() {
            return AIVertexWeight.nmWeight(this.address());
        }

        public Buffer mVertexId(@NativeType(value="unsigned int") int value) {
            AIVertexWeight.nmVertexId(this.address(), value);
            return this;
        }

        public Buffer mWeight(float value) {
            AIVertexWeight.nmWeight(this.address(), value);
            return this;
        }
    }
}

