/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshMorphKey")
public class AIMeshMorphKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUES;
    public static final int MWEIGHTS;
    public static final int MNUMVALUESANDWEIGHTS;

    public AIMeshMorphKey(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMeshMorphKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIMeshMorphKey.nmTime(this.address());
    }

    @NativeType(value="unsigned int *")
    public IntBuffer mValues() {
        return AIMeshMorphKey.nmValues(this.address());
    }

    @NativeType(value="double *")
    public DoubleBuffer mWeights() {
        return AIMeshMorphKey.nmWeights(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumValuesAndWeights() {
        return AIMeshMorphKey.nmNumValuesAndWeights(this.address());
    }

    public AIMeshMorphKey mTime(double value) {
        AIMeshMorphKey.nmTime(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mValues(@NativeType(value="unsigned int *") IntBuffer value) {
        AIMeshMorphKey.nmValues(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mWeights(@NativeType(value="double *") DoubleBuffer value) {
        AIMeshMorphKey.nmWeights(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mNumValuesAndWeights(@NativeType(value="unsigned int") int value) {
        AIMeshMorphKey.nmNumValuesAndWeights(this.address(), value);
        return this;
    }

    public AIMeshMorphKey set(double mTime, IntBuffer mValues, DoubleBuffer mWeights, int mNumValuesAndWeights) {
        this.mTime(mTime);
        this.mValues(mValues);
        this.mWeights(mWeights);
        this.mNumValuesAndWeights(mNumValuesAndWeights);
        return this;
    }

    public AIMeshMorphKey set(AIMeshMorphKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMeshMorphKey malloc() {
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMeshMorphKey calloc() {
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMeshMorphKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, MemoryUtil.memAddress(container), container);
    }

    public static AIMeshMorphKey create(long address) {
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, address);
    }

    @Nullable
    public static AIMeshMorphKey createSafe(long address) {
        return address == 0L ? null : AIMeshMorphKey.wrap(AIMeshMorphKey.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIMeshMorphKey.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIMeshMorphKey.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMeshMorphKey.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshMorphKey.__create(capacity, SIZEOF);
        return AIMeshMorphKey.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIMeshMorphKey.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMeshMorphKey.wrap(Buffer.class, address, capacity);
    }

    public static AIMeshMorphKey mallocStack() {
        return AIMeshMorphKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshMorphKey callocStack() {
        return AIMeshMorphKey.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshMorphKey mallocStack(MemoryStack stack) {
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshMorphKey callocStack(MemoryStack stack) {
        return AIMeshMorphKey.wrap(AIMeshMorphKey.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshMorphKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshMorphKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphKey.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphKey.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static IntBuffer nmValues(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)MVALUES), AIMeshMorphKey.nmNumValuesAndWeights(struct));
    }

    public static DoubleBuffer nmWeights(long struct) {
        return MemoryUtil.memDoubleBuffer(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS), AIMeshMorphKey.nmNumValuesAndWeights(struct));
    }

    public static int nmNumValuesAndWeights(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMVALUESANDWEIGHTS);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValues(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MVALUES, MemoryUtil.memAddress(value));
    }

    public static void nmWeights(long struct, DoubleBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MWEIGHTS, MemoryUtil.memAddress(value));
    }

    public static void nmNumValuesAndWeights(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMVALUESANDWEIGHTS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MVALUES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMeshMorphKey.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIMeshMorphKey.__struct(AIMeshMorphKey.__member(8), AIMeshMorphKey.__member(POINTER_SIZE), AIMeshMorphKey.__member(POINTER_SIZE), AIMeshMorphKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUES = layout.offsetof(1);
        MWEIGHTS = layout.offsetof(2);
        MNUMVALUESANDWEIGHTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIMeshMorphKey, Buffer>
    implements NativeResource {
        private static final AIMeshMorphKey ELEMENT_FACTORY = AIMeshMorphKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMeshMorphKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIMeshMorphKey.nmTime(this.address());
        }

        @NativeType(value="unsigned int *")
        public IntBuffer mValues() {
            return AIMeshMorphKey.nmValues(this.address());
        }

        @NativeType(value="double *")
        public DoubleBuffer mWeights() {
            return AIMeshMorphKey.nmWeights(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumValuesAndWeights() {
            return AIMeshMorphKey.nmNumValuesAndWeights(this.address());
        }

        public Buffer mTime(double value) {
            AIMeshMorphKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValues(@NativeType(value="unsigned int *") IntBuffer value) {
            AIMeshMorphKey.nmValues(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="double *") DoubleBuffer value) {
            AIMeshMorphKey.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mNumValuesAndWeights(@NativeType(value="unsigned int") int value) {
            AIMeshMorphKey.nmNumValuesAndWeights(this.address(), value);
            return this;
        }
    }
}

