/*
 * Decompiled with CFR 0.152.
 */
package ktx.math;

import com.badlogic.gdx.math.MathUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.math.ImmutableVector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\u001a*\u0010\u0002\u001a\u0002H\u0003\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\n\u00a2\u0006\u0002\u0010\u0007\u001a*\u0010\b\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u0003H\u0086\f\u00a2\u0006\u0002\u0010\n\u001a'\u0010\u000b\u001a\u00020\f\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\r\u001a'\u0010\u000e\u001a\u00020\f\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\r\u001a1\u0010\u000f\u001a\u00020\f\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0012\u001a\u00020\f\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0013\u001a\u00020\f\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0002H\u00032\u0006\u0010\t\u001a\u0002H\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"MUTABLE_METHOD_DEPRECATION_MESSAGE", "", "div", "T", "Lktx/math/ImmutableVector;", "scalar", "", "(Lktx/math/ImmutableVector;F)Lktx/math/ImmutableVector;", "dst", "other", "(Lktx/math/ImmutableVector;Lktx/math/ImmutableVector;)F", "hasOppositeDirection", "", "(Lktx/math/ImmutableVector;Lktx/math/ImmutableVector;)Z", "hasSameDirection", "isCollinear", "epsilon", "(Lktx/math/ImmutableVector;Lktx/math/ImmutableVector;F)Z", "isCollinearOpposite", "isPerpendicular", "ktx-math"})
public final class ImmutableVectorKt {
    @NotNull
    public static final String MUTABLE_METHOD_DEPRECATION_MESSAGE = "Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.";

    public static final <T extends ImmutableVector<T>> float dst(@NotNull T $receiver, @NotNull T other) {
        int $i$f$dst = 0;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        float f = $receiver.dst2(other);
        return (float)Math.sqrt(f);
    }

    @NotNull
    public static final <T extends ImmutableVector<T>> T div(@NotNull T $receiver, float scalar) {
        int $i$f$div = 0;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver.times((float)(1.0f / scalar));
    }

    public static final <T extends ImmutableVector<T>> boolean isCollinear(@NotNull T $receiver, @NotNull T other, float epsilon) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return $receiver.isOnLine(other, epsilon) && ImmutableVectorKt.hasSameDirection($receiver, other);
    }

    public static /* synthetic */ boolean isCollinear$default(ImmutableVector immutableVector, ImmutableVector immutableVector2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0E-6f;
        }
        return ImmutableVectorKt.isCollinear(immutableVector, immutableVector2, f);
    }

    public static final <T extends ImmutableVector<T>> boolean isCollinearOpposite(@NotNull T $receiver, @NotNull T other, float epsilon) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return $receiver.isOnLine(other, epsilon) && ImmutableVectorKt.hasOppositeDirection($receiver, other);
    }

    public static /* synthetic */ boolean isCollinearOpposite$default(ImmutableVector immutableVector, ImmutableVector immutableVector2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0E-6f;
        }
        return ImmutableVectorKt.isCollinearOpposite(immutableVector, immutableVector2, f);
    }

    public static final <T extends ImmutableVector<T>> boolean isPerpendicular(@NotNull T $receiver, @NotNull T other, float epsilon) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return MathUtils.isZero($receiver.dot(other), epsilon);
    }

    public static /* synthetic */ boolean isPerpendicular$default(ImmutableVector immutableVector, ImmutableVector immutableVector2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0E-6f;
        }
        return ImmutableVectorKt.isPerpendicular(immutableVector, immutableVector2, f);
    }

    public static final <T extends ImmutableVector<T>> boolean hasSameDirection(@NotNull T $receiver, @NotNull T other) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return $receiver.dot(other) > 0.0f;
    }

    public static final <T extends ImmutableVector<T>> boolean hasOppositeDirection(@NotNull T $receiver, @NotNull T other) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return $receiver.dot(other) < 0.0f;
    }
}

