/*
 * Decompiled with CFR 0.152.
 */
package com.demoframe;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0010H\u0002J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020$J(\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0002J&\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0010J&\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/demoframe/NetworkLights;", "", "port", "", "address", "", "(ILjava/lang/String;)V", "BLUE_OFFSET", "GREEN_OFFSET", "NUM_FIELDS", "NUM_LIGHTS", "RED_OFFSET", "START_BYTES", "addressToSend", "Ljava/net/InetAddress;", "cumu", "", "dropAmount", "getDropAmount", "()I", "setDropAmount", "(I)V", "lightData", "", "getPort", "sendRate", "getSendRate", "()F", "socket", "Ljava/net/DatagramSocket;", "time", "convertColor", "f", "getLightColor", "index", "sendAll", "", "setLight", "lightNumber", "r", "", "g", "b", "ri", "gi", "bi", "update", "delta", "Companion", "core"})
public final class NetworkLights {
    private int dropAmount;
    private final float sendRate = 0.1f;
    private final int NUM_LIGHTS = 24;
    private final int NUM_FIELDS = 6;
    private final int START_BYTES = 7;
    private final int RED_OFFSET = 3;
    private final int GREEN_OFFSET = 4;
    private final int BLUE_OFFSET = 5;
    private final DatagramSocket socket;
    private final byte[] lightData;
    private InetAddress addressToSend;
    private float time;
    private float cumu;
    private final int port;
    public static final Companion Companion = new Companion(null);

    public final int getDropAmount() {
        return this.dropAmount;
    }

    public final void setDropAmount(int n) {
        this.dropAmount = n;
    }

    public final float getSendRate() {
        return this.sendRate;
    }

    private final int convertColor(float f) {
        return (int)(f * 255.0f);
    }

    public final void setLight(int lightNumber, float r, float g, float b) {
        this.setLight(lightNumber, this.convertColor(r), this.convertColor(g), this.convertColor(b));
    }

    private final void setLight(int lightNumber, byte r, byte g, byte b) {
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.RED_OFFSET] = r;
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.GREEN_OFFSET] = g;
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.BLUE_OFFSET] = b;
    }

    public final void setLight(int lightNumber, int ri, int gi, int bi) {
        byte r = (byte)ri;
        byte g = (byte)gi;
        byte b = (byte)bi;
        this.setLight(lightNumber, r, g, b);
    }

    @NotNull
    public final byte[] getLightColor(int index) {
        byte r = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.RED_OFFSET];
        byte g = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.GREEN_OFFSET];
        byte b = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.BLUE_OFFSET];
        return new byte[]{r, g, b};
    }

    public final void sendAll() {
        DatagramPacket packet = new DatagramPacket(this.lightData, this.lightData.length, this.addressToSend, this.port);
        this.socket.send(packet);
    }

    /*
     * WARNING - void declaration
     */
    public final void update(float delta) {
        float fadeAmount = delta * (float)20;
        this.cumu += fadeAmount;
        if (this.cumu >= 1.0f) {
            int n = 0;
            int n2 = this.NUM_LIGHTS - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    byte r = this.getLightColor((int)i)[0];
                    byte g = this.getLightColor((int)i)[1];
                    byte b = this.getLightColor((int)i)[2];
                    int rmin = r - this.dropAmount;
                    int gmin = g - this.dropAmount;
                    int bmin = b - this.dropAmount;
                    r = r >= 0 && r < 128 && rmin < 0 ? (byte)0 : (byte)rmin;
                    g = g >= 0 && g < 128 && gmin < 0 ? (byte)0 : (byte)gmin;
                    b = b >= 0 && b < 128 && bmin < 0 ? (byte)0 : (byte)bmin;
                    this.setLight((int)i, r, g, b);
                    if (i == n2) break;
                    ++i;
                }
            }
            this.cumu = 0.0f;
        }
        if (this.time >= this.sendRate) {
            this.sendAll();
            this.time = 0.0f;
        }
        this.time += delta;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public NetworkLights(int port, @NotNull String address) {
        Intrinsics.checkParameterIsNotNull(address, "address");
        this.port = port;
        this.dropAmount = 25;
        this.sendRate = 0.1f;
        this.NUM_LIGHTS = 24;
        this.NUM_FIELDS = 6;
        this.START_BYTES = 7;
        this.RED_OFFSET = 3;
        this.GREEN_OFFSET = this.RED_OFFSET + 1;
        this.BLUE_OFFSET = this.GREEN_OFFSET + 1;
        this.socket = new DatagramSocket();
        this.lightData = new byte[this.START_BYTES + this.NUM_FIELDS * this.NUM_LIGHTS];
        this.lightData[0] = 1;
        this.lightData[1] = 0;
        this.lightData[2] = 119;
        this.lightData[3] = 97;
        this.lightData[4] = 98;
        this.lightData[5] = 101;
        this.lightData[6] = 0;
        int lightIndex = 0;
        int n = this.START_BYTES;
        IntProgression intProgression = RangesKt.step(new IntRange(n, this.lightData.length - 1), this.NUM_FIELDS);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                this.lightData[i] = 1;
                this.lightData[i + true] = (byte)lightIndex;
                this.lightData[i + 2] = 0;
                this.lightData[i + 3] = 0;
                this.lightData[i + 4] = 0;
                this.lightData[i + 5] = 0;
                ++lightIndex;
                if (i == n3) break;
                i += n4;
            }
        }
        CharSequence i = address;
        Object object = new Regex(".*\\d+.*");
        n4 = 0;
        if (!((Regex)object).matches(i)) {
            i = address;
            NetworkLights networkLights = this;
            boolean bl = false;
            String string = ((Object)StringsKt.trim(i)).toString();
            InetAddress inetAddress = InetAddress.getByName(string);
            Intrinsics.checkExpressionValueIsNotNull(inetAddress, "InetAddress.getByName(address.trim())");
            networkLights.addressToSend = inetAddress;
        } else {
            object = address;
            n4 = 0;
            List addressChunks = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)object)).toString(), new String[]{"."}, false, 0, 6, null);
            byte[] addressAsBytes = new byte[]{(byte)Integer.parseInt((String)addressChunks.get(0)), (byte)Integer.parseInt((String)addressChunks.get(1)), (byte)Integer.parseInt((String)addressChunks.get(2)), (byte)Integer.parseInt((String)addressChunks.get(3))};
            InetAddress inetAddress = InetAddress.getByAddress(addressAsBytes);
            Intrinsics.checkExpressionValueIsNotNull(inetAddress, "InetAddress.getByAddress(addressAsBytes)");
            this.addressToSend = inetAddress;
        }
        int addressChunks = 0;
        int n7 = this.NUM_LIGHTS - 1;
        if (addressChunks <= n7) {
            while (true) {
                this.setLight((int)i, 0, 0, 0);
                if (i == n7) break;
                ++i;
            }
        }
        this.setLight(0, 0, 254, 0);
        this.sendAll();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/demoframe/NetworkLights$Companion;", "", "()V", "LightChunk", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/demoframe/NetworkLights$Companion$LightChunk;", "", "cfg", "Lcom/demoframe/NetworkLights;", "indices", "", "(Lcom/demoframe/NetworkLights;[I)V", "getCfg", "()Lcom/demoframe/NetworkLights;", "getIndices", "()[I", "setValue", "", "r", "", "g", "b", "", "core"})
        public static final class LightChunk {
            @NotNull
            private final NetworkLights cfg;
            @NotNull
            private final int[] indices;

            /*
             * WARNING - void declaration
             */
            public final void setValue(float r, float g, float b) {
                int n = 0;
                int n2 = this.indices.length;
                while (n < n2) {
                    void i;
                    this.cfg.setLight(this.indices[i], r, g, b);
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void setValue(int r, int g, int b) {
                int n = 0;
                int n2 = this.indices.length;
                while (n < n2) {
                    void i;
                    this.cfg.setLight(this.indices[i], r, g, b);
                    ++i;
                }
            }

            @NotNull
            public final NetworkLights getCfg() {
                return this.cfg;
            }

            @NotNull
            public final int[] getIndices() {
                return this.indices;
            }

            public LightChunk(@NotNull NetworkLights cfg, @NotNull int[] indices) {
                Intrinsics.checkParameterIsNotNull(cfg, "cfg");
                Intrinsics.checkParameterIsNotNull(indices, "indices");
                this.cfg = cfg;
                this.indices = indices;
            }
        }
    }
}

