fd = fopen('scene1.bin', 'r');
palette = zeros(16,3);

h = figure;
%%hold on;
axis tight manual;
axis([0 255 0 199]);
ax = gca;
ax.NextPlot = 'replaceChildren';
frames = 1800;
M(frames) = struct('cdata',[],'colormap',[]);
h.Visible = 'off';
%v = VideoWriter('niccc.avi','Uncompressed AVI');
%open(v);
for i = (1:frames)
    hold on;
    [palette, exit] = readFrame(fd, palette);
    hold off;
    %drawnow;
    %break
    fprintf("frame %d\n", i);
    curfr = getframe(gcf);
    %writeVideo(v, curfr);
    M(i) = curfr;
    if exit
        break
    end
end
%%hold off;
h.Visible = 'on';
%%writeVideo(v,M);
%close(v);
movie(M,30);

function drawPoly(poly, col)
    ppp = polyshape(poly);
    col = col ./ 7.0;
    plot(ppp, 'FaceColor', col, 'FaceAlpha',1, 'EdgeAlpha',0);
end

function [r, g, b] = readCol(fd)
    r = fread(fd, 1, 'uint8');
    r = bitand(r, 7);

    gb = fread(fd, 1, 'uint8');
    b = bitand(gb, 7);
    g = bitand(gb, 7*16)/16;
end

function [pal, nicccend] = readFrame(fd, pal)
    flags = fread(fd, 1, 'uint8');
    nicccend = 0;

    if (bitand(flags, 1))
       % clear screen
       fs = polyshape(transpose([[0;0] [0;199] [255;199] [255;0]]));
       plot(fs, 'FaceColor','black', 'FaceAlpha',1,'EdgeAlpha',0);
    end
    if (bitand(flags, 2))
        % has palette data
        palmaskhi = fread(fd, 1, 'uint8');
        palmasklo = fread(fd, 1, 'uint8');
        palmask = bitor(palmasklo, palmaskhi*(2^8));

        for i = (0:15)
            if (bitand(palmask, 2^(15-i)))
                [r,g,b] = readCol(fd);
                pal(i+1,1) = r;
                pal(i+1,2) = g;
                pal(i+1,3) = b;
            end
        end
    end

    if (bitand(flags, 4))
        % indexed frames
        nivtx = fread(fd, 1, 'uint8');
        ivtxs = zeros(nivtx,2); % x,y

        for i = (1:nivtx)
            x = fread(fd, 1, 'uint8');
            y = fread(fd, 1, 'uint8');

            ivtxs(i,1) = x;
            ivtxs(i,2) = 199 - y;
        end

        while 1
            desc = fread(fd, 1, 'uint8');

            if (desc == 255)
                break % end of frame
            elseif (desc == 254)
                % skip to next 64k!
                opos = ftell(fd);
                stuff = bitand(opos, 65535);
                upper = bitand(opos, 65535*65536);
                if stuff
                    upper = upper + 65536;
                end
                npos = upper;
                fprintf("seek: %x -> %x\n", opos, npos);
                fseek(fd,npos,-1);
                break % end of frame
            elseif (desc == 253)
                nicccend = 1;
                break % end of NICCC
            else
                colind = bitand(desc, 15*16)/16;
                npvtx  = bitand(desc, 15   )   ;

                poly = zeros(npvtx, 2); % x, y

                for i = (1:npvtx)
                    vind = fread(fd, 1, 'uint8');
                    poly(i,1) = ivtxs(vind+1,1);
                    poly(i,2) = ivtxs(vind+1,2);
                end

                drawPoly(poly, pal(colind+1,:));
            end
        end
    else
        while 1
            desc = fread(fd, 1, 'uint8');

            if (desc == 255)
                break % end of frame
            elseif (desc == 254)
                % skip to next 64k!
                opos = ftell(fd);
                stuff = bitand(opos, 65535);
                upper = bitand(opos, 65535*65536);
                if stuff
                    upper = upper + 65536;
                end
                npos = upper;
                fprintf("seek: %x -> %x\n", opos, npos);
                fseek(fd,npos,-1);
                break % end of frame
            elseif (desc == 253)
                nicccend = 1;
                break % end of NICCC
            else
                colind = bitand(desc, 15*16)/16;
                npvtx  = bitand(desc, 15   )   ;

                poly = zeros(npvtx, 2);

                for i = (1:npvtx)
                    x = fread(fd, 1, 'uint8');
                    y = fread(fd, 1, 'uint8');
                    poly(i,1) = x;
                    poly(i,2) = 199 - y;
                end

                drawPoly(poly, pal(colind+1,:));
            end
        end
    end
end

