# Fan of Tracing Rays - sources

This contains the data and other things used when making a wild-compo entry "Fan of Tracing Rays" for Hogmanay.party 2020 (youtube: https://youtu.be/cQeSIT4nxgY)

Overall directory structure:

* GNSS-Stylus_Deploy_Win32: Special edition of GNSS-Stylus used for the prod. Only difference from the "non-special-edition" ( https://github.com/GNSS-Stylist/GNSS-Stylus/releases/tag/V1.3.0 ) is the possibility to add ghosts of snowpeople surrounding the "raytracing"-scene into the ".lidarscript"-file that is used to draw "laser lines" and "raytraced" dots.

* GNSS-Stylus_Src: Sources for the above.

* Godot_Playback: Project made in Godot engine that can be used to play back the scanning data. This was used to generate CGI-parts and overlays for the youtube video. Godot-version used was 3.2.4-beta (custom build), but any 3.2.x-version (and probably later ones) will most likely work. See more detailed readme.md in the directory itself. Subdirectory:
  
  * GNSS_Stylus_Scripts: Files generated using GNSS-Stylus' Post-processing.

* Logs_Params: Raw log files and parameters used when post-processing the data using GNSS-Stylus-application. These files can be used in the application's post-processing operations (use "Files->Add from files including other fields (parameters)..." to read all at once). Includes data from GNSS- and lidar-devices. Files:
  
  * CameraRig.AntennaLocations: Locations of rover antennas in relation to rig's origin. Needed for the location/orientation solver.
  
  * Toilet.distances: Distances measured from a laser distance measurement module. As this module is not used, the file is empty.
  
  * Toilet.lidar: Measurements from the lidar. This is in binary format so it's not readable by text editor or similar.
  
  * Toilet.PPParameters: Parameters used when handling the data in post-processing-phase. When this is read into GNSS-Stylus' (special Hogmanay-edition) Post-processing window using "Load all editable fields from file..." or "Files->Mass operations->Add from files including other fields (parameters)..." it should generate identical files used to generate the video and used by the Godot-project (see below).
  
  * Toilet.sync: Synchronization data for rovers (iTOWs and corresponding uptimes). This is needed to make it possible to sync data from rovers and other devices (in this case lidar).
  
  * Toilet.Transformation: "Final" translation&transformation performed when generating files using GNSS-Stylus' post-processing operations. In this case the toilet seat's origin is shifted to the approximate center of the seat in NE (=ground)-plane and relative to the ground (seat is on top of a bucket). Coordinate system is changed from NED to EUS used by MeshLab and Godot engine.
  
  * Toilet_RoverX_RELPOSNED.ubx: UBX-format "RELPOSNED" (message type of UBX-protocol including coordinates relative to the base) data logged from rovers. GNSS-Stylus writes more log files, but in this case they are redundant and therefore removed. Base logs not included as they are not needed here.
  
  * Toilet_tags.tags: Tags used to start/stop objects/scanning etc. These were edited by hand afterwards, since the mouse didn't work when scanning.
  
  * Toilet_tags_Original_No_MouseButtonTags.tags: Original tags (only "New object" here since the mouse didn't work).
  
  * Toilet_unfiltered.distances: Distances (without filtering) measured from a laser distance measurement module. As this module is not used, the file is empty.
  
  * Lidar_AfterRotation.Operations: "Operations" (matrix transformations) basically used to place the lidar into correct location/orientation in relation to rig's origin. See the file itself for more info.
  
  * Lidar_BeforeRotation.Operations: "Operations" (matrix transformations) performed in lidar's rotating coordinate system. See the file itself for more info.
  
  * LOSolver_Camera.Operations: "Operations" (matrix transformations) performed in rig's coordinate system to place the camera into correct location/orientation when generating location/orientation script. See the file itself for more info.
  
  * LOSolver_Rig.Operations: "Operations" (matrix transformations) performed in rig's coordinate system to place the rig object into correct location/orientation when generating location/orientation script. In this case there's no operations as the rig objects' origin equals the real rig's origin (could be also otherwise).
