/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.FontImageMapDrawer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.text.Cursor;
import org.openrndr.text.RenderToken;
import org.openrndr.text.WriteStyle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J&\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\r2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000207H\u0002J\u0006\u00109\u001a\u000204J \u0010:\u001a\b\u0012\u0004\u0012\u0002070;2\u0006\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u0016\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 J\u0006\u0010B\u001a\u000204J\u0018\u0010<\u001a\u0002042\u0006\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010C\u001a\u00020>J\u000e\u0010D\u001a\u00020 2\u0006\u0010<\u001a\u00020\u001aR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R(\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R$\u00100\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010#\"\u0004\b2\u0010%\u00a8\u0006E"}, d2={"Lorg/openrndr/text/Writer;", "", "drawerRef", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "value", "Lorg/openrndr/shape/Rectangle;", "box", "getBox", "()Lorg/openrndr/shape/Rectangle;", "setBox", "(Lorg/openrndr/shape/Rectangle;)V", "cursor", "Lorg/openrndr/text/Cursor;", "getCursor", "()Lorg/openrndr/text/Cursor;", "setCursor", "(Lorg/openrndr/text/Cursor;)V", "Lorg/openrndr/draw/DrawStyle;", "drawStyle", "getDrawStyle", "()Lorg/openrndr/draw/DrawStyle;", "setDrawStyle", "(Lorg/openrndr/draw/DrawStyle;)V", "getDrawerRef", "()Lorg/openrndr/draw/Drawer;", "", "ellipsis", "getEllipsis", "()Ljava/lang/String;", "setEllipsis", "(Ljava/lang/String;)V", "", "leading", "getLeading", "()D", "setLeading", "(D)V", "style", "Lorg/openrndr/text/WriteStyle;", "getStyle", "()Lorg/openrndr/text/WriteStyle;", "setStyle", "(Lorg/openrndr/text/WriteStyle;)V", "styleStack", "Ljava/util/Stack;", "getStyleStack", "()Ljava/util/Stack;", "tracking", "getTracking", "setTracking", "emitToken", "", "renderTokens", "", "Lorg/openrndr/text/RenderToken;", "renderToken", "gaplessNewLine", "makeRenderTokens", "", "text", "mustFit", "", "move", "x", "y", "newLine", "visible", "textWidth", "openrndr-core"})
public final class Writer {
    @NotNull
    private Cursor cursor;
    @NotNull
    private Rectangle box;
    @NotNull
    private WriteStyle style;
    @NotNull
    private final Stack<WriteStyle> styleStack;
    @NotNull
    private DrawStyle drawStyle;
    @Nullable
    private final Drawer drawerRef;

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter(cursor, "<set-?>");
        this.cursor = cursor;
    }

    @NotNull
    public final Rectangle getBox() {
        return this.box;
    }

    public final void setBox(@NotNull Rectangle value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.box = value;
        this.cursor.setX(value.getCorner().getX());
        this.cursor.setY(value.getCorner().getY());
    }

    @NotNull
    public final WriteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull WriteStyle writeStyle) {
        Intrinsics.checkNotNullParameter(writeStyle, "<set-?>");
        this.style = writeStyle;
    }

    @NotNull
    public final Stack<WriteStyle> getStyleStack() {
        return this.styleStack;
    }

    public final double getLeading() {
        return this.style.getLeading();
    }

    public final void setLeading(double value) {
        this.style.setLeading(value);
    }

    public final double getTracking() {
        return this.style.getTracking();
    }

    public final void setTracking(double value) {
        this.style.setTracking(value);
    }

    @Nullable
    public final String getEllipsis() {
        return this.style.getEllipsis();
    }

    public final void setEllipsis(@Nullable String value) {
        this.style.setEllipsis(value);
    }

    @NotNull
    public final DrawStyle getDrawStyle() {
        Object object = this.drawerRef;
        if (object == null || (object = ((Drawer)object).getDrawStyle()) == null) {
            object = this.drawStyle;
        }
        return object;
    }

    public final void setDrawStyle(@NotNull DrawStyle value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.drawStyle = this.getDrawStyle();
    }

    public final void newLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + ((fontMap != null ? fontMap.getLeading() : 0.0) + this.style.getLeading()));
    }

    public final void gaplessNewLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + (fontMap != null ? fontMap.getHeight() : 0.0));
    }

    public final void move(double x, double y) {
        Cursor cursor = this.cursor;
        cursor.setX(cursor.getX() + x);
        Cursor cursor2 = this.cursor;
        cursor2.setY(cursor2.getY() + y);
    }

    /*
     * WARNING - void declaration
     */
    public final double textWidth(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        CharSequence $this$sumByDouble$iv = text2;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        CharSequence charSequence = $this$sumByDouble$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void it;
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            double d = sum$iv;
            boolean bl = false;
            FontMap fontMap = this.getDrawStyle().getFontMap();
            if (fontMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            GlyphMetrics glyphMetrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf((char)it));
            double d2 = glyphMetrics != null ? glyphMetrics.getAdvanceWidth() : 0.0;
            sum$iv = d + d2;
        }
        return sum$iv + (double)RangesKt.coerceAtLeast(text2.length() - 1, 0) * this.style.getTracking();
    }

    public final void text(@NotNull String text2, boolean visible) {
        block3: {
            Intrinsics.checkNotNullParameter(text2, "text");
            Drawer drawer = this.drawerRef;
            if (drawer != null) {
                drawer.getFontMap();
            }
            List<RenderToken> renderTokens = this.makeRenderTokens(text2, false);
            if (!visible) break block3;
            Drawer drawer2 = this.drawerRef;
            if (drawer2 != null) {
                Drawer drawer3 = drawer2;
                boolean bl = false;
                boolean bl2 = false;
                Drawer d = drawer3;
                boolean bl3 = false;
                FontImageMapDrawer renderer = d.getFontImageMapDrawer$openrndr_core();
                Iterable $this$forEach$iv = renderTokens;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RenderToken it = (RenderToken)element$iv;
                    boolean bl4 = false;
                    FontMap fontMap = d.getDrawStyle().getFontMap();
                    Intrinsics.checkNotNull(fontMap);
                    FontImageMapDrawer.queueText$default(renderer, fontMap, it.getToken(), it.getX(), it.getY(), this.style.getTracking(), null, 32, null);
                }
                renderer.flush(d.getContext(), d.getDrawStyle());
            }
        }
    }

    public static /* synthetic */ void text$default(Writer writer, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        writer.text(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RenderToken> makeRenderTokens(String text2, boolean mustFit) {
        FontMap fontMap = this.getDrawStyle().getFontMap();
        if (fontMap != null) {
            List list;
            FontMap fontMap2 = fontMap;
            boolean bl = false;
            boolean bl2 = false;
            FontMap font = fontMap2;
            boolean bl3 = false;
            boolean fits = true;
            FontMap fontMap3 = font;
            if (fontMap3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            FontImageMap cfr_ignored_0 = (FontImageMap)fontMap3;
            CharSequence charSequence = text2;
            Object object = "((?<=\n)|(?=\n))";
            int n = 0;
            object = new Regex((String)object);
            n = 0;
            boolean bl4 = false;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl5 = false;
                    CharSequence charSequence2 = it;
                    boolean bl6 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] lines = stringArray;
            $i$f$toTypedArray = false;
            List tokens = new ArrayList();
            String[] $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            String[] stringArray2 = $this$forEach$iv;
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String element$iv;
                String line = element$iv = stringArray2[i];
                boolean bl7 = false;
                List lineTokens = StringsKt.split$default((CharSequence)line, new String[]{" "}, false, 0, 6, null);
                tokens.addAll(lineTokens);
            }
            Cursor localCursor = new Cursor(this.cursor);
            GlyphMetrics glyphMetrics = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf(' '));
            Intrinsics.checkNotNull(glyphMetrics);
            double spaceWidth = glyphMetrics.getAdvanceWidth();
            double verticalSpace = this.style.getLeading() + font.getLeading();
            int line = 0;
            List renderTokens = new ArrayList();
            line = 0;
            int n3 = tokens.size();
            while (line < n3) {
                void i;
                String token = (String)tokens.get((int)i);
                if (Intrinsics.areEqual(token, "\n")) {
                    localCursor.setX(this.box.getCorner().getX());
                    Cursor cursor = localCursor;
                    cursor.setY(cursor.getY() + verticalSpace);
                } else {
                    CharSequence $this$sumByDouble$iv = token;
                    boolean $i$f$sumByDouble = false;
                    double sum$iv = 0.0;
                    CharSequence charSequence3 = $this$sumByDouble$iv;
                    for (int j = 0; j < charSequence3.length(); ++j) {
                        void it;
                        char element$iv;
                        char c = element$iv = charSequence3.charAt(j);
                        double d = sum$iv;
                        boolean bl8 = false;
                        GlyphMetrics glyphMetrics2 = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf((char)it));
                        double d2 = glyphMetrics2 != null ? glyphMetrics2.getAdvanceWidth() : 0.0;
                        sum$iv = d + d2;
                    }
                    double tokenWidth = sum$iv + this.style.getTracking() * (double)token.length();
                    if (localCursor.getX() + tokenWidth < this.box.getX() + this.box.getWidth() && localCursor.getY() <= this.box.getY() + this.box.getHeight()) {
                        Writer writer = this;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        Writer $this$run = writer;
                        boolean bl11 = false;
                        RenderToken renderToken = new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, $this$run.style.getTracking());
                        $this$run.emitToken(localCursor, renderTokens, renderToken);
                    } else {
                        if (localCursor.getY() > this.box.getCorner().getY() + this.box.getHeight()) {
                            fits = false;
                        }
                        if (localCursor.getY() + verticalSpace <= this.box.getY() + this.box.getHeight()) {
                            Cursor cursor = localCursor;
                            cursor.setY(cursor.getY() + verticalSpace);
                            localCursor.setX(this.box.getX());
                            this.emitToken(localCursor, renderTokens, new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                        } else {
                            if (!mustFit && this.style.getEllipsis() != null && this.cursor.getY() <= this.box.getY() + this.box.getHeight()) {
                                String string = this.style.getEllipsis();
                                if (string == null) {
                                    string = "";
                                }
                                this.emitToken(localCursor, renderTokens, new RenderToken(string, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                                break;
                            }
                            fits = false;
                        }
                    }
                    Cursor cursor = localCursor;
                    cursor.setX(cursor.getX() + tokenWidth);
                    if (i != tokens.size() - 1) {
                        Cursor cursor2 = localCursor;
                        cursor2.setX(cursor2.getX() + spaceWidth);
                    }
                }
                ++i;
            }
            if (fits || !fits && !mustFit) {
                this.cursor = new Cursor(localCursor);
            } else {
                renderTokens.clear();
            }
            return renderTokens;
        }
        return CollectionsKt.emptyList();
    }

    static /* synthetic */ List makeRenderTokens$default(Writer writer, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return writer.makeRenderTokens(string, bl);
    }

    private final void emitToken(Cursor cursor, List<RenderToken> renderTokens, RenderToken renderToken) {
        renderTokens.add(renderToken);
    }

    @Nullable
    public final Drawer getDrawerRef() {
        return this.drawerRef;
    }

    public Writer(@Nullable Drawer drawerRef) {
        this.drawerRef = drawerRef;
        this.cursor = new Cursor(0.0, 0.0, 3, null);
        Drawer drawer = this.drawerRef;
        Drawer drawer2 = this.drawerRef;
        this.box = new Rectangle(Vector2.Companion.getZERO(), drawer != null ? (double)drawer.getWidth() : Double.POSITIVE_INFINITY, drawer2 != null ? (double)drawer2.getHeight() : Double.POSITIVE_INFINITY);
        this.style = new WriteStyle();
        this.styleStack = new Stack();
        this.drawStyle = new DrawStyle(null, null, null, null, null, 0.0, false, null, null, false, null, null, null, false, null, null, null, null, null, null, null, 0x1FFFFF, null);
    }
}

