/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.openrndr.math.Matrix44;
import org.openrndr.svg.SVGElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u0082\u0001\u0003\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/svg/SVGElement;", "", "()V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "setAttributes", "(Ljava/util/Map;)V", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "transform", "Lorg/openrndr/math/Matrix44;", "getTransform", "()Lorg/openrndr/math/Matrix44;", "setTransform", "(Lorg/openrndr/math/Matrix44;)V", "parseAttributes", "", "e", "Lorg/jsoup/nodes/Element;", "parseTransform", "Lorg/openrndr/svg/SVGImage;", "Lorg/openrndr/svg/SVGGroup;", "Lorg/openrndr/svg/SVGPath;", "openrndr-svg"})
public abstract class SVGElement {
    @NotNull
    private Matrix44 transform = Matrix44.Companion.getIDENTITY();
    @Nullable
    private String id;
    @NotNull
    private Map<String, String> attributes;

    @NotNull
    public final Matrix44 getTransform() {
        return this.transform;
    }

    public final void setTransform(@NotNull Matrix44 matrix44) {
        Intrinsics.checkNotNullParameter(matrix44, "<set-?>");
        this.transform = matrix44;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @NotNull
    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.attributes = map2;
    }

    public final void parseAttributes(@NotNull Element e) {
        Intrinsics.checkNotNullParameter(e, "e");
        for (Attribute attribute : e.attributes()) {
            String string = attribute.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "attribute.key");
            if (!StringsKt.contains$default((CharSequence)string, ":", false, 2, null)) {
                String string2 = attribute.getKey();
                Intrinsics.checkNotNullExpressionValue(string2, "attribute.key");
                if (!StringsKt.startsWith$default(string2, "data-", false, 2, null)) continue;
            }
            if (attribute.hasDeclaredValue()) {
                String string3 = attribute.getKey();
                Intrinsics.checkNotNullExpressionValue(string3, "attribute.key");
                this.attributes.put(string3, attribute.getValue());
                continue;
            }
            String string4 = attribute.getKey();
            Intrinsics.checkNotNullExpressionValue(string4, "attribute.key");
            this.attributes.put(string4, null);
        }
    }

    public final void parseTransform(@NotNull Element e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Pattern p = Pattern.compile("(matrix|translate|scale|rotate|skewX|skewY)\\(.+\\)");
        Matcher m = p.matcher(e.attr("transform"));
        parseTransform.1 $fun$getTransformOperands$1 = parseTransform.1.INSTANCE;
        while (m.find()) {
            Object mat;
            List<Double> operands;
            String token;
            String string = token = m.group();
            Intrinsics.checkNotNullExpressionValue(string, "token");
            if (StringsKt.startsWith$default(string, "matrix", false, 2, null)) {
                operands = $fun$getTransformOperands$1.invoke(token);
                this.transform = mat = new Matrix44(((Number)operands.get(0)).doubleValue(), ((Number)operands.get(2)).doubleValue(), 0.0, ((Number)operands.get(4)).doubleValue(), ((Number)operands.get(1)).doubleValue(), ((Number)operands.get(3)).doubleValue(), 0.0, ((Number)operands.get(5)).doubleValue(), 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            }
            if (!StringsKt.startsWith$default(token, "scale", false, 2, null)) continue;
            mat = token;
            int n = 5;
            boolean bl = false;
            String string2 = ((String)mat).substring(n);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
            operands = $fun$getTransformOperands$1.invoke(string2);
            this.transform = mat = new Matrix44(((Number)operands.get(0)).doubleValue(), 0.0, 0.0, 0.0, 0.0, ((Number)operands.get(1)).doubleValue(), 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private SVGElement() {
        boolean bl = false;
        this.attributes = new LinkedHashMap();
    }

    public /* synthetic */ SVGElement(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

