/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Segment3DKt;
import org.openrndr.shape.SegmentProjection3D;
import org.openrndr.shape.internal.BezierCubicSampler3D;
import org.openrndr.shape.internal.BezierQuadraticSampler3D;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ*\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00030#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010&\u001a\u00020\u0003H\u0002J/\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0016J\u0014\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u001eH\u0002J\u0013\u0010-\u001a\u00020\u001a2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\b\u00101\u001a\u00020$H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\b\b\u0002\u00102\u001a\u00020$J\u001f\u00103\u001a\u0004\u0018\u00010\u00162\u0006\u00104\u001a\u00020\u00032\b\b\u0002\u00105\u001a\u00020\u0016\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0016J\u000e\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020\u0003J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\b\b\u0002\u0010<\u001a\u00020\u0016J(\u0010=\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0#2\b\b\u0002\u0010<\u001a\u00020\u0016J\u0019\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b2\u0006\u0010*\u001a\u00020\u0016\u00a2\u0006\u0002\u0010?J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u0016J\b\u0010C\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010E\u001a\u00020FR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014\u00a8\u0006G"}, d2={"Lorg/openrndr/shape/Segment3D;", "", "start", "Lorg/openrndr/math/Vector3;", "end", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "c0", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "c1", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "control", "", "(Lorg/openrndr/math/Vector3;[Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "getControl", "()[Lorg/openrndr/math/Vector3;", "[Lorg/openrndr/math/Vector3;", "cubic", "getCubic", "()Lorg/openrndr/shape/Segment3D;", "getEnd", "()Lorg/openrndr/math/Vector3;", "length", "", "getLength", "()D", "linear", "", "getLinear", "()Z", "lut", "", "reverse", "getReverse", "getStart", "closest", "Lkotlin/Pair;", "", "points", "query", "copy", "(Lorg/openrndr/math/Vector3;[Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)Lorg/openrndr/shape/Segment3D;", "derivative", "t", "direction", "dpoints", "equals", "other", "extrema", "extremaPoints", "hashCode", "size", "on", "point", "error", "(Lorg/openrndr/math/Vector3;D)Ljava/lang/Double;", "position", "ut", "project", "Lorg/openrndr/shape/SegmentProjection3D;", "sampleAdaptive", "distanceTolerance", "sampleAdaptiveNormals", "split", "(D)[Lorg/openrndr/shape/Segment3D;", "sub", "t0", "t1", "toString", "", "transform", "Lorg/openrndr/math/Matrix44;", "openrndr-core"})
public final class Segment3D {
    @NotNull
    private final Vector3 start;
    @NotNull
    private final Vector3 end;
    @NotNull
    private final Vector3[] control;
    private List<Vector3> lut;

    @NotNull
    public final Vector3 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector3 getEnd() {
        return this.end;
    }

    @NotNull
    public final Vector3[] getControl() {
        return this.control;
    }

    public final boolean getLinear() {
        Vector3[] vector3Array = this.control;
        boolean bl = false;
        return vector3Array.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3> lut(int size) {
        block4: {
            Collection<Vector3> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block3: {
                if (this.lut == null) break block3;
                List<Vector3> list = this.lut;
                Intrinsics.checkNotNull(list);
                if (list.size() == size) break block4;
            }
            int n = 0;
            Iterable iterable = new IntRange(n, size);
            Segment3D segment3D = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                Vector3 vector3 = this.position((double)it / (double)size);
                collection.add(vector3);
            }
            collection = (List)destination$iv$iv;
            segment3D.lut = collection;
        }
        List<Vector3> list = this.lut;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public static /* synthetic */ List lut$default(Segment3D segment3D, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment3D.lut(n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector3 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment3D.lut$default(this, 0, 1, null);
        int hits = 0;
        double t2 = 0.0;
        int n = 0;
        int n2 = lut.size();
        while (n < n2) {
            void i;
            if (((Vector3)lut.get((int)i)).minus(point).getSquaredLength() < error * error) {
                ++hits;
                t2 += (double)i / (double)lut.size();
            }
            ++i;
        }
        return hits > 0 ? Double.valueOf(t2 / (double)hits) : null;
    }

    public static /* synthetic */ Double on$default(Segment3D segment3D, Vector3 vector3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment3D.on(vector3, d);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Vector3> closest(List<Vector3> points, Vector3 query) {
        int closestIndex = 0;
        Vector3 closestValue = points.get(0);
        double closestDistance = Double.POSITIVE_INFINITY;
        int n = 0;
        int n2 = points.size();
        while (n < n2) {
            void i;
            double distance = points.get((int)i).minus(query).getSquaredLength();
            if (distance < closestDistance) {
                closestIndex = i;
                closestValue = points.get((int)i);
                closestDistance = distance;
            }
            ++i;
        }
        return new Pair<Integer, Vector3>(closestIndex, closestValue);
    }

    @NotNull
    public final SegmentProjection3D project(@NotNull Vector3 point) {
        Vector3 p;
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment3D.lut$default(this, 0, 1, null);
        double l = lut.size() - 1;
        Pair<Integer, Vector3> closest = this.closest(lut, point);
        double closestDistance = point.minus(closest.getSecond()).getSquaredLength();
        if (((Number)closest.getFirst()).intValue() == 0 || ((Number)closest.getFirst()).intValue() == lut.size() - 1) {
            double t2 = (double)((Number)closest.getFirst()).intValue() / l;
            return new SegmentProjection3D(this, t2, closestDistance, closest.getSecond());
        }
        double t1 = (double)(((Number)closest.getFirst()).intValue() - 1) / l;
        double t2 = (double)(((Number)closest.getFirst()).intValue() + 1) / l;
        double step = 0.1 / l;
        double ft = t1;
        for (double t3 = t1; t3 < t2 + step; t3 += step) {
            p = this.position(t3);
            double d = p.minus(point).getSquaredLength();
            if (!(d < closestDistance)) continue;
            closestDistance = d;
            ft = t3;
        }
        p = this.position(ft);
        return new SegmentProjection3D(this, ft, closestDistance, p);
    }

    @NotNull
    public final Segment3D transform(@NotNull Matrix44 transform2) {
        Vector3[] vector3Array;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Vector3 tstart = transform2.times(this.start.getXyz1()).getDiv();
        Vector3 tend = transform2.times(this.end.getXyz1()).getDiv();
        switch (this.control.length) {
            case 2: {
                Vector3[] vector3Array2 = new Vector3[2];
                vector3Array2[0] = transform2.times(this.control[0].getXyz1()).getDiv();
                vector3Array = vector3Array2;
                vector3Array2[1] = transform2.times(this.control[1].getXyz1()).getDiv();
                break;
            }
            case 1: {
                Vector3[] vector3Array3 = new Vector3[1];
                vector3Array = vector3Array3;
                vector3Array3[0] = transform2.times(this.control[0].getXyz1()).getDiv();
                break;
            }
            default: {
                vector3Array = new Vector3[]{};
            }
        }
        Vector3[] tcontrol = vector3Array;
        return new Segment3D(tstart, tcontrol, tend);
    }

    @NotNull
    public final List<Vector3> sampleAdaptive(double distanceTolerance) {
        List<Vector3> list;
        switch (this.control.length) {
            case 0: {
                list = CollectionsKt.listOf(this.start, this.end);
                break;
            }
            case 1: {
                BezierQuadraticSampler3D bezierQuadraticSampler3D = new BezierQuadraticSampler3D();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler3D $this$apply = bezierQuadraticSampler3D;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierQuadraticSampler3D.sample(this.start, this.control[0], this.end).getFirst();
                break;
            }
            case 2: {
                BezierCubicSampler3D bezierCubicSampler3D = new BezierCubicSampler3D();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler3D $this$apply = bezierCubicSampler3D;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierCubicSampler3D.sample(this.start, this.control[0], this.control[1], this.end).getFirst();
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return list;
    }

    public static /* synthetic */ List sampleAdaptive$default(Segment3D segment3D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment3D.sampleAdaptive(d);
    }

    @NotNull
    public final Pair<List<Vector3>, List<Vector3>> sampleAdaptiveNormals(double distanceTolerance) {
        Pair<List<Vector3>, List<Vector3>> pair;
        switch (this.control.length) {
            case 0: {
                pair = new Pair<List<Vector3>, List<Vector3>>(CollectionsKt.listOf(this.start, this.end), CollectionsKt.listOf(this.end.minus(this.start), this.end.minus(this.start)));
                break;
            }
            case 1: {
                BezierQuadraticSampler3D bezierQuadraticSampler3D = new BezierQuadraticSampler3D();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler3D $this$apply = bezierQuadraticSampler3D;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierQuadraticSampler3D.sample(this.start, this.control[0], this.end);
                break;
            }
            case 2: {
                BezierCubicSampler3D bezierCubicSampler3D = new BezierCubicSampler3D();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler3D $this$apply = bezierCubicSampler3D;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierCubicSampler3D.sample(this.start, this.control[0], this.control[1], this.end);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return pair;
    }

    public static /* synthetic */ Pair sampleAdaptiveNormals$default(Segment3D segment3D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment3D.sampleAdaptiveNormals(d);
    }

    public final double getLength() {
        double d;
        switch (this.control.length) {
            case 0: {
                d = this.end.minus(this.start).getLength();
                break;
            }
            case 1: 
            case 2: {
                d = Segment3DKt.access$sumDifferences(Segment3D.sampleAdaptive$default(this, 0.0, 1, null));
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return d;
    }

    @NotNull
    public final Vector3 position(double ut) {
        Vector3 vector3;
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        switch (this.control.length) {
            case 0: {
                vector3 = new Vector3(this.start.getX() * (1.0 - t2) + this.end.getX() * t2, this.start.getY() * (1.0 - t2) + this.end.getY() * t2, this.start.getZ() * (1.0 - t2) + this.end.getZ() * t2);
                break;
            }
            case 1: {
                vector3 = BezierKt.bezier(this.start, this.control[0], this.end, t2);
                break;
            }
            case 2: {
                vector3 = BezierKt.bezier(this.start, this.control[0], this.control[1], this.end, t2);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return vector3;
    }

    @NotNull
    public final Vector3 direction() {
        return this.start.minus(this.end).getNormalized();
    }

    @NotNull
    public final Vector3 direction(double t2) {
        return this.derivative(t2).getNormalized();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> extrema() {
        List list;
        List<List<Vector3>> dpoints = this.dpoints();
        if (this.getLinear()) {
            list = CollectionsKt.emptyList();
        } else if (this.control.length == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Vector3 vector3 = (Vector3)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                collection.add(d);
            }
            List<Double> xRoots = BezierKt.roots((List)destination$iv$iv);
            Iterable $this$map$iv2 = dpoints.get(0);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vector3 bl = (Vector3)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                d = it.getY();
                collection.add(d);
            }
            List<Double> yRoots = BezierKt.roots((List)destination$iv$iv2);
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                double d2 = it;
                if (!(d2 >= 0.0 && d2 <= 1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else if (this.control.length == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Object object;
            Vector3 it;
            Collection collection;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Vector3 element$iv$iv = (Vector3)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = it.getX();
                collection.add(object);
            }
            $this$map$iv = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv);
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (Vector3)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                object.add(d);
            }
            object = (List)destination$iv$iv;
            List xRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$map$iv3 = dpoints.get(0);
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Vector3 bl = (Vector3)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                object = it2.getY();
                collection.add(object);
            }
            $this$map$iv3 = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv3);
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Vector3 it2 = (Vector3)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                d = it2.getY();
                object.add(d);
            }
            object = (List)destination$iv$iv3;
            List yRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Vector3 element$iv$iv : $this$filterTo$iv$iv) {
                double it3 = ((Number)((Object)element$iv$iv)).doubleValue();
                boolean bl = false;
                double d3 = it3;
                if (!(d3 >= 0.0 && d3 <= 1.0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            throw (Throwable)new RuntimeException("not supported");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3> extremaPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.extrema();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector3 vector3 = this.position((double)it);
            collection.add(vector3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Vector3>> dpoints() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add(this.start);
        spreadBuilder.addSpread(this.control);
        spreadBuilder.add(this.end);
        List points = CollectionsKt.listOf((Vector3[])spreadBuilder.toArray(new Vector3[spreadBuilder.size()]));
        int d = points.size();
        int c = d - 1;
        boolean bl = false;
        List dpoints = new ArrayList();
        List p = points;
        while (d > 1) {
            int n = 0;
            List list = new ArrayList();
            n = 0;
            int n2 = c;
            while (n < n2) {
                void j;
                list.add(new Vector3((double)c * (((Vector3)p.get((int)(j + true))).getX() - ((Vector3)p.get((int)j)).getX()), (double)c * (((Vector3)p.get((int)(j + true))).getY() - ((Vector3)p.get((int)j)).getY()), (double)c * (((Vector3)p.get((int)(j + true))).getZ() - ((Vector3)p.get((int)j)).getZ())));
                ++j;
            }
            dpoints.add(list);
            p = list;
            --d;
            --c;
        }
        return dpoints;
    }

    @NotNull
    public final Segment3D getCubic() {
        Segment3D segment3D;
        if (this.control.length == 2) {
            segment3D = this;
        } else if (this.control.length == 1) {
            segment3D = new Segment3D(this.start, this.start.times(0.3333333333333333).plus(this.control[0].times(0.6666666666666666)), this.control[0].times(0.6666666666666666).plus(this.end.times(0.3333333333333333)), this.end);
        } else {
            throw (Throwable)new RuntimeException("cannot convert to cubic segment");
        }
        return segment3D;
    }

    @NotNull
    public final Vector3 derivative(double t2) {
        Vector3 vector3;
        if (this.getLinear()) {
            vector3 = this.start.minus(this.end);
        } else if (this.control.length == 1) {
            vector3 = BezierKt.derivative(this.start, this.control[0], this.end, t2);
        } else if (this.control.length == 2) {
            vector3 = BezierKt.derivative(this.start, this.control[0], this.control[1], this.end, t2);
        } else {
            throw (Throwable)new RuntimeException("not implemented");
        }
        return vector3;
    }

    @NotNull
    public final Segment3D getReverse() {
        Segment3D segment3D;
        switch (this.control.length) {
            case 0: {
                segment3D = new Segment3D(this.end, this.start);
                break;
            }
            case 1: {
                segment3D = new Segment3D(this.end, this.control[0], this.start);
                break;
            }
            case 2: {
                segment3D = new Segment3D(this.end, this.control[1], this.control[0], this.start);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return segment3D;
    }

    @NotNull
    public final Segment3D sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final Segment3D[] split(double t2) {
        double u = RangesKt.coerceIn(t2, 0.0, 1.0);
        if (this.getLinear()) {
            Vector3 cut = this.start.plus(this.end.minus(this.start).times(u));
            return new Segment3D[]{new Segment3D(this.start, cut), new Segment3D(cut, this.end)};
        }
        if (this.control.length == 2) {
            double z = u;
            double z2 = z * z;
            double z3 = z * z * z;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double iz3 = iz * iz * iz;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.control[1].getX(), this.end.getX());
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.control[1].getY(), this.end.getY());
            Vector4 pz = new Vector4(this.start.getZ(), this.control[0].getZ(), this.control[1].getZ(), this.end.getZ());
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Vector4 plz = lsm.times(pz);
            Vector3 pl0 = new Vector3(plx.getX(), ply.getX(), plz.getX());
            Vector3 pl1 = new Vector3(plx.getY(), ply.getY(), plz.getY());
            Vector3 pl2 = new Vector3(plx.getZ(), ply.getZ(), plz.getZ());
            Vector3 pl3 = new Vector3(plx.getW(), ply.getW(), plz.getW());
            Segment3D left = new Segment3D(pl0, pl1, pl2, pl3);
            Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Vector4 prz = rsm.times(pz);
            Vector3 pr0 = new Vector3(prx.getX(), pry.getX(), prz.getX());
            Vector3 pr1 = new Vector3(prx.getY(), pry.getY(), prz.getY());
            Vector3 pr2 = new Vector3(prx.getZ(), pry.getZ(), prz.getZ());
            Vector3 pr3 = new Vector3(prx.getW(), pry.getW(), prz.getW());
            Segment3D right = new Segment3D(pr0, pr1, pr2, pr3);
            return new Segment3D[]{left, right};
        }
        if (this.control.length == 1) {
            double z = u;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double z2 = z * z;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.end.getX(), 0.0);
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.end.getY(), 0.0);
            Vector4 pz = new Vector4(this.start.getZ(), this.control[0].getZ(), this.end.getZ(), 0.0);
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Vector4 plz = lsm.times(pz);
            Segment3D left = new Segment3D(new Vector3(plx.getX(), ply.getX(), plz.getX()), new Vector3(plx.getY(), ply.getY(), plz.getY()), new Vector3(plx.getZ(), ply.getZ(), plz.getZ()));
            Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Vector4 prz = rsm.times(pz);
            Segment3D right = new Segment3D(new Vector3(prx.getX(), pry.getX(), prz.getX()), new Vector3(prx.getY(), pry.getY(), prz.getY()), new Vector3(prx.getZ(), pry.getZ(), prz.getZ()));
            return new Segment3D[]{left, right};
        }
        throw (Throwable)new RuntimeException("not implemented");
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Segment(start=").append(this.start).append(", end=").append(this.end).append(", control=");
        Object[] objectArray = this.control;
        boolean bl = false;
        String string = Arrays.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "java.util.Arrays.toString(this)");
        return stringBuilder.append(string).append(')').toString();
    }

    @NotNull
    public final Segment3D copy(@NotNull Vector3 start2, @NotNull Vector3[] control, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end2, "end");
        return new Segment3D(start2, control, end2);
    }

    public static /* synthetic */ Segment3D copy$default(Segment3D segment3D, Vector3 vector3, Vector3[] vector3Array, Vector3 vector32, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = segment3D.start;
        }
        if ((n & 2) != 0) {
            vector3Array = segment3D.control;
        }
        if ((n & 4) != 0) {
            vector32 = segment3D.end;
        }
        return segment3D.copy(vector3, vector3Array, vector32);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrndr.shape.Segment3D");
        }
        Segment3D cfr_ignored_0 = (Segment3D)object2;
        if (Intrinsics.areEqual(this.start, ((Segment3D)other).start) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.end, ((Segment3D)other).end) ^ true) {
            return false;
        }
        Object[] objectArray = this.control;
        Object[] objectArray2 = ((Segment3D)other).control;
        boolean bl = false;
        return Arrays.equals(objectArray, objectArray2);
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = 31 * result2 + this.end.hashCode();
        Object[] objectArray = this.control;
        boolean bl = false;
        result2 = 31 * result2 + Arrays.hashCode(objectArray);
        return result2;
    }

    public Segment3D(@NotNull Vector3 start2, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.end = end2;
        this.control = new Vector3[0];
    }

    public Segment3D(@NotNull Vector3 start2, @NotNull Vector3 c0, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = new Vector3[]{c0};
        this.end = end2;
    }

    public Segment3D(@NotNull Vector3 start2, @NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = new Vector3[]{c0, c1};
        this.end = end2;
    }

    public Segment3D(@NotNull Vector3 start2, @NotNull Vector3[] control, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = control;
        this.end = end2;
    }
}

