/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 I2\u00020\u0001:\u0001IB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0086\u0002J'\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010)\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u0011\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0002J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\tJ\u0018\u00103\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00032\b\b\u0002\u00104\u001a\u00020\u0003J\u0011\u00105\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0002J\u0016\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003J,\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u00109\u001a\u00020\u00032\b\b\u0002\u0010:\u001a\u00020\u00032\b\b\u0002\u0010;\u001a\u00020\u0003J\u001a\u0010<\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u00109\u001a\u00020\u0003H\u0007J&\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010C\u001a\u00020DJ\t\u0010E\u001a\u00020FH\u00d6\u0001J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0003R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u0006J"}, d2={"Lorg/openrndr/shape/Rectangle;", "", "x", "", "y", "width", "height", "(DDDD)V", "corner", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;DD)V", "area", "getArea", "()D", "center", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getCorner", "dimensions", "getDimensions", "getHeight", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getWidth", "getX", "getY", "component1", "component2", "component3", "contains", "", "point", "copy", "div", "scale", "equals", "other", "hashCode", "", "heightScaledTo", "fitHeight", "minus", "right", "moved", "offset", "offsetEdges", "offsetY", "plus", "position", "u", "v", "scaleY", "anchorU", "anchorV", "scaled", "sub", "u0", "v0", "u1", "v1", "times", "toInt", "Lorg/openrndr/shape/IntRectangle;", "toString", "", "widthScaledTo", "fitWidth", "Companion", "openrndr-core"})
public final class Rectangle {
    @NotNull
    private final Vector2 corner;
    private final double width;
    private final double height;
    @NotNull
    private static final Rectangle EMPTY;
    public static final Companion Companion;

    @NotNull
    public final Vector2 getCenter() {
        return this.corner.plus(new Vector2(this.width / (double)2, this.height / (double)2));
    }

    public final double getArea() {
        return this.width * this.height;
    }

    @NotNull
    public final Vector2 getDimensions() {
        return new Vector2(this.width, this.height);
    }

    @NotNull
    public final Vector2 position(double u, double v) {
        return this.corner.plus(new Vector2(u * this.width, v * this.height));
    }

    public final double getX() {
        return this.corner.getX();
    }

    public final double getY() {
        return this.corner.getY();
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        return Intrinsics.areEqual(this.corner, Vector2.Companion.getINFINITY()) || this.corner.getX() != this.corner.getX() || this.corner.getY() != this.corner.getY() || this.width != this.width || this.height != this.height ? ShapeContour.Companion.getEMPTY() : ShapeContour.Companion.fromPoints(CollectionsKt.listOf(this.corner, this.corner.plus(new Vector2(this.width, 0.0)), this.corner.plus(new Vector2(this.width, this.height)), this.corner.plus(new Vector2(0.0, this.height))), true, YPolarity.CW_NEGATIVE_Y);
    }

    @NotNull
    public final Rectangle offsetEdges(double offset2, double offsetY) {
        return new Rectangle(new Vector2(this.corner.getX() - offset2, this.corner.getY() - offsetY), this.width + (double)2 * offset2, this.height + (double)2 * offsetY);
    }

    public static /* synthetic */ Rectangle offsetEdges$default(Rectangle rectangle, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return rectangle.offsetEdges(d, d2);
    }

    @NotNull
    public final Rectangle scale(double scale2, double scaleY, double anchorU, double anchorV) {
        Vector2 d = this.corner.minus(this.position(anchorU, anchorV));
        Vector2 nd = this.position(anchorU, anchorV).plus(d.times(new Vector2(scale2, scaleY)));
        return new Rectangle(nd, this.width * scale2, this.height * scaleY);
    }

    public static /* synthetic */ Rectangle scale$default(Rectangle rectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        if ((n & 4) != 0) {
            d3 = 0.5;
        }
        if ((n & 8) != 0) {
            d4 = 0.5;
        }
        return rectangle.scale(d, d2, d3, d4);
    }

    @Deprecated(message="use scale instead")
    @NotNull
    public final Rectangle scaled(double scale2, double scaleY) {
        return new Rectangle(this.corner, this.width * scale2, this.height * scaleY);
    }

    public static /* synthetic */ Rectangle scaled$default(Rectangle rectangle, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return rectangle.scaled(d, d2);
    }

    @NotNull
    public final Rectangle widthScaledTo(double fitWidth) {
        double scale2 = fitWidth / this.width;
        return new Rectangle(this.corner, fitWidth, this.height * scale2);
    }

    @NotNull
    public final Rectangle heightScaledTo(double fitHeight) {
        double scale2 = fitHeight / this.height;
        return new Rectangle(this.corner, this.width * scale2, fitHeight);
    }

    @NotNull
    public final Rectangle moved(@NotNull Vector2 offset2) {
        Intrinsics.checkNotNullParameter(offset2, "offset");
        return new Rectangle(this.corner.plus(offset2), this.width, this.height);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return point.getX() >= this.corner.getX() && point.getX() < this.corner.getX() + this.width && point.getY() >= this.corner.getY() && point.getY() < this.corner.getY() + this.height;
    }

    @NotNull
    public final Rectangle times(double scale2) {
        return new Rectangle(this.corner.times(scale2), this.width * scale2, this.height * scale2);
    }

    @NotNull
    public final Rectangle div(double scale2) {
        return new Rectangle(this.corner.div(scale2), this.width / scale2, this.height / scale2);
    }

    @NotNull
    public final Rectangle plus(@NotNull Rectangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Rectangle(this.corner.plus(right.corner), this.width + right.width, this.height + right.height);
    }

    @NotNull
    public final Rectangle minus(@NotNull Rectangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Rectangle(this.corner.minus(right.corner), this.width - right.width, this.height - right.height);
    }

    @NotNull
    public final Rectangle sub(double u0, double v0, double u1, double v1) {
        Vector2 p0 = this.position(u0, v0);
        Vector2 p1 = this.position(u1, v1);
        double width = p1.getX() - p0.getX();
        double height = p1.getY() - p0.getY();
        return new Rectangle(p0.getX(), p0.getY(), width, height);
    }

    @NotNull
    public final IntRectangle toInt() {
        return new IntRectangle((int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height);
    }

    @NotNull
    public final Vector2 getCorner() {
        return this.corner;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Rectangle(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
    }

    public /* synthetic */ Rectangle(Vector2 vector2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        this(vector2, d, d2);
    }

    public Rectangle(double x, double y, double width, double height) {
        this(new Vector2(x, y), width, height);
    }

    public /* synthetic */ Rectangle(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = d3;
        }
        this(d, d2, d3, d4);
    }

    static {
        Companion = new Companion(null);
        EMPTY = new Rectangle(0.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final Vector2 component1() {
        return this.corner;
    }

    public final double component2() {
        return this.width;
    }

    public final double component3() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        return new Rectangle(corner, width, height);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = rectangle.corner;
        }
        if ((n & 2) != 0) {
            d = rectangle.width;
        }
        if ((n & 4) != 0) {
            d2 = rectangle.height;
        }
        return rectangle.copy(vector2, d, d2);
    }

    @NotNull
    public String toString() {
        return "Rectangle(corner=" + this.corner + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.corner;
        long l = Double.doubleToLongBits(this.width);
        long l2 = Double.doubleToLongBits(this.height);
        return ((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Rectangle)) break block3;
                Rectangle rectangle = (Rectangle)object;
                if (!Intrinsics.areEqual(this.corner, rectangle.corner) || Double.compare(this.width, rectangle.width) != 0 || Double.compare(this.height, rectangle.height) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/openrndr/shape/Rectangle$Companion;", "", "()V", "EMPTY", "Lorg/openrndr/shape/Rectangle;", "getEMPTY", "()Lorg/openrndr/shape/Rectangle;", "fromCenter", "center", "Lorg/openrndr/math/Vector2;", "width", "", "height", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final Rectangle fromCenter(@NotNull Vector2 center, double width, double height) {
            Intrinsics.checkNotNullParameter(center, "center");
            return new Rectangle(center.getX() - width / 2.0, center.getY() - height / 2.0, width, height);
        }

        public static /* synthetic */ Rectangle fromCenter$default(Companion companion, Vector2 vector2, double d, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = d;
            }
            return companion.fromCenter(vector2, d, d2);
        }

        @NotNull
        public final Rectangle getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

