/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Path3D;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0003J\u0019\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000%2\u0006\u0010#\u001a\u00020\u0003\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/openrndr/shape/LineSegment3D;", "", "x0", "", "y0", "z0", "x1", "y1", "z1", "(DDDDDD)V", "start", "Lorg/openrndr/math/Vector3;", "end", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "direction", "getDirection", "()Lorg/openrndr/math/Vector3;", "getEnd", "path", "Lorg/openrndr/shape/Path3D;", "getPath", "()Lorg/openrndr/shape/Path3D;", "getStart", "component1", "component2", "copy", "distance", "query", "equals", "", "other", "hashCode", "", "nearest", "position", "t", "split", "", "(D)[Lorg/openrndr/shape/LineSegment3D;", "squaredDistance", "sub", "t0", "t1", "toString", "", "openrndr-core"})
public final class LineSegment3D {
    @NotNull
    private final Vector3 start;
    @NotNull
    private final Vector3 end;

    @NotNull
    public final Vector3 getDirection() {
        return this.end.minus(this.start);
    }

    @NotNull
    public final Vector3 nearest(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        double l2 = this.end.minus(this.start).getSquaredLength();
        if (l2 == 0.0) {
            return this.start;
        }
        double t2 = ((query.getX() - this.start.getX()) * (this.end.getX() - this.start.getX()) + (query.getY() - this.start.getY()) * (this.end.getY() - this.start.getY()) + (query.getZ() - this.start.getZ()) * (this.end.getZ() - this.start.getZ())) / l2;
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        d2 = Math.min(d2, t2);
        bl = false;
        t2 = Math.max(d, d2);
        return new Vector3(this.start.getX() + t2 * (this.end.getX() - this.start.getX()), this.start.getY() + t2 * (this.end.getY() - this.start.getY()), this.start.getZ() + t2 * (this.end.getZ() - this.start.getZ()));
    }

    public final double distance(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).minus(query).getLength();
    }

    public final double squaredDistance(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).minus(query).getSquaredLength();
    }

    @NotNull
    public final LineSegment3D sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final LineSegment3D[] split(double t2) {
        double u = RangesKt.coerceIn(t2, 0.0, 1.0);
        Vector3 cut = this.start.plus(this.end.minus(this.start).times(u));
        return new LineSegment3D[]{new LineSegment3D(this.start, cut), new LineSegment3D(cut, this.end)};
    }

    @NotNull
    public final Vector3 position(double t2) {
        return this.start.plus(this.end.minus(this.start).times(t2));
    }

    @NotNull
    public final Path3D getPath() {
        return Path3D.Companion.fromPoints(CollectionsKt.listOf(this.start, this.end), false);
    }

    @NotNull
    public final Vector3 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector3 getEnd() {
        return this.end;
    }

    public LineSegment3D(@NotNull Vector3 start2, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.end = end2;
    }

    public LineSegment3D(double x0, double y0, double z0, double x1, double y1, double z1) {
        this(new Vector3(x0, y0, z0), new Vector3(x1, y1, z1));
    }

    @NotNull
    public final Vector3 component1() {
        return this.start;
    }

    @NotNull
    public final Vector3 component2() {
        return this.end;
    }

    @NotNull
    public final LineSegment3D copy(@NotNull Vector3 start2, @NotNull Vector3 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        return new LineSegment3D(start2, end2);
    }

    public static /* synthetic */ LineSegment3D copy$default(LineSegment3D lineSegment3D, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = lineSegment3D.start;
        }
        if ((n & 2) != 0) {
            vector32 = lineSegment3D.end;
        }
        return lineSegment3D.copy(vector3, vector32);
    }

    @NotNull
    public String toString() {
        return "LineSegment3D(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        Vector3 vector3 = this.start;
        Vector3 vector32 = this.end;
        return (vector3 != null ? ((Object)vector3).hashCode() : 0) * 31 + (vector32 != null ? ((Object)vector32).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LineSegment3D)) break block3;
                LineSegment3D lineSegment3D = (LineSegment3D)object;
                if (!Intrinsics.areEqual(this.start, lineSegment3D.start) || !Intrinsics.areEqual(this.end, lineSegment3D.end)) break block3;
            }
            return true;
        }
        return false;
    }
}

