/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.Circle;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Segment;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001fJ6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060(2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010.\u001a\u00020\u001dJ \u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001f2\b\b\u0002\u00102\u001a\u00020\u001fJ0\u0010/\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001f2\b\b\u0002\u00102\u001a\u00020\u001fJ\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00062\b\b\u0002\u00102\u001a\u00020\u001fJ \u0010/\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\b\b\u0002\u00102\u001a\u00020\u001fJ&\u00106\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ6\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ\u0016\u00106\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u001e\u00106\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u0016\u0010>\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ\u000e\u0010>\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0006J&\u0010?\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ6\u0010?\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ\u0016\u0010?\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u001e\u0010?\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u0016\u0010@\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ\u000e\u0010@\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0006J\u0016\u0010A\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fJ\u000e\u0010A\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0006J\u0006\u0010B\u001a\u00020\u001dJ\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u0014J\b\u0010D\u001a\u0004\u0018\u00010\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006E"}, d2={"Lorg/openrndr/shape/ContourBuilder;", "", "multipleContours", "", "(Z)V", "anchor", "Lorg/openrndr/math/Vector2;", "getAnchor", "()Lorg/openrndr/math/Vector2;", "setAnchor", "(Lorg/openrndr/math/Vector2;)V", "contours", "", "Lorg/openrndr/shape/ShapeContour;", "getContours$openrndr_core", "()Ljava/util/List;", "cursor", "getCursor", "setCursor", "lastSegment", "Lorg/openrndr/shape/Segment;", "getLastSegment", "()Lorg/openrndr/shape/Segment;", "result", "", "getResult", "segments", "getSegments", "arcTo", "", "crx", "", "cry", "angle", "largeArcFlag", "sweepFlag", "tx", "ty", "end", "arcToBeziers", "", "angleStart", "angleExtent", "(DD)[Lorg/openrndr/math/Vector2;", "circularArcTo", "through", "close", "continueTo", "x", "y", "tangentScale", "cx", "cy", "control", "curveTo", "c0x", "c0y", "c1x", "c1y", "position", "control0", "control1", "lineTo", "moveOrCurveTo", "moveOrLineTo", "moveTo", "reverse", "segment", "undo", "openrndr-core"})
public final class ContourBuilder {
    @NotNull
    private Vector2 cursor;
    @NotNull
    private Vector2 anchor;
    @NotNull
    private final List<Segment> segments;
    @NotNull
    private final List<ShapeContour> contours;
    private final boolean multipleContours;

    @NotNull
    public final Vector2 getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.cursor = vector2;
    }

    @NotNull
    public final Vector2 getAnchor() {
        return this.anchor;
    }

    public final void setAnchor(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.anchor = vector2;
    }

    @NotNull
    public final List<Segment> getSegments() {
        return this.segments;
    }

    @NotNull
    public final List<ShapeContour> getContours$openrndr_core() {
        return this.contours;
    }

    /*
     * WARNING - void declaration
     */
    public final void moveTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = this.multipleContours || this.anchor == Vector2.Companion.getINFINITY();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "pen only can only be moved once per contour, use 'contours {}' to create multiple contours";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.multipleContours) {
            Iterable iterable = this.segments;
            bl2 = false;
            if (!iterable.isEmpty()) {
                Collection<void> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                iterable = this.segments;
                List<ShapeContour> list = this.contours;
                boolean $i$f$map = false;
                void var4_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Segment segment = (Segment)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    void var15_17 = it;
                    collection.add(var15_17);
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                YPolarity yPolarity = null;
                boolean bl6 = false;
                List list2 = collection;
                list.add(new ShapeContour(list2, bl6, yPolarity, n, defaultConstructorMarker));
                this.segments.clear();
            }
        }
        this.cursor = position;
        this.anchor = position;
    }

    public final void moveTo(double x, double y) {
        this.moveTo(new Vector2(x, y));
    }

    public final void moveOrLineTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.lineTo(position);
        }
    }

    public final void moveOrLineTo(double x, double y) {
        this.moveOrLineTo(new Vector2(x, y));
    }

    public final void moveOrCurveTo(@NotNull Vector2 control, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control, position);
        }
    }

    public final void moveOrCurveTo(double cx, double cy, double x, double y) {
        this.moveOrCurveTo(new Vector2(cx, cy), new Vector2(x, y));
    }

    public final void moveOrCurveTo(@NotNull Vector2 control0, @NotNull Vector2 control1, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control0, control1, position);
        }
    }

    public final void moveOrCurveTo(double c0x, double c0y, double c1x, double c1y, double x, double y) {
        this.moveOrCurveTo(new Vector2(c0x, c0y), new Vector2(c1x, c1y), new Vector2(x, y));
    }

    public final void lineTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = this.cursor != Vector2.Companion.getINFINITY();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "use moveTo first";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).getLength() > 0.0) {
            Segment segment = new Segment(this.cursor, position, false, 4, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void lineTo(double x, double y) {
        this.lineTo(new Vector2(x, y));
    }

    public final void curveTo(@NotNull Vector2 control, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = this.cursor != Vector2.Companion.getINFINITY();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "use moveTo first";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).getSquaredLength() > 0.0) {
            Segment segment = new Segment(this.cursor, control, position, false, 8, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void curveTo(double cx, double cy, double x, double y) {
        this.curveTo(new Vector2(cx, cy), new Vector2(x, y));
    }

    public final void curveTo(@NotNull Vector2 control0, @NotNull Vector2 control1, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = this.cursor != Vector2.Companion.getINFINITY();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "use moveTo first";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).getSquaredLength() > 0.0) {
            Segment segment = new Segment(this.cursor, control0, control1, position, false, 16, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void curveTo(double c0x, double c0y, double c1x, double c1y, double x, double y) {
        this.curveTo(new Vector2(c0x, c0y), new Vector2(c1x, c1y), new Vector2(x, y));
    }

    /*
     * WARNING - void declaration
     */
    public final void close() {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection2 = this.segments;
        boolean bl = false;
        boolean bl2 = !collection2.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "cannot close contour with 0 segments";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.anchor.minus(this.cursor).getLength() > 0.001) {
            this.segments.add(new Segment(this.cursor, this.anchor, false, 4, null));
        }
        Iterable iterable = this.segments;
        List<ShapeContour> list = this.contours;
        boolean $i$f$map = false;
        void var3_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            void var14_17 = it;
            collection.add(var14_17);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        YPolarity yPolarity = null;
        boolean bl6 = true;
        List list2 = collection;
        list.add(new ShapeContour(list2, bl6, yPolarity, n, defaultConstructorMarker));
        this.segments.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void reverse() {
        Iterable $this$forEachIndexed$iv = this.segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment segment2 = (Segment)item$iv;
            int index = n;
            boolean bl2 = false;
            this.segments.set(index, segment.getReverse());
        }
        CollectionsKt.reverse(this.segments);
    }

    public final void circularArcTo(@NotNull Vector2 through, @NotNull Vector2 end2) {
        Intrinsics.checkNotNullParameter(through, "through");
        Intrinsics.checkNotNullParameter(end2, "end");
        Circle circle = Circle.Companion.fromPoints(this.cursor, through, end2);
        Vector2 tc = through.minus(circle.getCenter()).getNormalized();
        Vector2 ec = end2.minus(circle.getCenter()).getNormalized();
        double d = tc.dot(ec);
        boolean bl = false;
        double angle = Math.toDegrees(Math.acos(d));
        boolean side = end2.minus(this.cursor).dot(through.minus(this.cursor)) > 0.0;
        boolean largeArc = circle.getRadius() > end2.distanceTo(this.cursor) / 2.0;
        this.arcTo(circle.getRadius(), circle.getRadius(), angle, largeArc, side, end2);
    }

    /*
     * WARNING - void declaration
     */
    public final void arcTo(double crx, double cry, double angle, boolean largeArcFlag, boolean sweepFlag, double tx, double ty) {
        double n1;
        double p1;
        arcTo.2 $fun$checkedAcos$2;
        double tdy;
        double tdx;
        double angleRad;
        block16: {
            block15: {
                boolean bl = this.cursor != Vector2.Companion.getINFINITY();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "use moveTo first";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                angleRad = Math.toRadians(FunctionsKt.modDouble(angle, 360.0));
                tdx = this.cursor.getX() - tx;
                if (tdx * tdx + (tdy = this.cursor.getY() - ty) * tdy == 0.0) {
                    return;
                }
                double radiiEpsilon = 1.0E-5;
                boolean bl5 = false;
                if (Math.abs(crx) <= radiiEpsilon) break block15;
                bl5 = false;
                if (!(Math.abs(cry) <= radiiEpsilon)) break block16;
            }
            this.lineTo(new Vector2(tx, ty));
            return;
        }
        boolean bl = false;
        double rx = Math.abs(crx);
        boolean bl6 = false;
        double ry = Math.abs(cry);
        boolean bl7 = false;
        double cosAngle = Math.cos(angleRad);
        boolean bl8 = false;
        double sinAngle = Math.sin(angleRad);
        double dx2 = (this.cursor.getX() - tx) / 2.0;
        double dy2 = (this.cursor.getY() - ty) / 2.0;
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double rxSqr = rx * rx;
        double rySqr = ry * ry;
        double y1Sqr = y1 * y1;
        double x1Sqr = x1 * x1;
        double radiiCheck = x1 * x1 / (rx * rx) + y1 * y1 / (ry * ry);
        if (radiiCheck > 1.0) {
            boolean bl9 = false;
            rx *= Math.sqrt(radiiCheck);
            bl9 = false;
            ry *= Math.sqrt(radiiCheck);
        }
        double sign0 = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (rxSqr * rySqr - rxSqr * y1Sqr - rySqr * x1Sqr) / (rxSqr * y1Sqr + rySqr * x1Sqr);
        sq = sq < 0.0 ? 0.0 : sq;
        boolean bl10 = false;
        double coef = sign0 * Math.sqrt(sq);
        double cx1 = coef * (rx * y1 / ry);
        double cy1 = coef * -(ry * x1 / rx);
        double sx2 = (this.cursor.getX() + tx) / 2.0;
        double sy2 = (this.cursor.getY() + ty) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx;
        double uy = (y1 - cy1) / ry;
        double vx = (-x1 - cx1) / rx;
        double vy = (-y1 - cy1) / ry;
        double d = ux * ux + uy * uy;
        boolean bl11 = false;
        double n0 = Math.sqrt(d);
        double p0 = ux;
        double sign1 = uy < 0.0 ? -1.0 : 1.0;
        double d2 = p0 / n0;
        boolean bl12 = false;
        double angleStart = sign1 * Math.acos(d2);
        double d3 = (ux * ux + uy * uy) * (vx * vx + vy * vy);
        boolean bl13 = false;
        double sign2 = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = sign2 * ($fun$checkedAcos$2 = arcTo.2.INSTANCE).invoke((p1 = ux * vx + uy * vy) / (n1 = Math.sqrt(d3)));
        if (angleExtent == 0.0) {
            this.lineTo(tx, ty);
            return;
        }
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= Math.PI * 2;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += Math.PI * 2;
        }
        Vector2[] bezierPoints = this.arcToBeziers(angleStart %= Math.PI * 2, angleExtent %= Math.PI * 2);
        bezierPoints[ArraysKt.getLastIndex(bezierPoints)] = new Vector2(tx, ty);
        int n = 0;
        int n2 = bezierPoints.length;
        while (n < n2) {
            void i;
            double x = bezierPoints[i].getX();
            double y = bezierPoints[i].getY();
            bezierPoints[i] = new Vector2(cosAngle * rx * x + -sinAngle * ry * y + cx, sinAngle * rx * x + cosAngle * ry * y + cy);
            ++i;
        }
        Vector2[] i = bezierPoints;
        n2 = 0;
        Object object = i;
        boolean bl14 = false;
        if (!(((Vector2[])object).length == 0)) {
            bezierPoints[bezierPoints.length - 1] = new Vector2(tx, ty);
            for (int i2 = 0; i2 < bezierPoints.length; i2 += 3) {
                try {
                    this.curveTo(bezierPoints[i2], bezierPoints[i2 + 1], bezierPoints[i2 + 2]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    object = "radii: " + crx + ' ' + cry + ", deltas: " + tdx + ' ' + tdy + " [" + i2 + "] " + bezierPoints[i2] + ", " + bezierPoints[i2 + 1] + ", " + bezierPoints[i2 + 2];
                    bl14 = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
            }
        }
        this.cursor = new Vector2(tx, ty);
    }

    public final void arcTo(double crx, double cry, double angle, boolean largeArcFlag, boolean sweepFlag, @NotNull Vector2 end2) {
        Intrinsics.checkNotNullParameter(end2, "end");
        this.arcTo(crx, cry, angle, largeArcFlag, sweepFlag, end2.getX(), end2.getY());
    }

    public final void continueTo(@NotNull Vector2 end2, double tangentScale) {
        Intrinsics.checkNotNullParameter(end2, "end");
        if (this.cursor.minus(end2).getSquaredLength() > 0.0) {
            Collection collection = this.segments;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Segment last2 = CollectionsKt.last(this.segments);
                Vector2 delta = ArraysKt.last(last2.getControl()).minus(last2.getEnd());
                this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), end2);
            } else {
                this.curveTo(this.cursor.plus(end2.minus(this.cursor).div(2.0)), end2);
            }
        }
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, d);
    }

    public final void continueTo(double x, double y, double tangentScale) {
        this.continueTo(new Vector2(x, y), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        contourBuilder.continueTo(d, d2, d3);
    }

    public final void continueTo(@NotNull Vector2 control, @NotNull Vector2 end2, double tangentScale) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end2, "end");
        Collection collection = this.segments;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Segment last2 = CollectionsKt.last(this.segments);
            Vector2 delta = ArraysKt.last(last2.getControl()).minus(last2.getEnd());
            this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), control, end2);
        } else {
            this.curveTo(this.cursor.plus(end2.minus(this.cursor).div(3.0)), control, end2);
        }
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, Vector2 vector22, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, vector22, d);
    }

    public final void continueTo(double cx, double cy, double x, double y, double tangentScale) {
        this.continueTo(new Vector2(cx, cy), new Vector2(x, y), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, double d, double d2, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d5 = 1.0;
        }
        contourBuilder.continueTo(d, d2, d3, d4, d5);
    }

    /*
     * WARNING - void declaration
     */
    private final Vector2[] arcToBeziers(double angleStart, double angleExtent) {
        boolean bl = false;
        double d = Math.abs(angleExtent) * 2.0 / Math.PI;
        boolean bl2 = false;
        int numSegments = (int)Math.ceil(d);
        double angleIncrement = angleExtent / (double)numSegments;
        double d2 = angleIncrement / 2.0;
        boolean bl3 = false;
        double d3 = 1.3333333333333333 * Math.sin(d2);
        d2 = angleIncrement / 2.0;
        bl3 = false;
        double controlLength = d3 / (1.0 + Math.cos(d2));
        int n = numSegments * 3;
        Vector2[] vector2Array = new Vector2[n];
        int n2 = 0;
        while (n2 < n) {
            Vector2 vector2;
            int n3 = n2;
            int n4 = n2++;
            Vector2[] vector2Array2 = vector2Array;
            boolean bl4 = false;
            vector2Array2[n4] = vector2 = Vector2.Companion.getZERO();
        }
        Vector2[] coords = vector2Array;
        int pos = 0;
        int n5 = 0;
        n2 = numSegments;
        while (n5 < n2) {
            void i;
            double angle = angleStart + (double)i * angleIncrement;
            boolean bl5 = false;
            double dx = Math.cos(angle);
            boolean bl6 = false;
            double dy = Math.sin(angle);
            coords[pos] = new Vector2(dx - controlLength * dy, dy + controlLength * dx);
            bl6 = false;
            dx = Math.cos(angle += angleIncrement);
            bl6 = false;
            dy = Math.sin(angle);
            coords[++pos] = new Vector2(dx + controlLength * dy, dy - controlLength * dx);
            coords[++pos] = new Vector2(dx, dy);
            ++pos;
            ++i;
        }
        return coords;
    }

    public final void segment(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        if (this.cursor != Vector2.Companion.getINFINITY()) {
            boolean bl = segment.getStart().minus(this.cursor).getLength() < 0.01;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "segment is disconnected: cursor: " + this.cursor + ", segment.start: " + segment.getStart() + ", distance: " + this.cursor.minus(segment.getStart()).getLength();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        if (this.cursor == Vector2.Companion.getINFINITY()) {
            this.moveTo(segment.getStart());
        }
        if (segment.getLinear()) {
            this.lineTo(segment.getEnd());
        } else if (segment.getControl().length == 1) {
            this.curveTo(segment.getControl()[0], segment.getEnd());
        } else {
            this.curveTo(segment.getControl()[0], segment.getControl()[1], segment.getEnd());
        }
    }

    @Nullable
    public final Segment undo() {
        Collection collection;
        Collection collection2 = this.segments;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            Segment r = this.segments.remove(CollectionsKt.getLastIndex(this.segments));
            this.cursor = r.getStart();
            collection = collection2;
        } else {
            collection = null;
        }
        return collection;
    }

    @Nullable
    public final Segment getLastSegment() {
        return CollectionsKt.lastOrNull(this.segments);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShapeContour> getResult() {
        List<Object> list;
        Collection collection = this.contours;
        Iterable iterable = this.segments;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            Collection<void> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = this.segments;
            Collection collection3 = collection;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment segment = (Segment)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                void var14_12 = it;
                collection2.add(var14_12);
            }
            collection2 = (List)destination$iv$iv;
            collection = collection3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            YPolarity yPolarity = null;
            boolean bl3 = false;
            List list2 = collection2;
            list = CollectionsKt.listOf(new ShapeContour(list2, bl3, yPolarity, n, defaultConstructorMarker));
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list);
    }

    public ContourBuilder(boolean multipleContours) {
        this.multipleContours = multipleContours;
        this.cursor = Vector2.Companion.getINFINITY();
        this.anchor = Vector2.Companion.getINFINITY();
        boolean bl = false;
        this.segments = new ArrayList();
        bl = false;
        this.contours = new ArrayList();
    }
}

