/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector4;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 H2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001HB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\t\u0010*\u001a\u00020\u0004H\u00c6\u0003J\t\u0010+\u001a\u00020\u0004H\u00c6\u0003J\t\u0010,\u001a\u00020\u0004H\u00c6\u0003J\t\u0010-\u001a\u00020\u0004H\u00c6\u0003J1\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004H\u00c6\u0001J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0000J\u0011\u0010\n\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010\n\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0002J\u0013\u00103\u001a\u0002042\b\u00100\u001a\u0004\u0018\u000105H\u00d6\u0003J\u0011\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u000208H\u0086\u0002J\t\u00109\u001a\u000208H\u00d6\u0001J\u0011\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010:\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0004J\u0011\u0010>\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010>\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010?\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020DJ\t\u0010E\u001a\u00020FH\u00d6\u0001J\t\u0010G\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0011\u0010!\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001bR\u0011\u0010#\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010R\u0011\u0010&\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0011\u0010(\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001b\u00a8\u0006I"}, d2={"Lorg/openrndr/math/Vector4;", "Ljava/io/Serializable;", "Lorg/openrndr/math/LinearType;", "x", "", "(D)V", "y", "z", "w", "(DDDD)V", "div", "Lorg/openrndr/math/Vector3;", "getDiv", "()Lorg/openrndr/math/Vector3;", "length", "getLength", "()D", "normalized", "getNormalized", "()Lorg/openrndr/math/Vector4;", "squaredLength", "getSquaredLength", "getW", "getX", "xy", "Lorg/openrndr/math/Vector2;", "getXy", "()Lorg/openrndr/math/Vector2;", "xyz", "getXyz", "xz", "getXz", "getY", "yx", "getYx", "yz", "getYz", "getZ", "zx", "getZx", "zy", "getZy", "component1", "component2", "component3", "component4", "copy", "distanceTo", "other", "s", "v", "equals", "", "", "get", "i", "", "hashCode", "minus", "d", "mix", "o", "plus", "squaredDistanceTo", "times", "toDoubleArray", "", "toInt", "Lorg/openrndr/math/IntVector4;", "toString", "", "unaryMinus", "Companion", "openrndr-math"})
public final class Vector4
implements Serializable,
LinearType<Vector4> {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Vector4 UNIT_X;
    @NotNull
    private static final Vector4 UNIT_Y;
    @NotNull
    private static final Vector4 UNIT_Z;
    @NotNull
    private static final Vector4 UNIT_W;
    @NotNull
    private static final Vector4 ZERO;
    @NotNull
    private static final Vector4 ONE;
    public static final Companion Companion;

    @NotNull
    public final Vector2 getXy() {
        return new Vector2(this.x, this.y);
    }

    @NotNull
    public final Vector2 getYx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 getXz() {
        return new Vector2(this.x, this.z);
    }

    @NotNull
    public final Vector2 getYz() {
        return new Vector2(this.y, this.z);
    }

    @NotNull
    public final Vector2 getZx() {
        return new Vector2(this.z, this.x);
    }

    @NotNull
    public final Vector2 getZy() {
        return new Vector2(this.z, this.y);
    }

    @NotNull
    public final Vector3 getXyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector3 getDiv() {
        return new Vector3(this.x / this.w, this.y / this.w, this.z / this.w);
    }

    public final double getLength() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double getSquaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @NotNull
    public final Vector4 getNormalized() {
        double l;
        block3: {
            block2: {
                double d = l = 1.0 / this.getLength();
                boolean bl = false;
                if (Double.isNaN(d)) break block2;
                d = l;
                bl = false;
                if (!Double.isInfinite(d)) break block3;
            }
            return ZERO;
        }
        return this.times(l);
    }

    @NotNull
    public final Vector4 unaryMinus() {
        return new Vector4(-this.x, -this.y, -this.z, -this.w);
    }

    @Override
    @NotNull
    public Vector4 plus(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    @Override
    @NotNull
    public final Vector4 plus(double d) {
        return new Vector4(this.x + d, this.y + d, this.z + d, this.w + d);
    }

    @Override
    @NotNull
    public Vector4 minus(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    @Override
    @NotNull
    public final Vector4 minus(double d) {
        return new Vector4(this.x - d, this.y - d, this.z - d, this.w - d);
    }

    @NotNull
    public final Vector4 times(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x * v.x, this.y * v.y, this.z * v.z, this.w * v.w);
    }

    @Override
    @NotNull
    public Vector4 times(double s2) {
        return new Vector4(this.x * s2, this.y * s2, this.z * s2, this.w * s2);
    }

    @NotNull
    public final Vector4 div(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x / v.x, this.y / v.y, this.z / v.z, this.w / v.w);
    }

    @Override
    @NotNull
    public Vector4 div(double s2) {
        return new Vector4(this.x / s2, this.y / s2, this.z / s2, this.w / s2);
    }

    public final double get(int i) {
        double d;
        switch (i) {
            case 0: {
                d = this.x;
                break;
            }
            case 1: {
                d = this.y;
                break;
            }
            case 2: {
                d = this.z;
                break;
            }
            case 3: {
                d = this.w;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("unsupported index");
            }
        }
        return d;
    }

    public final double distanceTo(@NotNull Vector4 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        double dw = other.z - this.z;
        double d = dx * dx + dy * dy + dz * dz + dw * dw;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double squaredDistanceTo(@NotNull Vector4 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        double dw = other.w - this.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    @NotNull
    public final Vector4 mix(@NotNull Vector4 o, double mix) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.times(1.0 - mix).plus(o.times(mix));
    }

    @NotNull
    public final double[] toDoubleArray() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    @NotNull
    public final IntVector4 toInt() {
        return new IntVector4((int)this.x, (int)this.y, (int)this.z, (int)this.w);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public Vector4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4(double x) {
        this(x, x, x, x);
    }

    static {
        Companion = new Companion(null);
        UNIT_X = new Vector4(1.0, 0.0, 0.0, 0.0);
        UNIT_Y = new Vector4(0.0, 1.0, 0.0, 0.0);
        UNIT_Z = new Vector4(0.0, 0.0, 1.0, 0.0);
        UNIT_W = new Vector4(0.0, 0.0, 0.0, 1.0);
        ZERO = new Vector4(0.0, 0.0, 0.0, 0.0);
        ONE = new Vector4(1.0, 1.0, 1.0, 1.0);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.w;
    }

    @NotNull
    public final Vector4 copy(double x, double y, double z, double w) {
        return new Vector4(x, y, z, w);
    }

    public static /* synthetic */ Vector4 copy$default(Vector4 vector4, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector4.x;
        }
        if ((n & 2) != 0) {
            d2 = vector4.y;
        }
        if ((n & 4) != 0) {
            d3 = vector4.z;
        }
        if ((n & 8) != 0) {
            d4 = vector4.w;
        }
        return vector4.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "Vector4(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = Double.doubleToLongBits(this.w);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector4)) break block3;
                Vector4 vector4 = (Vector4)object;
                if (Double.compare(this.x, vector4.x) != 0 || Double.compare(this.y, vector4.y) != 0 || Double.compare(this.z, vector4.z) != 0 || Double.compare(this.w, vector4.w) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/math/Vector4$Companion;", "", "()V", "ONE", "Lorg/openrndr/math/Vector4;", "getONE", "()Lorg/openrndr/math/Vector4;", "UNIT_W", "getUNIT_W", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Vector4 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector4 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector4 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final Vector4 getUNIT_W() {
            return UNIT_W;
        }

        @NotNull
        public final Vector4 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector4 getONE() {
            return ONE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

