/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2;
import org.openrndr.math.LinearType;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2$WhenMappings;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 P2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001PB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0011\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0000J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010-\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010.\u001a\u00020/2\b\u0010*\u001a\u0004\u0018\u000100H\u00d6\u0003J\u0011\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0086\u0002J\t\u00104\u001a\u000203H\u00d6\u0001J\u0011\u00105\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004H\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0096\u0002J\u0016\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0004J\u0010\u00109\u001a\u00020\u00002\b\b\u0002\u0010:\u001a\u00020;J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010<\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0000H\u0086\u0004J\u0018\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00042\b\b\u0002\u0010A\u001a\u00020\u0000J\u000e\u0010B\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0000J\u0011\u0010C\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020HJ\t\u0010I\u001a\u00020JH\u00d6\u0001J\t\u0010K\u001a\u00020\u0000H\u0086\u0002J$\u0010L\u001a\u00020\u00142\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010M\u001a\u00020\u0004J.\u0010N\u001a\u00020\u00182\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010M\u001a\u00020\u00042\b\b\u0002\u0010O\u001a\u00020\u0004R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR\u0011\u0010 \u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\r\u00a8\u0006Q"}, d2={"Lorg/openrndr/math/Vector2;", "Ljava/io/Serializable;", "Lorg/openrndr/math/LinearType;", "x", "", "(D)V", "y", "(DD)V", "length", "getLength", "()D", "normalized", "getNormalized", "()Lorg/openrndr/math/Vector2;", "squaredLength", "getSquaredLength", "getX", "xx", "getXx", "xy0", "Lorg/openrndr/math/Vector3;", "getXy0", "()Lorg/openrndr/math/Vector3;", "xy00", "Lorg/openrndr/math/Vector4;", "getXy00", "()Lorg/openrndr/math/Vector4;", "xy01", "getXy01", "xy1", "getXy1", "getY", "yx", "getYx", "yy", "getYy", "component1", "component2", "copy", "cross", "right", "distanceTo", "other", "div", "d", "dot", "equals", "", "", "get", "i", "", "hashCode", "minus", "vector2", "mix", "o", "perpendicular", "polarity", "Lorg/openrndr/math/YPolarity;", "plus", "reflect", "surfaceNormal", "rotate", "degrees", "origin", "squaredDistanceTo", "times", "v", "toDoubleArray", "", "toInt", "Lorg/openrndr/math/IntVector2;", "toString", "", "unaryMinus", "vector3", "z", "vector4", "w", "Companion", "openrndr-math"})
public final class Vector2
implements Serializable,
LinearType<Vector2> {
    private final double x;
    private final double y;
    @NotNull
    private static final Vector2 ZERO;
    @NotNull
    private static final Vector2 ONE;
    @NotNull
    private static final Vector2 UNIT_X;
    @NotNull
    private static final Vector2 UNIT_Y;
    @NotNull
    private static final Vector2 INFINITY;
    public static final Companion Companion;

    public final double getLength() {
        double d = this.x * this.x + this.y * this.y;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double getSquaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    @NotNull
    public final Vector2 perpendicular(@NotNull YPolarity polarity) {
        Vector2 vector2;
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        switch (Vector2$WhenMappings.$EnumSwitchMapping$0[polarity.ordinal()]) {
            case 1: {
                vector2 = new Vector2(-this.y, this.x);
                break;
            }
            case 2: {
                vector2 = new Vector2(this.y, -this.x);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vector2;
    }

    public static /* synthetic */ Vector2 perpendicular$default(Vector2 vector2, YPolarity yPolarity, int n, Object object) {
        if ((n & 1) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return vector2.perpendicular(yPolarity);
    }

    @NotNull
    public final Vector2 getNormalized() {
        double localLength = this.getLength();
        return localLength > 0.0 ? this.div(this.getLength()) : ZERO;
    }

    public final double cross(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.y - this.y * right.x;
    }

    public final double dot(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y;
    }

    @NotNull
    public final Vector2 reflect(@NotNull Vector2 surfaceNormal) {
        Intrinsics.checkNotNullParameter(surfaceNormal, "surfaceNormal");
        return this.minus(surfaceNormal.times(this.dot(surfaceNormal)).times(2.0));
    }

    @NotNull
    public final Vector2 rotate(double degrees, @NotNull Vector2 origin) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        Vector2 p = this.minus(origin);
        double a2 = Math.toRadians(degrees);
        boolean bl = false;
        bl = false;
        bl = false;
        bl = false;
        Vector2 w = new Vector2(p.x * Math.cos(a2) - p.y * Math.sin(a2), p.y * Math.cos(a2) + p.x * Math.sin(a2));
        return w.plus(origin);
    }

    public static /* synthetic */ Vector2 rotate$default(Vector2 vector2, double d, Vector2 vector22, int n, Object object) {
        if ((n & 2) != 0) {
            vector22 = ZERO;
        }
        return vector2.rotate(d, vector22);
    }

    @NotNull
    public final Vector2 getYx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 getXx() {
        return new Vector2(this.x, this.x);
    }

    @NotNull
    public final Vector2 getYy() {
        return new Vector2(this.y, this.y);
    }

    @NotNull
    public final Vector3 getXy0() {
        return new Vector3(this.x, this.y, 0.0);
    }

    @NotNull
    public final Vector3 getXy1() {
        return new Vector3(this.x, this.y, 1.0);
    }

    @NotNull
    public final Vector4 getXy00() {
        return new Vector4(this.x, this.y, 0.0, 0.0);
    }

    @NotNull
    public final Vector4 getXy01() {
        return new Vector4(this.x, this.y, 0.0, 1.0);
    }

    @NotNull
    public final Vector3 vector3(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 vector3$default(Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        return vector2.vector3(d, d2, d3);
    }

    @NotNull
    public final Vector4 vector4(double x, double y, double z, double w) {
        return new Vector4(x, y, z, w);
    }

    public static /* synthetic */ Vector4 vector4$default(Vector2 vector2, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        return vector2.vector4(d, d2, d3, d4);
    }

    public final double get(int i) {
        double d;
        switch (i) {
            case 0: {
                d = this.x;
                break;
            }
            case 1: {
                d = this.y;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported index");
            }
        }
        return d;
    }

    @NotNull
    public final Vector2 unaryMinus() {
        return new Vector2(-this.x, -this.y);
    }

    @Override
    @NotNull
    public Vector2 plus(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "vector2");
        return new Vector2(this.x + vector2.x, this.y + vector2.y);
    }

    @Override
    @NotNull
    public final Vector2 plus(double d) {
        return new Vector2(this.x + d, this.y + d);
    }

    @Override
    @NotNull
    public Vector2 minus(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "vector2");
        return new Vector2(this.x - vector2.x, this.y - vector2.y);
    }

    @Override
    @NotNull
    public final Vector2 minus(double d) {
        return new Vector2(this.x - d, this.y - d);
    }

    @Override
    @NotNull
    public Vector2 times(double d) {
        return new Vector2(this.x * d, this.y * d);
    }

    @NotNull
    public final Vector2 times(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector2(this.x * v.x, this.y * v.y);
    }

    @Override
    @NotNull
    public Vector2 div(double d) {
        return new Vector2(this.x / d, this.y / d);
    }

    @NotNull
    public final Vector2 div(@NotNull Vector2 d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return new Vector2(this.x / d.x, this.y / d.y);
    }

    public final double distanceTo(@NotNull Vector2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double d = dx * dx + dy * dy;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double squaredDistanceTo(@NotNull Vector2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        return dx * dx + dy * dy;
    }

    @NotNull
    public final Vector2 mix(@NotNull Vector2 o, double mix) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.times(1.0 - mix).plus(o.times(mix));
    }

    @NotNull
    public final double[] toDoubleArray() {
        return new double[]{this.x, this.y};
    }

    @NotNull
    public final IntVector2 toInt() {
        return new IntVector2((int)this.x, (int)this.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(double x) {
        this(x, x);
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vector2(0.0, 0.0);
        ONE = new Vector2(1.0, 1.0);
        UNIT_X = new Vector2(1.0, 0.0);
        UNIT_Y = new Vector2(0.0, 1.0);
        INFINITY = new Vector2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vector2 copy(double x, double y) {
        return new Vector2(x, y);
    }

    public static /* synthetic */ Vector2 copy$default(Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        return vector2.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Vector2(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector2)) break block3;
                Vector2 vector2 = (Vector2)object;
                if (Double.compare(this.x, vector2.x) != 0 || Double.compare(this.y, vector2.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/math/Vector2$Companion;", "", "()V", "INFINITY", "Lorg/openrndr/math/Vector2;", "getINFINITY", "()Lorg/openrndr/math/Vector2;", "ONE", "getONE", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "ZERO", "getZERO", "fromPolar", "polar", "Lorg/openrndr/math/Polar;", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Vector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector2 getONE() {
            return ONE;
        }

        @NotNull
        public final Vector2 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector2 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector2 getINFINITY() {
            return INFINITY;
        }

        @NotNull
        public final Vector2 fromPolar(@NotNull Polar polar) {
            Intrinsics.checkNotNullParameter(polar, "polar");
            double theta = Math.toRadians(polar.getTheta());
            boolean bl = false;
            double x = Math.cos(theta);
            boolean bl2 = false;
            double y = Math.sin(theta);
            return new Vector2(x, y).times(polar.getRadius());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

