/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J1\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010'\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0086\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006."}, d2={"Lorg/openrndr/math/Quaternion;", "Ljava/io/Serializable;", "x", "", "y", "z", "w", "(DDDD)V", "inversed", "getInversed", "()Lorg/openrndr/math/Quaternion;", "length", "getLength", "()D", "matrix", "Lorg/openrndr/math/Matrix33;", "getMatrix", "()Lorg/openrndr/math/Matrix33;", "negated", "getNegated", "norm", "getNorm", "normalized", "getNormalized", "getW", "getX", "getY", "getZ", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "times", "q", "Lorg/openrndr/math/Vector3;", "vec", "toString", "", "Companion", "openrndr-math"})
public final class Quaternion
implements Serializable {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Quaternion IDENTITY;
    @NotNull
    private static final Quaternion ZERO;
    public static final Companion Companion;

    public final double getLength() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        boolean bl = false;
        return Math.sqrt(d);
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter(q, "q");
        return new Quaternion(this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x, -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y, this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z, -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double s2 = 2.0 / this.getNorm();
        double xs = this.x * s2;
        double ys = this.y * s2;
        double zs = this.z * s2;
        double xxs = this.x * xs;
        double yys = this.y * ys;
        double zzs = this.z * zs;
        double xys = this.x * ys;
        double xzs = this.x * zs;
        double yzs = this.y * zs;
        double wxs = this.w * xs;
        double wys = this.w * ys;
        double wzs = this.w * zs;
        return new Vector3((1.0 - (yys + zzs)) * vec.getX() + (xys - wzs) * vec.getY() + (xzs + wys) * vec.getZ(), (xys + wzs) * vec.getX() + (1.0 - (xxs + zzs)) * vec.getY() + (yzs - wxs) * vec.getZ(), (xzs - wys) * vec.getX() + (yzs + wxs) * vec.getY() + (1.0 - (xxs + yys)) * vec.getZ());
    }

    @NotNull
    public final Quaternion getNegated() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Quaternion getInversed() {
        double n = this.getNorm();
        if (n > 0.0) {
            double invNorm = 1.0 / n;
            return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
        }
        String string = "norm <= 0 => quaternion is not invertible";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public final Quaternion getNormalized() {
        double l = this.getLength();
        return new Quaternion(this.x / l, this.y / l, this.z / l, this.w / l);
    }

    public final double getNorm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @NotNull
    public final Matrix33 getMatrix() {
        double norm = this.getNorm();
        double s2 = norm == 1.0 ? 2.0 : (norm > 0.0 ? 2.0 / norm : 0.0);
        double xs = this.x * s2;
        double ys = this.y * s2;
        double zs = this.z * s2;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        return new Matrix33(1.0 - (yy + zz), xy - zw, xz + yw, xy + zw, 1.0 - (xx + zz), yz - xw, xz - yw, yz + xw, 1.0 - (xx + yy));
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    static {
        Companion = new Companion(null);
        IDENTITY = new Quaternion(0.0, 0.0, 0.0, 1.0);
        ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(double x, double y, double z, double w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = quaternion.x;
        }
        if ((n & 2) != 0) {
            d2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            d3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            d4 = quaternion.w;
        }
        return quaternion.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = Double.doubleToLongBits(this.w);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Quaternion)) break block3;
                Quaternion quaternion = (Quaternion)object;
                if (Double.compare(this.x, quaternion.x) != 0 || Double.compare(this.y, quaternion.y) != 0 || Double.compare(this.z, quaternion.z) != 0 || Double.compare(this.w, quaternion.w) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/math/Quaternion$Companion;", "", "()V", "IDENTITY", "Lorg/openrndr/math/Quaternion;", "getIDENTITY", "()Lorg/openrndr/math/Quaternion;", "ZERO", "getZERO", "fromAngles", "pitch", "", "roll", "yaw", "fromAnglesRadian", "fromAxes", "x", "Lorg/openrndr/math/Vector3;", "y", "z", "fromLookAt", "from", "to", "up", "fromMatrix", "m", "Lorg/openrndr/math/Matrix33;", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Quaternion getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Quaternion getZERO() {
            return ZERO;
        }

        @NotNull
        public final Quaternion fromLookAt(@NotNull Vector3 from, @NotNull Vector3 to, @NotNull Vector3 up) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullParameter(to, "to");
            Intrinsics.checkNotNullParameter(up, "up");
            Vector3 direction = to.minus(from);
            Vector3 z = direction.getNormalized();
            Vector3 y = up.getNormalized();
            Vector3 x = y.cross(z).getNormalized();
            Vector3 y2 = z.cross(x).getNormalized();
            return this.fromAxes(x, y2, z).getNormalized();
        }

        public static /* synthetic */ Quaternion fromLookAt$default(Companion companion, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
            if ((n & 4) != 0) {
                vector33 = Vector3.Companion.getUNIT_Y();
            }
            return companion.fromLookAt(vector3, vector32, vector33);
        }

        @NotNull
        public final Quaternion fromAxes(@NotNull Vector3 x, @NotNull Vector3 y, @NotNull Vector3 z) {
            Intrinsics.checkNotNullParameter(x, "x");
            Intrinsics.checkNotNullParameter(y, "y");
            Intrinsics.checkNotNullParameter(z, "z");
            Matrix33 m = Matrix33.Companion.fromColumnVectors(x, y, z);
            return this.fromMatrix(m);
        }

        @NotNull
        public final Quaternion fromMatrix(@NotNull Matrix33 m) {
            Intrinsics.checkNotNullParameter(m, "m");
            double t2 = m.getTrace() + 1.0;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double w = 0.0;
            if (t2 > 0.0) {
                boolean bl = false;
                double s2 = 0.5 / Math.sqrt(t2);
                w = 0.25 / s2;
                x = (m.getC1r2() - m.getC2r1()) * s2;
                y = (m.getC2r0() - m.getC0r2()) * s2;
                z = (m.getC0r1() - m.getC1r0()) * s2;
            } else if (m.getC0r0() > m.getC1r1() && m.getC0r0() > m.getC2r2()) {
                double d = 1.0 + m.getC0r0() - m.getC1r1() - m.getC2r2();
                boolean bl = false;
                double s3 = 0.5 / Math.sqrt(d);
                w = (m.getC1r2() - m.getC2r1()) * s3;
                x = (double)0.25f / s3;
                y = (m.getC0r1() + m.getC1r0()) * s3;
                z = (m.getC2r0() + m.getC0r2()) * s3;
            } else if (m.getC1r1() > m.getC2r2()) {
                double d = 1.0 + m.getC1r1() - m.getC0r0() - m.getC2r2();
                boolean bl = false;
                double s4 = (double)0.5f / Math.sqrt(d);
                w = (m.getC2r0() - m.getC0r2()) * s4;
                x = (m.getC0r2() + m.getC1r0()) * s4;
                y = (double)0.25f / s4;
                z = (m.getC1r2() + m.getC2r1()) * s4;
            } else {
                double d = 1.0 + m.getC2r2() - m.getC0r0() - m.getC1r1();
                boolean bl = false;
                double s5 = (double)0.5f / Math.sqrt(d);
                w = (m.getC0r1() - m.getC1r0()) * s5;
                x = (m.getC2r0() + m.getC0r2()) * s5;
                y = (m.getC1r2() + m.getC2r1()) * s5;
                z = (double)0.25f / s5;
            }
            return new Quaternion(x, y, z, w);
        }

        @NotNull
        public final Quaternion fromAngles(double pitch, double roll, double yaw) {
            return this.fromAnglesRadian(Math.toRadians(pitch), Math.toRadians(roll), Math.toRadians(yaw));
        }

        @NotNull
        public final Quaternion fromAnglesRadian(double pitch, double roll, double yaw) {
            double d = yaw * 0.5;
            boolean bl = false;
            double cy = Math.cos(d);
            double d2 = yaw * 0.5;
            boolean bl2 = false;
            double sy = Math.sin(d2);
            double d3 = roll * 0.5;
            boolean bl3 = false;
            double cr = Math.cos(d3);
            double d4 = roll * 0.5;
            boolean bl4 = false;
            double sr = Math.sin(d4);
            double d5 = pitch * 0.5;
            boolean bl5 = false;
            double cp = Math.cos(d5);
            double d6 = pitch * 0.5;
            boolean bl6 = false;
            double sp = Math.sin(d6);
            return new Quaternion(cy * sr * cp - sy * cr * sp, cy * cr * sp + sy * sr * cp, sy * cr * cp - cy * sr * sp, cy * cr * cp + sy * sr * sp);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

