/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a8\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a;\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\b\u0017\u001a4\u0010\u0005\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00182\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a4\u0010\u0005\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u00192\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a4\u0010\u0005\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001a2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0011\u0010\u0013\u001a\u00020\u0001*\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u001b\u001a\n\u0010\u0013\u001a\u00020\u0018*\u00020\u0018\u001a\n\u0010\u0013\u001a\u00020\u0019*\u00020\u0019\u001a\n\u0010\u0013\u001a\u00020\u001a*\u00020\u001a\u001a!\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u001c\u001a\u001a\u0010\u0015\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0018\u001a\u001a\u0010\u0015\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0019\u001a\u001a\u0010\u0015\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a\u00a8\u0006\u001d"}, d2={"linearstep", "", "edge0", "edge1", "x", "map", "beforeLeft", "beforeRight", "afterLeft", "afterRight", "value", "clamp", "", "mix", "left", "right", "mixAngle", "leftAngle", "rightAngle", "saturate", "smootherstep", "smoothstep", "smoothstepIn", "doubleMap", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/Vector4;", "doubleSaturate", "doubleSmoothstep", "openrndr-math"})
public final class MappingKt {
    public static final double map(double beforeLeft, double beforeRight, double afterLeft, double afterRight, double value, boolean clamp) {
        double d;
        double db = beforeRight - beforeLeft;
        double da = afterRight - afterLeft;
        if (db != 0.0) {
            double n = (value - beforeLeft) / db;
            d = afterLeft + (clamp ? MappingKt.saturate(n) : n) * da;
        } else {
            double n = value - beforeLeft;
            d = afterLeft + (clamp ? MappingKt.saturate(n) : n) * da;
        }
        return d;
    }

    public static /* synthetic */ double map$default(double d, double d2, double d3, double d4, double d5, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return MappingKt.map(d, d2, d3, d4, d5, bl);
    }

    @JvmName(name="doubleMap")
    public static final double doubleMap(double $this$map, double beforeLeft, double beforeRight, double afterLeft, double afterRight, boolean clamp) {
        return MappingKt.map(beforeLeft, beforeRight, afterLeft, afterRight, $this$map, clamp);
    }

    public static /* synthetic */ double doubleMap$default(double d, double d2, double d3, double d4, double d5, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return MappingKt.doubleMap(d, d2, d3, d4, d5, bl);
    }

    @NotNull
    public static final Vector2 map(@NotNull Vector2 $this$map, @NotNull Vector2 beforeLeft, @NotNull Vector2 beforeRight, @NotNull Vector2 afterLeft, @NotNull Vector2 afterRight, boolean clamp) {
        Intrinsics.checkNotNullParameter($this$map, "$this$map");
        Intrinsics.checkNotNullParameter(beforeLeft, "beforeLeft");
        Intrinsics.checkNotNullParameter(beforeRight, "beforeRight");
        Intrinsics.checkNotNullParameter(afterLeft, "afterLeft");
        Intrinsics.checkNotNullParameter(afterRight, "afterRight");
        return new Vector2(MappingKt.doubleMap($this$map.getX(), beforeLeft.getX(), beforeRight.getX(), afterLeft.getX(), afterRight.getX(), clamp), MappingKt.doubleMap($this$map.getY(), beforeLeft.getY(), beforeRight.getY(), afterLeft.getY(), afterRight.getY(), clamp));
    }

    public static /* synthetic */ Vector2 map$default(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return MappingKt.map(vector2, vector22, vector23, vector24, vector25, bl);
    }

    @NotNull
    public static final Vector3 map(@NotNull Vector3 $this$map, @NotNull Vector3 beforeLeft, @NotNull Vector3 beforeRight, @NotNull Vector3 afterLeft, @NotNull Vector3 afterRight, boolean clamp) {
        Intrinsics.checkNotNullParameter($this$map, "$this$map");
        Intrinsics.checkNotNullParameter(beforeLeft, "beforeLeft");
        Intrinsics.checkNotNullParameter(beforeRight, "beforeRight");
        Intrinsics.checkNotNullParameter(afterLeft, "afterLeft");
        Intrinsics.checkNotNullParameter(afterRight, "afterRight");
        return new Vector3(MappingKt.doubleMap($this$map.getX(), beforeLeft.getX(), beforeRight.getX(), afterLeft.getX(), afterRight.getX(), clamp), MappingKt.doubleMap($this$map.getY(), beforeLeft.getY(), beforeRight.getY(), afterLeft.getY(), afterRight.getY(), clamp), MappingKt.doubleMap($this$map.getZ(), beforeLeft.getZ(), beforeRight.getZ(), afterLeft.getZ(), afterRight.getZ(), clamp));
    }

    public static /* synthetic */ Vector3 map$default(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, Vector3 vector35, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return MappingKt.map(vector3, vector32, vector33, vector34, vector35, bl);
    }

    @NotNull
    public static final Vector4 map(@NotNull Vector4 $this$map, @NotNull Vector4 beforeLeft, @NotNull Vector4 beforeRight, @NotNull Vector4 afterLeft, @NotNull Vector4 afterRight, boolean clamp) {
        Intrinsics.checkNotNullParameter($this$map, "$this$map");
        Intrinsics.checkNotNullParameter(beforeLeft, "beforeLeft");
        Intrinsics.checkNotNullParameter(beforeRight, "beforeRight");
        Intrinsics.checkNotNullParameter(afterLeft, "afterLeft");
        Intrinsics.checkNotNullParameter(afterRight, "afterRight");
        return new Vector4(MappingKt.doubleMap($this$map.getX(), beforeLeft.getX(), beforeRight.getX(), afterLeft.getX(), afterRight.getX(), clamp), MappingKt.doubleMap($this$map.getY(), beforeLeft.getY(), beforeRight.getY(), afterLeft.getY(), afterRight.getY(), clamp), MappingKt.doubleMap($this$map.getZ(), beforeLeft.getZ(), beforeRight.getZ(), afterLeft.getZ(), afterRight.getZ(), clamp), MappingKt.doubleMap($this$map.getW(), beforeLeft.getW(), beforeRight.getW(), afterLeft.getW(), afterRight.getW(), clamp));
    }

    public static /* synthetic */ Vector4 map$default(Vector4 vector4, Vector4 vector42, Vector4 vector43, Vector4 vector44, Vector4 vector45, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return MappingKt.map(vector4, vector42, vector43, vector44, vector45, bl);
    }

    public static final double linearstep(double edge0, double edge1, double x) {
        return MappingKt.saturate((x - edge0) / (edge1 - edge0));
    }

    public static final double smoothstep(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return u * u * ((double)3 - (double)2 * u);
    }

    @JvmName(name="doubleSmoothstep")
    public static final double doubleSmoothstep(double $this$smoothstep, double edge0, double edge1) {
        return MappingKt.smoothstep(edge0, edge1, $this$smoothstep);
    }

    @NotNull
    public static final Vector2 smoothstep(@NotNull Vector2 $this$smoothstep, @NotNull Vector2 edge0, @NotNull Vector2 edge1) {
        Intrinsics.checkNotNullParameter($this$smoothstep, "$this$smoothstep");
        Intrinsics.checkNotNullParameter(edge0, "edge0");
        Intrinsics.checkNotNullParameter(edge1, "edge1");
        return new Vector2(MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getX(), edge1.getX()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getY(), edge1.getY()));
    }

    @NotNull
    public static final Vector3 smoothstep(@NotNull Vector3 $this$smoothstep, @NotNull Vector3 edge0, @NotNull Vector3 edge1) {
        Intrinsics.checkNotNullParameter($this$smoothstep, "$this$smoothstep");
        Intrinsics.checkNotNullParameter(edge0, "edge0");
        Intrinsics.checkNotNullParameter(edge1, "edge1");
        return new Vector3(MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getX(), edge1.getX()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getY(), edge1.getY()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getZ(), edge1.getZ()));
    }

    @NotNull
    public static final Vector4 smoothstep(@NotNull Vector4 $this$smoothstep, @NotNull Vector4 edge0, @NotNull Vector4 edge1) {
        Intrinsics.checkNotNullParameter($this$smoothstep, "$this$smoothstep");
        Intrinsics.checkNotNullParameter(edge0, "edge0");
        Intrinsics.checkNotNullParameter(edge1, "edge1");
        return new Vector4(MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getX(), edge1.getX()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getY(), edge1.getY()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getZ(), edge1.getZ()), MappingKt.doubleSmoothstep($this$smoothstep.getX(), edge0.getW(), edge1.getW()));
    }

    public static final double smoothstepIn(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return x < 0.5 ? u * u * ((double)3 - (double)2 * u) : u;
    }

    public static final double smootherstep(double edge0, double edge1, double x) {
        double u = MappingKt.saturate((x - edge0) / (edge1 - edge0));
        return u * u * u * (u * (u * (double)6 - (double)15) + (double)10);
    }

    public static final double saturate(double x) {
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        d2 = Math.min(d2, x);
        bl = false;
        return Math.max(d, d2);
    }

    @JvmName(name="doubleSaturate")
    public static final double doubleSaturate(double $this$saturate) {
        return MappingKt.saturate($this$saturate);
    }

    @NotNull
    public static final Vector2 saturate(@NotNull Vector2 $this$saturate) {
        Intrinsics.checkNotNullParameter($this$saturate, "$this$saturate");
        return new Vector2(MappingKt.doubleSaturate($this$saturate.getX()), MappingKt.doubleSaturate($this$saturate.getY()));
    }

    @NotNull
    public static final Vector3 saturate(@NotNull Vector3 $this$saturate) {
        Intrinsics.checkNotNullParameter($this$saturate, "$this$saturate");
        return new Vector3(MappingKt.doubleSaturate($this$saturate.getX()), MappingKt.doubleSaturate($this$saturate.getY()), MappingKt.doubleSaturate($this$saturate.getZ()));
    }

    @NotNull
    public static final Vector4 saturate(@NotNull Vector4 $this$saturate) {
        Intrinsics.checkNotNullParameter($this$saturate, "$this$saturate");
        return new Vector4(MappingKt.doubleSaturate($this$saturate.getX()), MappingKt.doubleSaturate($this$saturate.getY()), MappingKt.doubleSaturate($this$saturate.getZ()), MappingKt.doubleSaturate($this$saturate.getW()));
    }

    public static final double mix(double left, double right, double x) {
        return left * (1.0 - x) + right * x;
    }

    public static final double mixAngle(double leftAngle, double rightAngle, double x) {
        double shortestAngle = ((rightAngle - leftAngle) % (double)360 + (double)540) % (double)360 - (double)180;
        return (leftAngle + shortestAngle * x) % (double)360;
    }
}

