/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.openrndr.binpack.IntPacker;
import org.openrndr.binpack.PackNode;
import org.openrndr.draw.CharacterPair;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.Session;
import org.openrndr.internal.FontMapManager;
import org.openrndr.internal.gl3.FontImageMapManagerStbTruetype;
import org.openrndr.internal.gl3.FontImageMapManagerStbTruetypeKt;
import org.openrndr.math.IntVector2;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/openrndr/internal/gl3/FontImageMapManagerStbTruetype;", "Lorg/openrndr/internal/FontMapManager;", "()V", "fontMapFromUrl", "Lorg/openrndr/draw/FontImageMap;", "url", "", "size", "", "characterSet", "", "", "contentScale", "openrndr-gl3"})
public final class FontImageMapManagerStbTruetype
extends FontMapManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FontImageMap fontMapFromUrl(@NotNull String url, double size, @NotNull Set<Character> characterSet, double contentScale) {
        IntPacker packer;
        void packSize;
        PackNode root;
        Iterator<Character> iterator2;
        boolean bl;
        void $this$associateTo$iv$iv3;
        Object it22;
        void $this$associateTo$iv$iv2;
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(characterSet, "characterSet");
        FontImageMapManagerStbTruetypeKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(contentScale){
            final /* synthetic */ double $contentScale;

            @Nullable
            public final Object invoke() {
                return "content scale " + this.$contentScale;
            }
            {
                this.$contentScale = d;
                super(0);
            }
        });
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 256;
        byte[] byteArray = TextStreamsKt.readBytes(new URL(url));
        int fileSize = byteArray.length;
        if (fileSize == 0) {
            throw (Throwable)new RuntimeException("0 bytes read");
        }
        FontImageMapManagerStbTruetypeKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(fileSize){
            final /* synthetic */ int $fileSize;

            @Nullable
            public final Object invoke() {
                return "bytes read: " + this.$fileSize;
            }
            {
                this.$fileSize = n;
                super(0);
            }
        });
        ByteBuffer bb = BufferUtils.createByteBuffer(fileSize);
        bb.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer = bb;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        bb.put(byteArray, 0, fileSize);
        ((Buffer)bb).rewind();
        STBTTFontinfo info = STBTTFontinfo.create();
        boolean status = STBTruetype.stbtt_InitFont(info, bb);
        if (!status) {
            throw (Throwable)new RuntimeException("font error");
        }
        float scale2 = STBTruetype.stbtt_ScaleForPixelHeight(info, (float)(size * contentScale));
        double ascent = 0.0;
        double descent = 0.0;
        double lineGap = 0.0;
        MemoryStack memoryStack = MemoryStack.stackPush();
        boolean bl2 = false;
        boolean bl3 = false;
        MemoryStack it = memoryStack;
        boolean $i$a$-let-FontImageMapManagerStbTruetype$fontMapFromUrl$42 = false;
        IntBuffer pAscent = it.mallocInt(1);
        IntBuffer pDescent = it.mallocInt(1);
        IntBuffer pLineGap = it.mallocInt(1);
        STBTruetype.stbtt_GetFontVMetrics(info, pAscent, pDescent, pLineGap);
        ascent = (double)((float)pAscent.get(0) * scale2) * 1.0;
        descent = (double)((float)pDescent.get(0) * scale2) * 1.0;
        lineGap = (double)((float)pLineGap.get(0) * scale2) * 1.0;
        Iterable $this$associate$iv = characterSet;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable $i$a$-let-FontImageMapManagerStbTruetype$fontMapFromUrl$42 = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map2 = destination$iv$iv;
            char it22 = ((Character)element$iv$iv).charValue();
            boolean bl4 = false;
            it22 = new Pair<Character, Integer>(Character.valueOf(it22), STBTruetype.stbtt_FindGlyphIndex(info, it22));
            bl4 = false;
            map2.put(((Pair)it22).getFirst(), ((Pair)it22).getSecond());
        }
        Map glyphIndices = destination$iv$iv;
        Iterable $this$associate$iv2 = characterSet;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv2, 10)), 16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv3) {
            it22 = destination$iv$iv2;
            char c = ((Character)element$iv$iv).charValue();
            boolean bl5 = false;
            AutoCloseable autoCloseable = MemoryStack.stackPush();
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable = null;
            try {
                MemoryStack it3 = (MemoryStack)autoCloseable;
                bl = false;
                IntBuffer px0 = it3.mallocInt(1);
                IntBuffer py0 = it3.mallocInt(1);
                IntBuffer px1 = it3.mallocInt(1);
                IntBuffer py1 = it3.mallocInt(1);
                STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, ((Number)MapsKt.getValue(glyphIndices, Character.valueOf(c))).intValue(), scale2, scale2, 0.0f, 0.0f, px0, py0, px1, py1);
                iterator2 = new Pair<Character, IntVector2>(Character.valueOf(c), new IntVector2(px1.get() - px0.get(), py1.get() - py0.get()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            Pair<Character, IntVector2> pair = iterator2;
            bl5 = false;
            it22.put(pair.getFirst(), pair.getSecond());
        }
        Map glyphDimensions = destination$iv$iv2;
        int sanding = 3;
        while (!FontImageMapManagerStbTruetypeKt.attemptPack(root = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null), packer = new IntPacker(null, null, null, 7, null), glyphDimensions, sanding)) {
            packSize.element *= 2;
        }
        FontImageMapManagerStbTruetypeKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>((Ref.IntRef)packSize){
            final /* synthetic */ Ref.IntRef $packSize;

            @Nullable
            public final Object invoke() {
                return "final map size " + this.$packSize.element + 'x' + this.$packSize.element;
            }
            {
                this.$packSize = intRef;
                super(0);
            }
        });
        ColorBuffer image = ColorBufferKt.colorBuffer$default(packSize.element, packSize.element, 1.0, ColorFormat.R, null, null, 0, Session.Companion.getRoot(), 112, null);
        boolean $this$associateTo$iv$iv3 = false;
        Map map3 = new LinkedHashMap();
        PackNode root2 = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null);
        IntPacker packer2 = new IntPacker(null, null, null, 7, null);
        boolean element$iv$iv = false;
        Map glyphMetrics = new LinkedHashMap();
        ByteBuffer bitmap = BufferUtils.createByteBuffer(packSize.element * packSize.element);
        FontImageMapManagerStbTruetypeKt.access$getLogger$p().debug(fontMapFromUrl.5.INSTANCE);
        Iterable $this$sortedByDescending$iv = glyphDimensions.entrySet();
        boolean $i$f$sortedByDescending = false;
        boolean bl8 = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator<T>(){

            public final int compare(T a2, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((IntVector2)it.getValue()).getSquaredLength());
                it = (Map.Entry)a2;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((IntVector2)it.getValue()).getSquaredLength();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            Map.Entry it4 = (Map.Entry)element$iv;
            boolean bl9 = false;
            PackNode target2 = IntPacker.insert$default(packer2, root2, new IntRectangle(0, 0, ((IntVector2)it4.getValue()).getX() + 2 * sanding, ((IntVector2)it4.getValue()).getY() + 2 * sanding), null, 4, null);
            if (target2 != null) {
                bl = false;
                boolean bl10 = false;
                Iterator<Character> t2 = iterator2;
                boolean bl11 = false;
                map3.put(it4.getKey(), new IntRectangle(((PackNode)((Object)t2)).getArea().getX() + sanding, ((PackNode)((Object)t2)).getArea().getY() + sanding, ((PackNode)((Object)t2)).getArea().getWidth() - 2 * sanding, ((PackNode)((Object)t2)).getArea().getHeight() - 2 * sanding));
                Object v = glyphIndices.get(it4.getKey());
                Intrinsics.checkNotNull(v);
                int glyphIndex = ((Number)v).intValue();
                int advanceWidth = 0;
                int leftBearing = 0;
                AutoCloseable autoCloseable = MemoryStack.stackPush();
                boolean bl12 = false;
                boolean bl13 = false;
                Throwable throwable = null;
                try {
                    Object stack = (MemoryStack)autoCloseable;
                    boolean bl14 = false;
                    IntBuffer pAdvanceWidth = ((MemoryStack)stack).mallocInt(1);
                    IntBuffer pLeftBearing = ((MemoryStack)stack).mallocInt(1);
                    STBTruetype.stbtt_GetGlyphHMetrics(info, glyphIndex, pAdvanceWidth, pLeftBearing);
                    advanceWidth = pAdvanceWidth.get(0);
                    leftBearing = pLeftBearing.get(0);
                    stack = Unit.INSTANCE;
                }
                catch (Throwable stack) {
                    throwable = stack;
                    throw stack;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                int x0 = 0;
                int y0 = 0;
                int x1 = 0;
                int y1 = 0;
                AutoCloseable autoCloseable2 = MemoryStack.stackPush();
                boolean bl15 = false;
                boolean bl16 = false;
                Throwable throwable3 = null;
                try {
                    MemoryStack stack = (MemoryStack)autoCloseable2;
                    boolean bl17 = false;
                    IntBuffer px0 = stack.mallocInt(1);
                    IntBuffer py0 = stack.mallocInt(1);
                    IntBuffer px1 = stack.mallocInt(1);
                    IntBuffer py1 = stack.mallocInt(1);
                    STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, glyphIndex, scale2, scale2, 0.0f, 0.0f, px0, py0, px1, py1);
                    x0 = px0.get(0);
                    y0 = py0.get(0);
                    x1 = px1.get(0);
                    y1 = py1.get(0);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable3);
                }
                double ascale = (double)scale2 / contentScale;
                glyphMetrics.put(it4.getKey(), new GlyphMetrics((double)advanceWidth * ascale, (double)leftBearing * ascale, x0, y0));
                ByteBuffer byteBuffer2 = bitmap;
                if (byteBuffer2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer2).rewind();
                ((Buffer)bitmap).position((sanding + ((PackNode)((Object)t2)).getArea().getY()) * packSize.element + sanding + ((PackNode)((Object)t2)).getArea().getX());
                STBTruetype.stbtt_MakeGlyphBitmapSubpixel(info, bitmap, x1 - x0, y1 - y0, packSize.element, scale2, scale2, 0.0f, 0.0f, glyphIndex);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        FontImageMapManagerStbTruetypeKt.access$getLogger$p().debug(fontMapFromUrl.8.INSTANCE);
        ByteBuffer byteBuffer3 = bitmap;
        if (byteBuffer3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer3).rewind();
        ColorBuffer.DefaultImpls.write$default(image, bitmap, null, null, 0, 14, null);
        double leading = ascent - descent + lineGap;
        FontImageMap fontImageMap = new FontImageMap(image, map3, glyphMetrics, size, contentScale, ascent / contentScale, descent / contentScale, (ascent + descent) / contentScale, leading / contentScale, url);
        boolean bl18 = false;
        boolean bl19 = false;
        FontImageMap $this$apply = fontImageMap;
        boolean bl20 = false;
        for (char outer : characterSet) {
            for (char inner : characterSet) {
                Integer outerGlyph = (Integer)glyphIndices.get(Character.valueOf(outer));
                Integer innerGlyph = (Integer)glyphIndices.get(Character.valueOf(inner));
                if (outerGlyph == null || innerGlyph == null) continue;
                int kernInfo = STBTruetype.stbtt_GetGlyphKernAdvance(info, outerGlyph, innerGlyph);
                $this$apply.getKerningTable().put(new CharacterPair(outer, inner), (double)kernInfo * ((double)scale2 / contentScale));
            }
        }
        ((Buffer)bb).rewind();
        return fontImageMap;
    }
}

