/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001cH\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J(\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020&H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020'H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020(H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020)H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020*H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020+H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020,H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020-H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u000f\u00a8\u0006/"}, d2={"Lorg/openrndr/internal/gl3/BufferWriterGL3;", "Lorg/openrndr/draw/BufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "elementSize", "", "(Ljava/nio/ByteBuffer;I)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getElementSize", "()I", "value", "position", "getPosition", "setPosition", "(I)V", "positionElements", "getPositionElements", "setPositionElements", "copyBuffer", "", "sourceBuffer", "sourceOffset", "sourceSizeInBytes", "rewind", "write", "v", "", "", "x", "y", "z", "w", "a", "", "offset", "size", "", "Lorg/openrndr/color/ColorRGBa;", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "Lorg/openrndr/math/Matrix33;", "Lorg/openrndr/math/Matrix44;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/Vector4;", "openrndr-gl3"})
public final class BufferWriterGL3
implements BufferWriter {
    @NotNull
    private final ByteBuffer buffer;
    private final int elementSize;

    @Override
    public void copyBuffer(@NotNull ByteBuffer sourceBuffer, int sourceOffset, int sourceSizeInBytes) {
        Intrinsics.checkNotNullParameter(sourceBuffer, "sourceBuffer");
        boolean bl = sourceBuffer.isDirect();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "can only copy from direct buffers";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
        ((Buffer)sourceBuffer).position(sourceOffset);
        ((Buffer)sourceBuffer).limit(sourceOffset + sourceSizeInBytes);
        this.buffer.put(sourceBuffer);
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
    }

    @Override
    public void write(byte v) {
        this.buffer.put(v);
    }

    @Override
    public void write(short v) {
        this.buffer.putShort(v);
    }

    @Override
    public void write(int v) {
        this.buffer.putInt(v);
    }

    @Override
    public void write(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.getX());
        this.buffer.putInt(v.getY());
    }

    @Override
    public void write(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.getX());
        this.buffer.putInt(v.getY());
        this.buffer.putInt(v.getZ());
    }

    @Override
    public void write(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.getX());
        this.buffer.putInt(v.getY());
        this.buffer.putInt(v.getZ());
        this.buffer.putInt(v.getW());
    }

    @Override
    public void write(@NotNull float[] a2, int offset2, int size) {
        Intrinsics.checkNotNullParameter(a2, "a");
        this.buffer.asFloatBuffer().put(a2, offset2, size);
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(this.buffer.position() + size * 4);
    }

    @Override
    public void write(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
        this.buffer.putFloat((float)v.getZ());
    }

    @Override
    public void write(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
    }

    @Override
    public void write(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
        this.buffer.putFloat((float)v.getZ());
        this.buffer.putFloat((float)v.getW());
    }

    @Override
    public void write(@NotNull Matrix33 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getC0r0());
        this.buffer.putFloat((float)v.getC0r1());
        this.buffer.putFloat((float)v.getC0r2());
        this.buffer.putFloat((float)v.getC1r0());
        this.buffer.putFloat((float)v.getC1r1());
        this.buffer.putFloat((float)v.getC1r2());
        this.buffer.putFloat((float)v.getC2r0());
        this.buffer.putFloat((float)v.getC2r1());
        this.buffer.putFloat((float)v.getC2r2());
    }

    @Override
    public void write(@NotNull Matrix44 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getC0r0());
        this.buffer.putFloat((float)v.getC0r1());
        this.buffer.putFloat((float)v.getC0r2());
        this.buffer.putFloat((float)v.getC0r3());
        this.buffer.putFloat((float)v.getC1r0());
        this.buffer.putFloat((float)v.getC1r1());
        this.buffer.putFloat((float)v.getC1r2());
        this.buffer.putFloat((float)v.getC1r3());
        this.buffer.putFloat((float)v.getC2r0());
        this.buffer.putFloat((float)v.getC2r1());
        this.buffer.putFloat((float)v.getC2r2());
        this.buffer.putFloat((float)v.getC2r3());
        this.buffer.putFloat((float)v.getC3r0());
        this.buffer.putFloat((float)v.getC3r1());
        this.buffer.putFloat((float)v.getC3r2());
        this.buffer.putFloat((float)v.getC3r3());
    }

    @Override
    public void write(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void write(float x, float y, float z) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
    }

    @Override
    public void write(float x, float y, float z, float w) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(w);
    }

    @Override
    public void write(float x, float y) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
    }

    @Override
    public void write(@NotNull ColorRGBa v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getR());
        this.buffer.putFloat((float)v.getG());
        this.buffer.putFloat((float)v.getB());
        this.buffer.putFloat((float)v.getA());
    }

    @Override
    public int getPosition() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        return ((Buffer)byteBuffer).position();
    }

    @Override
    public void setPosition(int value) {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(value);
    }

    @Override
    public int getPositionElements() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        return ((Buffer)byteBuffer).position() / this.elementSize;
    }

    @Override
    public void setPositionElements(int value) {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(value * this.elementSize);
    }

    @Override
    public void rewind() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    public BufferWriterGL3(@NotNull ByteBuffer buffer2, int elementSize) {
        Intrinsics.checkNotNullParameter(buffer2, "buffer");
        this.buffer = buffer2;
        this.elementSize = elementSize;
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public /* synthetic */ BufferWriterGL3(ByteBuffer byteBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(byteBuffer, n);
    }

    @Override
    public void write(Vector3 ... v) {
        Intrinsics.checkNotNullParameter(v, "v");
        BufferWriter.DefaultImpls.write(this, v);
    }
}

