/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferTextureFileFormat;
import org.openrndr.draw.BufferTextureShadow;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;
import org.openrndr.internal.gl3.BufferTextureShadowGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.ErrorGL3Kt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016J\b\u0010*\u001a\u00020(H\u0016J\r\u0010+\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b,J \u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0016J \u00102\u001a\u00020(2\u0006\u00103\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00066"}, d2={"Lorg/openrndr/internal/gl3/BufferTextureGL3;", "Lorg/openrndr/draw/BufferTexture;", "texture", "", "buffer", "elementCount", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "(IIILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;Lorg/openrndr/draw/Session;)V", "getBuffer", "()I", "destroyed", "", "getDestroyed$openrndr_gl3", "()Z", "setDestroyed$openrndr_gl3", "(Z)V", "getElementCount", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "realShadow", "Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;", "getRealShadow$openrndr_gl3", "()Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;", "setRealShadow$openrndr_gl3", "(Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;)V", "getSession", "()Lorg/openrndr/draw/Session;", "shadow", "Lorg/openrndr/draw/BufferTextureShadow;", "getShadow", "()Lorg/openrndr/draw/BufferTextureShadow;", "getTexture", "getType", "()Lorg/openrndr/draw/ColorType;", "bind", "", "unit", "destroy", "glFormat", "glFormat$openrndr_gl3", "read", "target", "Ljava/nio/ByteBuffer;", "offset", "elementReadCount", "write", "source", "elementWriteCount", "Companion", "openrndr-gl3"})
public final class BufferTextureGL3
implements BufferTexture {
    @Nullable
    private BufferTextureShadowGL3 realShadow;
    private boolean destroyed;
    private final int texture;
    private final int buffer;
    private final int elementCount;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    @Nullable
    private final Session session;
    public static final Companion Companion = new Companion(null);

    public final int glFormat$openrndr_gl3() {
        return ((Number)ColorBufferGL3Kt.internalFormat(this.getFormat(), this.getType()).getFirst()).intValue();
    }

    @Nullable
    public final BufferTextureShadowGL3 getRealShadow$openrndr_gl3() {
        return this.realShadow;
    }

    public final void setRealShadow$openrndr_gl3(@Nullable BufferTextureShadowGL3 bufferTextureShadowGL3) {
        this.realShadow = bufferTextureShadowGL3;
    }

    @Override
    @NotNull
    public BufferTextureShadow getShadow() {
        if (this.realShadow == null) {
            this.realShadow = new BufferTextureShadowGL3(this);
        }
        BufferTextureShadowGL3 bufferTextureShadowGL3 = this.realShadow;
        Intrinsics.checkNotNull(bufferTextureShadowGL3);
        return bufferTextureShadowGL3;
    }

    @Override
    public void read(@NotNull ByteBuffer target2, int offset2, int elementReadCount) {
        Intrinsics.checkNotNullParameter(target2, "target");
        int oldLimit = target2.limit();
        target2.limit(target2.position() + elementReadCount * this.getFormat().getComponentCount() * this.getType().getComponentSize());
        GL33C.glBindBuffer(35882, this.buffer);
        GL33C.glGetBufferSubData(35882, 0L, target2);
        target2.limit(oldLimit);
    }

    @Override
    public void write(@NotNull ByteBuffer source, int offset2, int elementWriteCount) {
        Intrinsics.checkNotNullParameter(source, "source");
        boolean bl = source.isDirect();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int oldLimit = source.limit();
        source.limit(source.position() + elementWriteCount * this.getFormat().getComponentCount() * this.getType().getComponentSize());
        GL33C.glBindBuffer(35882, this.buffer);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
        GL33C.glBufferSubData(35882, 0L, source);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
        source.limit(oldLimit);
    }

    @Override
    public void bind(int unit) {
        GL33C.glActiveTexture(33984 + unit);
        GL33C.glBindTexture(35882, this.texture);
    }

    public final boolean getDestroyed$openrndr_gl3() {
        return this.destroyed;
    }

    public final void setDestroyed$openrndr_gl3(boolean bl) {
        this.destroyed = bl;
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
            GL33C.glDeleteTextures(this.texture);
            this.destroyed = true;
        }
    }

    public final int getTexture() {
        return this.texture;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    @NotNull
    public ColorFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public ColorType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    public BufferTextureGL3(int texture, int buffer2, int elementCount, @NotNull ColorFormat format, @NotNull ColorType type2, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.texture = texture;
        this.buffer = buffer2;
        this.elementCount = elementCount;
        this.format = format;
        this.type = type2;
        this.session = session;
    }

    @Override
    public int put(@NotNull Function1<? super BufferWriter, Unit> putter) {
        Intrinsics.checkNotNullParameter(putter, "putter");
        return BufferTexture.DefaultImpls.put(this, putter);
    }

    @Override
    public void saveToFile(@NotNull File file, @NotNull BufferTextureFileFormat fileFormat) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter((Object)fileFormat, "fileFormat");
        BufferTexture.DefaultImpls.saveToFile(this, file, fileFormat);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/internal/gl3/BufferTextureGL3$Companion;", "", "()V", "create", "Lorg/openrndr/internal/gl3/BufferTextureGL3;", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final BufferTextureGL3 create(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type2, @Nullable Session session) {
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            int sizeInBytes = format.getComponentCount() * type2.getComponentSize() * elementCount;
            int[] buffers = new int[1];
            GL33C.glGenBuffers(buffers);
            GL33C.glBindBuffer(35882, buffers[0]);
            GL33C.glBufferData(35882, sizeInBytes, 35040);
            int[] textures = new int[1];
            GL33C.glGenTextures(textures);
            GL33C.glBindTexture(35882, textures[0]);
            GL33C.glTexBuffer(35882, ((Number)ColorBufferGL3Kt.internalFormat(format, type2).getFirst()).intValue(), buffers[0]);
            GL33C.glBindBuffer(35882, 0);
            return new BufferTextureGL3(textures[0], buffers[0], elementCount, format, type2, session);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

