/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.RectangleBatch;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J4\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J2\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ$\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001aJ&\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0015\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020 H\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/openrndr/internal/RectangleDrawer;", "", "()V", "batch", "Lorg/openrndr/draw/RectangleBatch;", "getBatch$openrndr_core", "()Lorg/openrndr/draw/RectangleBatch;", "setBatch$openrndr_core", "(Lorg/openrndr/draw/RectangleBatch;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawRectangle", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "width", "height", "drawRectangles", "positions", "", "Lorg/openrndr/math/Vector2;", "dimensions", "rectangles", "Lorg/openrndr/shape/Rectangle;", "count", "", "ensureBatchSize", "size", "ensureBatchSize$openrndr_core", "openrndr-core"})
public final class RectangleDrawer {
    private final VertexBuffer vertices;
    @NotNull
    private RectangleBatch batch;
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final RectangleBatch getBatch$openrndr_core() {
        return this.batch;
    }

    public final void setBatch$openrndr_core(@NotNull RectangleBatch rectangleBatch) {
        Intrinsics.checkNotNullParameter(rectangleBatch, "<set-?>");
        this.batch = rectangleBatch;
    }

    public final void ensureBatchSize$openrndr_core(int size) {
        if (this.batch.getSize() < size) {
            this.batch.destroy();
            this.batch = RectangleBatch.Companion.create(size, Session.Companion.getRoot());
        }
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Vector2> dimensions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(dimensions, "dimensions");
        this.ensureBatchSize$openrndr_core(positions.size());
        boolean bl = positions.size() == dimensions.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "`positions.size` and `dimensions.size` must be equal in drawRectangles()";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(dimensions, positions){
            final /* synthetic */ List $dimensions;
            final /* synthetic */ List $positions;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                Iterable $this$forEachIndexed$iv = this.$dimensions;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void sz;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Vector2 vector2 = (Vector2)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    double d = 0.0;
                    double d2 = sz.getX();
                    boolean bl3 = false;
                    double d3 = ((Vector2)this.$positions.get(i)).getX() + Math.min(d, d2);
                    d = 0.0;
                    d2 = sz.getY();
                    bl3 = false;
                    $this$put.write(new Vector3(d3, ((Vector2)this.$positions.get(i)).getY() + Math.min(d, d2), 0.0));
                    d = sz.getX();
                    boolean bl4 = false;
                    double d4 = Math.abs(d);
                    d = sz.getY();
                    bl4 = false;
                    $this$put.write(new Vector3(d4, Math.abs(d), 0.0));
                }
            }
            {
                this.$dimensions = list;
                this.$positions = list2;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(positions, drawStyle){
            final /* synthetic */ List $positions;
            final /* synthetic */ DrawStyle $drawStyle;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    BatchesKt.write($this$put, this.$drawStyle);
                    ++i;
                }
            }
            {
                this.$positions = list;
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_core(positions.size());
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(positions, width, height){
            final /* synthetic */ List $positions;
            final /* synthetic */ double $width;
            final /* synthetic */ double $height;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                Iterable $this$forEach$iv = this.$positions;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Vector2 it = (Vector2)element$iv;
                    boolean bl = false;
                    double d = 0.0;
                    double d2 = this.$width;
                    boolean bl2 = false;
                    double d3 = it.getX() + Math.min(d, d2);
                    d = 0.0;
                    d2 = this.$height;
                    bl2 = false;
                    $this$put.write(new Vector3(d3, it.getY() + Math.min(d, d2), 0.0));
                    d = this.$width;
                    boolean bl3 = false;
                    double d4 = Math.abs(d);
                    d = this.$height;
                    bl3 = false;
                    $this$put.write(new Vector3(d4, Math.abs(d), 0.0));
                }
            }
            {
                this.$positions = list;
                this.$width = d;
                this.$height = d2;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(positions, drawStyle){
            final /* synthetic */ List $positions;
            final /* synthetic */ DrawStyle $drawStyle;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    BatchesKt.write($this$put, this.$drawStyle);
                    ++i;
                }
            }
            {
                this.$positions = list;
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        this.ensureBatchSize$openrndr_core(rectangles.size());
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(rectangles){
            final /* synthetic */ List $rectangles;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                Iterable $this$forEach$iv = this.$rectangles;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Rectangle it = (Rectangle)element$iv;
                    boolean bl = false;
                    double d = 0.0;
                    double d2 = it.getWidth();
                    boolean bl2 = false;
                    double d3 = it.getX() + Math.min(d, d2);
                    d = 0.0;
                    d2 = it.getHeight();
                    bl2 = false;
                    $this$put.write(new Vector3(d3, it.getY() + Math.min(d, d2), 0.0));
                    d = it.getWidth();
                    boolean bl3 = false;
                    double d4 = Math.abs(d);
                    d = it.getHeight();
                    bl3 = false;
                    $this$put.write(new Vector3(d4, Math.abs(d), 0.0));
                }
            }
            {
                this.$rectangles = list;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(rectangles, drawStyle){
            final /* synthetic */ List $rectangles;
            final /* synthetic */ DrawStyle $drawStyle;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$rectangles).size();
                while (n < n2) {
                    void i;
                    BatchesKt.write($this$put, this.$drawStyle);
                    ++i;
                }
            }
            {
                this.$rectangles = list;
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, rectangles.size());
    }

    public final void drawRectangle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.ensureBatchSize$openrndr_core(1);
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(x, width, y, height){
            final /* synthetic */ double $x;
            final /* synthetic */ double $width;
            final /* synthetic */ double $y;
            final /* synthetic */ double $height;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                double d = 0.0;
                double d2 = this.$width;
                boolean bl = false;
                double d3 = this.$x + Math.min(d, d2);
                d = 0.0;
                d2 = this.$height;
                bl = false;
                $this$put.write(new Vector3(d3, this.$y + Math.min(d, d2), 0.0));
                d = this.$width;
                boolean bl2 = false;
                double d4 = Math.abs(d);
                d = this.$height;
                bl2 = false;
                $this$put.write(new Vector3(d4, Math.abs(d), 0.0));
            }
            {
                this.$x = d;
                this.$width = d2;
                this.$y = d3;
                this.$height = d4;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(drawStyle){
            final /* synthetic */ DrawStyle $drawStyle;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                BatchesKt.write($this$put, this.$drawStyle);
            }
            {
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, 1);
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull RectangleBatch batch2, int count2) {
        Object object;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(batch2, "batch");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(batch2.getGeometry().getVertexFormat(), batch2.getDrawStyle().getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(batch2.getDrawStyle(), batch2.getGeometry()), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, 0, count2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public RectangleDrawer() {
        void $this$apply;
        VertexFormat vertexFormat2 = new VertexFormat();
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat vertexFormat3 = vertexFormat2;
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        RectangleDrawer rectangleDrawer = this;
        boolean bl3 = false;
        $this$apply.position(3);
        $this$apply.normal(3);
        VertexFormat.textureCoordinate$default((VertexFormat)$this$apply, 2, 0, 2, null);
        Unit unit = Unit.INSTANCE;
        rectangleDrawer.vertices = companion.createDynamic(vertexFormat2, 6, Session.Companion.getRoot());
        this.batch = RectangleBatch.Companion.create(10000, Session.Companion.getRoot());
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "rectangle", new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).rectangleVertexShader(p1);
            }
        }, null, null, null, new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).rectangleFragmentShader(p1);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 pb = new Vector3(x + radius, y, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter bufferWriter = w;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferWriter $this$apply2 = bufferWriter;
        boolean bl6 = false;
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        $this$apply2.write(pd);
        $this$apply2.write(n);
        $this$apply2.write(td);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pb);
        $this$apply2.write(n);
        $this$apply2.write(tb);
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

