/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.PointBatch;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.PointDrawerKt;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J+\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007\u00a2\u0006\u0002\b\u001dJ+\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bH\u0007\u00a2\u0006\u0002\b\u001fJ&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J\u0015\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!H\u0000\u00a2\u0006\u0002\b$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/openrndr/internal/PointDrawer;", "", "()V", "batch", "Lorg/openrndr/draw/PointBatch;", "getBatch$openrndr_core", "()Lorg/openrndr/draw/PointBatch;", "setBatch$openrndr_core", "(Lorg/openrndr/draw/PointBatch;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "getVertices", "()Lorg/openrndr/draw/VertexBuffer;", "drawPoint", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "z", "drawPoints", "positions", "", "Lorg/openrndr/math/Vector2;", "drawPoints2D", "Lorg/openrndr/math/Vector3;", "drawPoints3D", "count", "", "ensureBatchSize", "size", "ensureBatchSize$openrndr_core", "openrndr-core"})
public final class PointDrawer {
    @NotNull
    private final VertexBuffer vertices;
    @NotNull
    private PointBatch batch;
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    @NotNull
    public final PointBatch getBatch$openrndr_core() {
        return this.batch;
    }

    public final void setBatch$openrndr_core(@NotNull PointBatch pointBatch) {
        Intrinsics.checkNotNullParameter(pointBatch, "<set-?>");
        this.batch = pointBatch;
    }

    public final void ensureBatchSize$openrndr_core(int size) {
        if (this.batch.getSize() < size) {
            PointDrawerKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this, size){
                final /* synthetic */ PointDrawer this$0;
                final /* synthetic */ int $size;

                @Nullable
                public final Object invoke() {
                    return "resizing buffer from " + this.this$0.getBatch$openrndr_core().getSize() + " to " + this.$size;
                }
                {
                    this.this$0 = pointDrawer;
                    this.$size = n;
                    super(0);
                }
            });
            this.batch.destroy();
            this.batch = PointBatch.Companion.create(size, Session.Companion.getRoot());
        }
    }

    @JvmName(name="drawPoints2D")
    public final void drawPoints2D(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_core(positions.size());
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(positions){
            final /* synthetic */ List $positions;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    $this$put.write(new Vector3(((Vector2)this.$positions.get((int)i)).getX(), ((Vector2)this.$positions.get((int)i)).getY(), 0.0));
                    ++i;
                }
            }
            {
                this.$positions = list;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(positions, drawStyle){
            final /* synthetic */ List $positions;
            final /* synthetic */ DrawStyle $drawStyle;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    BatchesKt.write($this$put, this.$drawStyle);
                    ++i;
                }
            }
            {
                this.$positions = list;
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawPoints(drawContext, drawStyle, this.batch, positions.size());
    }

    @JvmName(name="drawPoints3D")
    public final void drawPoints3D(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector3> positions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_core(positions.size());
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(positions){
            final /* synthetic */ List $positions;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    $this$put.write((Vector3)this.$positions.get((int)i));
                    ++i;
                }
            }
            {
                this.$positions = list;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(positions, drawStyle){
            final /* synthetic */ List $positions;
            final /* synthetic */ DrawStyle $drawStyle;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                int n = 0;
                int n2 = ((Collection)this.$positions).size();
                while (n < n2) {
                    void i;
                    BatchesKt.write($this$put, this.$drawStyle);
                    ++i;
                }
            }
            {
                this.$positions = list;
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawPoints(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawPoint(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double z) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.ensureBatchSize$openrndr_core(1);
        VertexBuffer.DefaultImpls.put$default(this.batch.getGeometry(), 0, new Function1<BufferWriter, Unit>(x, y, z){
            final /* synthetic */ double $x;
            final /* synthetic */ double $y;
            final /* synthetic */ double $z;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                $this$put.write(new Vector3(this.$x, this.$y, this.$z));
            }
            {
                this.$x = d;
                this.$y = d2;
                this.$z = d3;
                super(1);
            }
        }, 1, null);
        VertexBuffer.DefaultImpls.put$default(this.batch.getDrawStyle(), 0, new Function1<BufferWriter, Unit>(drawStyle){
            final /* synthetic */ DrawStyle $drawStyle;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                BatchesKt.write($this$put, this.$drawStyle);
            }
            {
                this.$drawStyle = drawStyle;
                super(1);
            }
        }, 1, null);
        this.drawPoints(drawContext, drawStyle, this.batch, 1);
    }

    public final void drawPoints(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull PointBatch batch2, int count2) {
        Object object;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(batch2, "batch");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(batch2.getGeometry().getVertexFormat(), batch2.getDrawStyle().getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(batch2.getDrawStyle(), batch2.getGeometry()), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.POINTS, 0, 1, 0, count2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public PointDrawer() {
        void $this$apply;
        VertexFormat vertexFormat2 = new VertexFormat();
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat vertexFormat3 = vertexFormat2;
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        PointDrawer pointDrawer = this;
        boolean bl3 = false;
        $this$apply.position(3);
        $this$apply.normal(3);
        Unit unit = Unit.INSTANCE;
        pointDrawer.vertices = VertexBuffer.Companion.createDynamic$default(companion, vertexFormat2, 1, null, 4, null);
        this.batch = PointBatch.Companion.create(10000, Session.Companion.getRoot());
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "point", new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).pointVertexShader(p1);
            }
        }, null, null, null, new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).pointFragmentShader(p1);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter bufferWriter = w;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferWriter $this$apply2 = bufferWriter;
        boolean bl6 = false;
        $this$apply2.write(pa);
        $this$apply2.write(n);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

