/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ffmpeg;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.ffmpeg.MP4Profile;
import org.openrndr.ffmpeg.ScreenRecorder;
import org.openrndr.ffmpeg.VideoWriter;
import org.openrndr.ffmpeg.VideoWriterProfile;
import org.openrndr.utils.NamedTimestampKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010P\u001a\u00020J2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010Q\u001a\u00020J2\u0006\u0010M\u001a\u00020NH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0006\"\u0004\b$\u0010\bR\u001a\u0010%\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\f\"\u0004\b>\u0010\u000eR\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0006\"\u0004\bC\u0010\bR\u000e\u0010D\u001a\u00020EX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010F\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\bG\u0010\u001e\"\u0004\bH\u0010 \u00a8\u0006R"}, d2={"Lorg/openrndr/ffmpeg/ScreenRecorder;", "Lorg/openrndr/Extension;", "()V", "contentScale", "", "getContentScale", "()D", "setContentScale", "(D)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "frame", "Lorg/openrndr/draw/RenderTarget;", "frameClock", "getFrameClock", "setFrameClock", "frameIndex", "", "frameRate", "", "getFrameRate", "()I", "setFrameRate", "(I)V", "height", "getHeight", "()Ljava/lang/Integer;", "setHeight", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "maximumDuration", "getMaximumDuration", "setMaximumDuration", "maximumFrames", "getMaximumFrames", "()J", "setMaximumFrames", "(J)V", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "setMultisample", "(Lorg/openrndr/draw/BufferMultisample;)V", "outputFile", "", "getOutputFile", "()Ljava/lang/String;", "setOutputFile", "(Ljava/lang/String;)V", "profile", "Lorg/openrndr/ffmpeg/VideoWriterProfile;", "getProfile", "()Lorg/openrndr/ffmpeg/VideoWriterProfile;", "setProfile", "(Lorg/openrndr/ffmpeg/VideoWriterProfile;)V", "quitAfterMaximum", "getQuitAfterMaximum", "setQuitAfterMaximum", "resolved", "Lorg/openrndr/draw/ColorBuffer;", "timeOffset", "getTimeOffset", "setTimeOffset", "videoWriter", "Lorg/openrndr/ffmpeg/VideoWriter;", "width", "getWidth", "setWidth", "afterDraw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "beforeDraw", "setup", "shutdown", "openrndr-ffmpeg"})
public final class ScreenRecorder
implements Extension {
    private boolean enabled = true;
    private VideoWriter videoWriter;
    private RenderTarget frame;
    private ColorBuffer resolved;
    private long frameIndex;
    @Nullable
    private Integer width;
    @Nullable
    private Integer height;
    @Nullable
    private String outputFile;
    private int frameRate = 30;
    private double timeOffset;
    @NotNull
    private VideoWriterProfile profile = new MP4Profile();
    private boolean frameClock = true;
    @NotNull
    private BufferMultisample multisample = BufferMultisample.Disabled.INSTANCE;
    private long maximumFrames = Long.MAX_VALUE;
    private double maximumDuration = Double.POSITIVE_INFINITY;
    private boolean quitAfterMaximum = true;
    private double contentScale = 1.0;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Nullable
    public final Integer getWidth() {
        return this.width;
    }

    public final void setWidth(@Nullable Integer n) {
        this.width = n;
    }

    @Nullable
    public final Integer getHeight() {
        return this.height;
    }

    public final void setHeight(@Nullable Integer n) {
        this.height = n;
    }

    @Nullable
    public final String getOutputFile() {
        return this.outputFile;
    }

    public final void setOutputFile(@Nullable String string) {
        this.outputFile = string;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public final void setFrameRate(int n) {
        this.frameRate = n;
    }

    public final double getTimeOffset() {
        return this.timeOffset;
    }

    public final void setTimeOffset(double d) {
        this.timeOffset = d;
    }

    @NotNull
    public final VideoWriterProfile getProfile() {
        return this.profile;
    }

    public final void setProfile(@NotNull VideoWriterProfile videoWriterProfile) {
        Intrinsics.checkNotNullParameter(videoWriterProfile, "<set-?>");
        this.profile = videoWriterProfile;
    }

    public final boolean getFrameClock() {
        return this.frameClock;
    }

    public final void setFrameClock(boolean bl) {
        this.frameClock = bl;
    }

    @NotNull
    public final BufferMultisample getMultisample() {
        return this.multisample;
    }

    public final void setMultisample(@NotNull BufferMultisample bufferMultisample) {
        Intrinsics.checkNotNullParameter(bufferMultisample, "<set-?>");
        this.multisample = bufferMultisample;
    }

    public final long getMaximumFrames() {
        return this.maximumFrames;
    }

    public final void setMaximumFrames(long l) {
        this.maximumFrames = l;
    }

    public final double getMaximumDuration() {
        return this.maximumDuration;
    }

    public final void setMaximumDuration(double d) {
        this.maximumDuration = d;
    }

    public final boolean getQuitAfterMaximum() {
        return this.quitAfterMaximum;
    }

    public final void setQuitAfterMaximum(boolean bl) {
        this.quitAfterMaximum = bl;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(double d) {
        this.contentScale = d;
    }

    @Override
    public void setup(@NotNull Program program2) {
        String string;
        Intrinsics.checkNotNullParameter(program2, "program");
        if (this.frameClock) {
            program2.setClock(new Function0<Double>(this){
                final /* synthetic */ ScreenRecorder this$0;

                public final double invoke() {
                    return (double)ScreenRecorder.access$getFrameIndex$p(this.this$0) / (double)this.this$0.getFrameRate() + this.this$0.getTimeOffset();
                }
                {
                    this.this$0 = screenRecorder;
                    super(0);
                }
            });
        }
        Integer n = this.width;
        int effectiveWidth = (int)((double)(n != null ? n.intValue() : program2.getWidth()) * this.contentScale);
        Integer n2 = this.height;
        int effectiveHeight = (int)((double)(n2 != null ? n2.intValue() : program2.getHeight()) * this.contentScale);
        this.frame = RenderTargetKt.renderTarget$default(effectiveWidth, effectiveHeight, 0.0, this.multisample, null, setup.2.INSTANCE, 20, null);
        if (Intrinsics.areEqual(this.multisample, BufferMultisample.Disabled.INSTANCE) ^ true) {
            this.resolved = ColorBufferKt.colorBuffer$default(effectiveWidth, effectiveHeight, 0.0, null, null, null, 0, null, 252, null);
        }
        if ((string = this.outputFile) == null) {
            string = NamedTimestampKt.namedTimestamp(program2, this.profile.getFileExtension(), "video/");
        }
        String filename = string;
        File file = new File(filename).getParentFile();
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            if (!it.exists()) {
                it.mkdirs();
            }
        }
        this.videoWriter = new VideoWriter().profile(this.profile).output(filename).size(effectiveWidth, effectiveHeight).frameRate(this.frameRate).start();
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block1: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(program2, "program");
            RenderTarget renderTarget2 = this.frame;
            if (renderTarget2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
            }
            renderTarget2.bind();
            ColorRGBa colorRGBa = program2.getBackgroundColor();
            if (colorRGBa == null) break block1;
            ColorRGBa colorRGBa2 = colorRGBa;
            boolean bl = false;
            boolean bl2 = false;
            ColorRGBa it = colorRGBa2;
            boolean bl3 = false;
            drawer.clear(it);
        }
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        RenderTarget renderTarget2 = this.frame;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
        }
        renderTarget2.unbind();
        if (this.frameIndex < this.maximumFrames && (double)this.frameIndex / (double)this.frameRate < this.maximumDuration) {
            ColorBuffer lresolved = this.resolved;
            if (lresolved != null) {
                RenderTarget renderTarget3 = this.frame;
                if (renderTarget3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                }
                ColorBuffer.DefaultImpls.resolveTo$default(renderTarget3.colorBuffer(0), lresolved, 0, 0, 6, null);
                VideoWriter videoWriter = this.videoWriter;
                if (videoWriter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                }
                videoWriter.frame(lresolved);
            } else {
                VideoWriter videoWriter = this.videoWriter;
                if (videoWriter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                }
                RenderTarget renderTarget4 = this.frame;
                if (renderTarget4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                }
                videoWriter.frame(renderTarget4.colorBuffer(0));
            }
            DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, lresolved){
                final /* synthetic */ ScreenRecorder this$0;
                final /* synthetic */ Drawer $drawer;
                final /* synthetic */ ColorBuffer $lresolved;

                public final void invoke(@NotNull Drawer $this$isolated) {
                    Intrinsics.checkNotNullParameter($this$isolated, "$receiver");
                    this.$drawer.defaults();
                    if (this.$lresolved != null) {
                        this.$drawer.image(this.$lresolved);
                    } else {
                        this.$drawer.image(ScreenRecorder.access$getFrame$p(this.this$0).colorBuffer(0), 0.0, 0.0, (double)ScreenRecorder.access$getFrame$p(this.this$0).getWidth() / this.this$0.getContentScale(), (double)ScreenRecorder.access$getFrame$p(this.this$0).getHeight() / this.this$0.getContentScale());
                    }
                }
                {
                    this.this$0 = screenRecorder;
                    this.$drawer = drawer;
                    this.$lresolved = colorBuffer;
                    super(1);
                }
            });
        } else if (this.quitAfterMaximum) {
            VideoWriter videoWriter = this.videoWriter;
            if (videoWriter == null) {
                Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
            }
            videoWriter.stop();
            program2.getApplication().exit();
        }
        long l = this.frameIndex;
        this.frameIndex = l + 1L;
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        VideoWriter videoWriter = this.videoWriter;
        if (videoWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
        }
        videoWriter.stop();
    }

    public static final /* synthetic */ long access$getFrameIndex$p(ScreenRecorder $this) {
        return $this.frameIndex;
    }

    public static final /* synthetic */ void access$setFrameIndex$p(ScreenRecorder $this, long l) {
        $this.frameIndex = l;
    }

    public static final /* synthetic */ RenderTarget access$getFrame$p(ScreenRecorder $this) {
        RenderTarget renderTarget2 = $this.frame;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
        }
        return renderTarget2;
    }

    public static final /* synthetic */ void access$setFrame$p(ScreenRecorder $this, RenderTarget renderTarget2) {
        $this.frame = renderTarget2;
    }
}

