/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Session;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fJ\b\u0010\u0012\u001a\u00020\u0013H&J+\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u000b2\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\b\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u000bH&J\u001a\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u000bH&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/openrndr/draw/VertexBuffer;", "", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "shadow", "Lorg/openrndr/draw/VertexBufferShadow;", "getShadow", "()Lorg/openrndr/draw/VertexBufferShadow;", "vertexCount", "", "getVertexCount", "()I", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "destroy", "", "put", "elementOffset", "putter", "Lkotlin/Function1;", "Lorg/openrndr/draw/BufferWriter;", "Lkotlin/ExtensionFunctionType;", "read", "data", "Ljava/nio/ByteBuffer;", "offset", "write", "Companion", "openrndr-core"})
public interface VertexBuffer {
    public static final Companion Companion = org.openrndr.draw.VertexBuffer$Companion.$$INSTANCE;

    @Nullable
    public Session getSession();

    @NotNull
    public VertexFormat getVertexFormat();

    public int getVertexCount();

    @NotNull
    public VertexBufferShadow getShadow();

    public void write(@NotNull ByteBuffer var1, int var2);

    public void read(@NotNull ByteBuffer var1, int var2);

    public void destroy();

    public int put(int var1, @NotNull Function1<? super BufferWriter, Unit> var2);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static /* synthetic */ void write$default(VertexBuffer vertexBuffer, ByteBuffer byteBuffer, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            vertexBuffer.write(byteBuffer, n);
        }

        public static /* synthetic */ void read$default(VertexBuffer vertexBuffer, ByteBuffer byteBuffer, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            vertexBuffer.read(byteBuffer, n);
        }

        public static int put(@NotNull VertexBuffer $this, int elementOffset, @NotNull Function1<? super BufferWriter, Unit> putter) {
            Intrinsics.checkNotNullParameter(putter, "putter");
            BufferWriter w = $this.getShadow().writer();
            w.rewind();
            w.setPositionElements(elementOffset);
            putter.invoke(w);
            if (w.getPosition() % $this.getVertexFormat().getSize() != 0) {
                throw (Throwable)new RuntimeException("incomplete vertices written. likely violating the specified vertex format " + $this.getVertexFormat());
            }
            int count2 = w.getPositionElements();
            $this.getShadow().uploadElements(elementOffset, count2);
            w.rewind();
            return count2;
        }

        public static /* synthetic */ int put$default(VertexBuffer vertexBuffer, int n, Function1 function1, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
            }
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return vertexBuffer.put(n, function1);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/draw/VertexBuffer$Companion;", "", "()V", "createDynamic", "Lorg/openrndr/draw/VertexBuffer;", "format", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "", "session", "Lorg/openrndr/draw/Session;", "createFromFloats", "data", "", "openrndr-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final VertexBuffer createDynamic(@NotNull VertexFormat format, int vertexCount2, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(format, "format");
            return Driver.Companion.getInstance().createDynamicVertexBuffer(format, vertexCount2, session);
        }

        public static /* synthetic */ VertexBuffer createDynamic$default(Companion companion, VertexFormat vertexFormat2, int n, Session session, int n2, Object object) {
            if ((n2 & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.createDynamic(vertexFormat2, n, session);
        }

        @NotNull
        public final VertexBuffer createFromFloats(@NotNull VertexFormat format, @NotNull float[] data2, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(data2, "data");
            boolean bl = data2.length * 4 % format.getSize() == 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "supplied data size doesn't match format size";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            VertexBuffer vertexBuffer = this.createDynamic(format, data2.length * 4 / format.getSize(), session);
            DefaultImpls.put$default(vertexBuffer, 0, new Function1<BufferWriter, Unit>(data2){
                final /* synthetic */ float[] $data;

                public final void invoke(@NotNull BufferWriter $this$put) {
                    Intrinsics.checkNotNullParameter($this$put, "$receiver");
                    BufferWriter.DefaultImpls.write$default($this$put, this.$data, 0, 0, 6, null);
                }
                {
                    this.$data = fArray;
                    super(1);
                }
            }, 1, null);
            return vertexBuffer;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

