/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.PointBatch;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0015J\u001b\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0007\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0007\u00a2\u0006\u0002\b\u001aR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/draw/PointBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/PointBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "batch", "Lorg/openrndr/draw/PointBatch;", "existingBatch", "point", "", "x", "", "y", "z", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "points", "positions", "", "points2D", "points3D", "Entry", "openrndr-core"})
public final class PointBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void point(double x, double y) {
        this.entries.add(new Entry(this.getFill(), new Vector3(x, y, 0.0)));
    }

    public final void point(double x, double y, double z) {
        this.entries.add(new Entry(this.getFill(), new Vector3(x, y, z)));
    }

    public final void point(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.entries.add(new Entry(this.getFill(), position.getXy0()));
    }

    public final void point(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.entries.add(new Entry(this.getFill(), position));
    }

    @JvmName(name="points3D")
    public final void points3D(@NotNull List<Vector3> positions) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        for (Vector3 position : positions) {
            this.point(position);
        }
    }

    @JvmName(name="points2D")
    public final void points2D(@NotNull List<Vector2> positions) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        for (Vector2 position : positions) {
            this.point(position);
        }
    }

    @NotNull
    public final PointBatch batch(@Nullable PointBatch existingBatch) {
        Object object = existingBatch;
        if (object == null || (object = ((PointBatch)object).getGeometry()) == null) {
            object = VertexBufferKt.vertexBuffer$default(BatchesKt.getPointFormat(), this.entries.size(), null, 4, null);
        }
        Object geometry = object;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)geometry, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ PointBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    $this$put.write(entry.getOffset());
                }
            }
            {
                this.this$0 = pointBatchBuilder;
                super(1);
            }
        }, 1, null);
        Object object2 = existingBatch;
        if (object2 == null || (object2 = ((PointBatch)object2).getDrawStyle()) == null) {
            object2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        Object drawStyle = object2;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)drawStyle, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ PointBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    ColorRGBa colorRGBa = entry.getFill();
                    if (colorRGBa == null) {
                        colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa);
                    ColorRGBa colorRGBa2 = entry.getFill();
                    if (colorRGBa2 == null) {
                        colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa2);
                    $this$put.write(1.0f);
                }
            }
            {
                this.this$0 = pointBatchBuilder;
                super(1);
            }
        }, 1, null);
        PointBatch pointBatch = existingBatch;
        if (pointBatch == null) {
            pointBatch = new PointBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return pointBatch;
    }

    public static /* synthetic */ PointBatch batch$default(PointBatchBuilder pointBatchBuilder, PointBatch pointBatch, int n, Object object) {
        if ((n & 1) != 0) {
            pointBatch = null;
        }
        return pointBatchBuilder.batch(pointBatch);
    }

    public PointBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        boolean bl = false;
        this.entries = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/draw/PointBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "offset", "Lorg/openrndr/math/Vector3;", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/math/Vector3;)V", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getOffset", "()Lorg/openrndr/math/Vector3;", "openrndr-core"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @NotNull
        private final Vector3 offset;

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }

        public Entry(@Nullable ColorRGBa fill2, @NotNull Vector3 offset2) {
            Intrinsics.checkNotNullParameter(offset2, "offset");
            this.fill = fill2;
            this.offset = offset2;
        }
    }
}

