/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FilterKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Matrix55;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016\u00a2\u0006\u0002\u0010\"J!\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0002\u0010#J!\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020$\u00a2\u0006\u0002\u0010%J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010&J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0006\u0010'\u001a\u00020\u001dR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/openrndr/draw/Filter;", "", "shader", "Lorg/openrndr/draw/Shader;", "watcher", "Lorg/openrndr/draw/ShaderWatcher;", "(Lorg/openrndr/draw/Shader;Lorg/openrndr/draw/ShaderWatcher;)V", "depthBufferOut", "Lorg/openrndr/draw/DepthBuffer;", "getDepthBufferOut", "()Lorg/openrndr/draw/DepthBuffer;", "setDepthBufferOut", "(Lorg/openrndr/draw/DepthBuffer;)V", "format", "Lorg/openrndr/draw/VertexFormat;", "getFormat", "()Lorg/openrndr/draw/VertexFormat;", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "apply", "", "source", "", "Lorg/openrndr/draw/ColorBuffer;", "target", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/ColorBuffer;)V", "Lorg/openrndr/draw/RenderTarget;", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/RenderTarget;)V", "(Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "untrack", "Companion", "openrndr-core"})
public class Filter {
    @NotNull
    private final Map<String, Object> parameters;
    private int padding;
    @Nullable
    private DepthBuffer depthBufferOut;
    private final Shader shader;
    private final ShaderWatcher watcher;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    @Nullable
    public final DepthBuffer getDepthBufferOut() {
        return this.depthBufferOut;
    }

    public final void setDepthBufferOut(@Nullable DepthBuffer depthBuffer) {
        this.depthBufferOut = depthBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBuffer[] colorBufferArray = target2;
        boolean bl = false;
        if (colorBufferArray.length == 0) {
            return;
        }
        RenderTarget renderTarget2 = RenderTargetKt.renderTarget$default(target2[0].getWidth(), target2[0].getHeight(), target2[0].getContentScale(), null, null, apply.renderTarget.1.INSTANCE, 24, null);
        ColorBuffer[] $this$forEach$iv22 = target2;
        boolean $i$f$forEach = false;
        ColorBuffer[] colorBufferArray2 = $this$forEach$iv22;
        int n = colorBufferArray2.length;
        for (int i = 0; i < n; ++i) {
            ColorBuffer element$iv;
            ColorBuffer it = element$iv = colorBufferArray2[i];
            boolean bl2 = false;
            RenderTarget.DefaultImpls.attach$default(renderTarget2, it, 0, null, 6, null);
        }
        int $this$forEach$iv22 = 1;
        int n2 = target2.length;
        while ($this$forEach$iv22 < n2) {
            void i;
            renderTarget2.blendMode((int)i, BlendMode.REPLACE);
            ++i;
        }
        this.apply(source, renderTarget2);
        DepthBuffer depthBuffer = this.depthBufferOut;
        if (depthBuffer != null) {
            DepthBuffer depthBuffer2 = depthBuffer;
            n2 = 0;
            boolean bl3 = false;
            DepthBuffer it = depthBuffer2;
            boolean bl4 = false;
            renderTarget2.attach(it);
        }
        if (this.depthBufferOut != null) {
            renderTarget2.detachDepthBuffer();
        }
        renderTarget2.detachColorAttachments();
        renderTarget2.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull ColorBuffer[] source, @NotNull RenderTarget target2) {
        Shader shader2;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (this.watcher != null) {
            Shader shader3 = this.watcher.getShader();
            shader2 = shader3;
            Intrinsics.checkNotNull(shader3);
        } else {
            Shader shader4 = this.shader;
            shader2 = shader4;
            Intrinsics.checkNotNull(shader4);
        }
        Shader shader5 = shader2;
        target2.bind();
        if (FilterKt.access$getFilterQuad$p() == null) {
            VertexBuffer fq = VertexBuffer.Companion.createDynamic(FilterKt.access$getFilterQuadFormat$p(), 6, Session.Companion.getRoot());
            BufferWriter bufferWriter = fq.getShadow().writer();
            boolean bl = false;
            boolean bl2 = false;
            BufferWriter $this$apply = bufferWriter;
            boolean bl3 = false;
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            VertexBufferShadow.DefaultImpls.upload$default(fq.getShadow(), 0, 0, 3, null);
            fq.getShadow().destroy();
            FilterKt.access$setFilterQuad$p(fq);
        }
        shader5.begin();
        ColorBuffer[] $this$forEachIndexed$iv = source;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ColorBuffer item$iv : $this$forEachIndexed$iv) {
            void colorBuffer;
            int n = index$iv++;
            ColorBuffer colorBuffer2 = item$iv;
            int index = n;
            boolean bl = false;
            colorBuffer.bind(index);
            shader5.uniform("tex" + index, index);
        }
        Driver.Companion.getInstance().setState(FilterKt.access$getFilterDrawStyle$p());
        shader5.uniform("projectionMatrix", TransformsKt.ortho(0.0, target2.getWidth(), target2.getHeight(), 0.0, -1.0, 1.0));
        shader5.uniform("targetSize", new Vector2(target2.getWidth(), target2.getHeight()));
        shader5.uniform("padding", new Vector2(this.padding, this.padding));
        int textureIndex = source.length + 0;
        Map<String, Object> $this$forEach$iv = this.parameters;
        boolean $i$f$forEach = false;
        Map<String, Object> map2 = $this$forEach$iv;
        int n = 0;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void uniform2;
            Map.Entry element$iv;
            Map.Entry $dstr$uniform$value = element$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $dstr$uniform$value;
            int n2 = 0;
            String string = (String)entry.getKey();
            entry = $dstr$uniform$value;
            n2 = 0;
            Object value = entry.getValue();
            if ((entry = value) instanceof Boolean) {
                shader5.uniform((String)uniform2, (Boolean)value);
                continue;
            }
            if (entry instanceof Float) {
                shader5.uniform((String)uniform2, ((Number)value).floatValue());
                continue;
            }
            if (entry instanceof Double) {
                shader5.uniform((String)uniform2, (float)((Number)value).doubleValue());
                continue;
            }
            if (entry instanceof Matrix44) {
                shader5.uniform((String)uniform2, (Matrix44)value);
                continue;
            }
            if (entry instanceof Vector2) {
                shader5.uniform((String)uniform2, (Vector2)value);
                continue;
            }
            if (entry instanceof Vector3) {
                shader5.uniform((String)uniform2, (Vector3)value);
                continue;
            }
            if (entry instanceof Vector4) {
                shader5.uniform((String)uniform2, (Vector4)value);
                continue;
            }
            if (entry instanceof IntVector2) {
                shader5.uniform((String)uniform2, (IntVector2)value);
                continue;
            }
            if (entry instanceof IntVector3) {
                shader5.uniform((String)uniform2, (IntVector3)value);
                continue;
            }
            if (entry instanceof IntVector4) {
                shader5.uniform((String)uniform2, (IntVector4)value);
                continue;
            }
            if (entry instanceof ColorRGBa) {
                shader5.uniform((String)uniform2, (ColorRGBa)value);
                continue;
            }
            if (entry instanceof Integer) {
                shader5.uniform((String)uniform2, ((Number)value).intValue());
                continue;
            }
            if (entry instanceof Matrix55) {
                shader5.uniform((String)uniform2, ((Matrix55)value).getFloatArray());
                continue;
            }
            if (entry instanceof float[]) {
                shader5.uniform((String)uniform2, (float[])value);
                continue;
            }
            if (entry instanceof Object[]) {
                if (((Object[])value).length <= 0) continue;
                Object object = ((Object[])value)[0];
                if (object instanceof Vector2) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector2>");
                    }
                    shader5.uniform((String)uniform2, (Vector2[])v);
                    continue;
                }
                if (object instanceof Vector3) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector3>");
                    }
                    shader5.uniform((String)uniform2, (Vector3[])v);
                    continue;
                }
                if (object instanceof Vector4) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector4>");
                    }
                    shader5.uniform((String)uniform2, (Vector4[])v);
                    continue;
                }
                if (object instanceof IntVector2) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector2>");
                    }
                    shader5.uniform((String)uniform2, (IntVector2[])v);
                    continue;
                }
                if (object instanceof IntVector3) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector3>");
                    }
                    shader5.uniform((String)uniform2, (IntVector3[])v);
                    continue;
                }
                if (object instanceof IntVector4) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector4>");
                    }
                    shader5.uniform((String)uniform2, (IntVector4[])v);
                    continue;
                }
                if (object instanceof ColorRGBa) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.openrndr.color.ColorRGBa>");
                    }
                    shader5.uniform((String)uniform2, (ColorRGBa[])v);
                    continue;
                }
                if (object instanceof Double) {
                    Object v = value;
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Double>");
                    }
                    shader5.uniform((String)uniform2, (Double[])v);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("unsupported array value: ");
                Object object2 = ((Object[])value)[0];
                Intrinsics.checkNotNull(object2);
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(object2.getClass()).toString());
            }
            if (entry instanceof DepthBuffer) {
                shader5.uniform(String.valueOf(uniform2), textureIndex);
                ((DepthBuffer)value).bind(textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (entry instanceof ColorBuffer) {
                shader5.uniform(String.valueOf(uniform2), textureIndex);
                ((ColorBuffer)value).bind(textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (entry instanceof Cubemap) {
                shader5.uniform(String.valueOf(uniform2), textureIndex);
                ((Cubemap)value).bind(textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (entry instanceof ArrayCubemap) {
                shader5.uniform(String.valueOf(uniform2), textureIndex);
                ((ArrayCubemap)value).bind(textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (!(entry instanceof BufferTexture)) continue;
            shader5.uniform(String.valueOf(uniform2), textureIndex);
            ((BufferTexture)value).bind(textureIndex);
            n2 = textureIndex;
            textureIndex = n2 + 1;
        }
        Driver driver = Driver.Companion.getInstance();
        VertexBuffer vertexBuffer = FilterKt.access$getFilterQuad$p();
        Intrinsics.checkNotNull(vertexBuffer);
        driver.drawVertexBuffer(shader5, CollectionsKt.listOf(vertexBuffer), DrawPrimitive.TRIANGLES, 0, 6);
        shader5.end();
        target2.unbind();
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        this.apply(new ColorBuffer[]{source}, new ColorBuffer[]{target2});
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer[] target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        this.apply(new ColorBuffer[]{source}, target2);
    }

    public final void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        this.apply(source, new ColorBuffer[]{target2});
    }

    public final void untrack() {
        block0: {
            Shader shader2 = this.shader;
            if (shader2 == null) break block0;
            Shader shader3 = shader2;
            boolean bl = false;
            boolean bl2 = false;
            Shader it = shader3;
            boolean bl3 = false;
            Session.Companion.getActive().untrack(this.shader);
        }
    }

    @NotNull
    protected final VertexFormat getFormat() {
        return FilterKt.access$getFilterQuadFormat$p();
    }

    public Filter(@Nullable Shader shader2, @Nullable ShaderWatcher watcher2) {
        this.shader = shader2;
        this.watcher = watcher2;
        boolean bl = false;
        this.parameters = new LinkedHashMap();
    }

    public /* synthetic */ Filter(Shader shader2, ShaderWatcher shaderWatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shader2 = null;
        }
        if ((n & 2) != 0) {
            shaderWatcher = null;
        }
        this(shader2, shaderWatcher);
    }

    public Filter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/draw/Filter$Companion;", "", "()V", "filterVertexCode", "", "getFilterVertexCode", "()Ljava/lang/String;", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final String getFilterVertexCode() {
            return Driver.Companion.getInstance().internalShaderResource("filter.vert");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

