/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.Session;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a$\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0010"}, d2={"cubemap", "Lorg/openrndr/draw/Cubemap;", "width", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "loadCubemap", "fileOrUrl", "", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "openrndr-core"})
public final class CubemapKt {
    @NotNull
    public static final Cubemap cubemap(int width, @NotNull ColorFormat format, @NotNull ColorType type2, int levels2, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Cubemap cubemap = Cubemap.Companion.create(width, format, type2, levels2, session);
        return cubemap;
    }

    public static /* synthetic */ Cubemap cubemap$default(int n, ColorFormat colorFormat, ColorType colorType, int n2, Session session, int n3, Object object) {
        if ((n3 & 2) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n3 & 4) != 0) {
            colorType = ColorType.UINT8;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x10) != 0) {
            session = Session.Companion.getActive();
        }
        return CubemapKt.cubemap(n, colorFormat, colorType, n2, session);
    }

    @NotNull
    public static final Cubemap loadCubemap(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
        Cubemap cubemap;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            if (!StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
                new URL(fileOrUrl);
            }
            cubemap = Cubemap.Companion.fromUrl(fileOrUrl, formatHint, session);
        }
        catch (MalformedURLException e) {
            cubemap = Cubemap.Companion.fromFile(new File(fileOrUrl), formatHint, session);
        }
        return cubemap;
    }

    public static /* synthetic */ Cubemap loadCubemap$default(String string, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return CubemapKt.loadCubemap(string, imageFileFormat, session);
    }
}

