/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferProxy;
import org.openrndr.draw.ColorBufferProxyKt;
import org.openrndr.events.Event;
import org.openrndr.internal.ColorBufferLoader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001:\u0003789B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J'\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\u0006\u00103\u001a\u00020*J\u0006\u00104\u001a\u00020*J\t\u00105\u001a\u00020\u0003H\u00d6\u0001J\u0006\u00106\u001a\u00020*R*\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006:"}, d2={"Lorg/openrndr/draw/ColorBufferProxy;", "", "url", "", "loader", "Lorg/openrndr/internal/ColorBufferLoader;", "persistent", "", "(Ljava/lang/String;Lorg/openrndr/internal/ColorBufferLoader;Z)V", "<set-?>", "Lorg/openrndr/draw/ColorBuffer;", "colorBuffer", "getColorBuffer", "()Lorg/openrndr/draw/ColorBuffer;", "setColorBuffer$openrndr_core", "(Lorg/openrndr/draw/ColorBuffer;)V", "events", "Lorg/openrndr/draw/ColorBufferProxy$Events;", "getEvents", "()Lorg/openrndr/draw/ColorBufferProxy$Events;", "lastTouched", "", "getLastTouched$openrndr_core", "()J", "setLastTouched$openrndr_core", "(J)V", "lastTouchedShadow", "getLastTouchedShadow$openrndr_core", "setLastTouchedShadow$openrndr_core", "getLoader", "()Lorg/openrndr/internal/ColorBufferLoader;", "getPersistent", "()Z", "Lorg/openrndr/draw/ColorBufferProxy$State;", "state", "getState", "()Lorg/openrndr/draw/ColorBufferProxy$State;", "setState$openrndr_core", "(Lorg/openrndr/draw/ColorBufferProxy$State;)V", "getUrl", "()Ljava/lang/String;", "cancel", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "queue", "retry", "toString", "touch", "Events", "ProxyEvent", "State", "openrndr-core"})
public final class ColorBufferProxy {
    @NotNull
    private final Events events;
    @Nullable
    private ColorBuffer colorBuffer;
    @NotNull
    private State state;
    private long lastTouched;
    private long lastTouchedShadow;
    @NotNull
    private final String url;
    @NotNull
    private final ColorBufferLoader loader;
    private final boolean persistent;

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Nullable
    public final ColorBuffer getColorBuffer() {
        this.lastTouched = System.currentTimeMillis();
        if (this.state == State.NOT_LOADED) {
            this.queue();
        }
        return this.colorBuffer;
    }

    public final void setColorBuffer$openrndr_core(@Nullable ColorBuffer colorBuffer) {
        this.colorBuffer = colorBuffer;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState$openrndr_core(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, "<set-?>");
        this.state = state;
    }

    public final long getLastTouched$openrndr_core() {
        return this.lastTouched;
    }

    public final void setLastTouched$openrndr_core(long l) {
        this.lastTouched = l;
    }

    public final long getLastTouchedShadow$openrndr_core() {
        return this.lastTouchedShadow;
    }

    public final void setLastTouchedShadow$openrndr_core(long l) {
        this.lastTouchedShadow = l;
    }

    public final void cancel() {
        this.touch();
        if (this.state == State.QUEUED) {
            this.loader.cancel(this);
            this.state = State.NOT_LOADED;
            ColorBufferProxyKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this){
                final /* synthetic */ ColorBufferProxy this$0;

                @Nullable
                public final Object invoke() {
                    return "canceled " + this.this$0;
                }
                {
                    this.this$0 = colorBufferProxy;
                    super(0);
                }
            });
        } else {
            ColorBufferProxyKt.access$getLogger$p().warn((Function0<? extends Object>)new Function0<Object>(this){
                final /* synthetic */ ColorBufferProxy this$0;

                @Nullable
                public final Object invoke() {
                    return "proxy is not queued, so it cannot be canceled: " + this.this$0;
                }
                {
                    this.this$0 = colorBufferProxy;
                    super(0);
                }
            });
        }
    }

    public final void queue() {
        this.touch();
        if (this.state == State.NOT_LOADED) {
            this.loader.queue(this);
            this.state = State.QUEUED;
        }
    }

    public final void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public final void retry() {
        if (this.state == State.RETRY) {
            ColorBufferProxyKt.access$getLogger$p().debug(retry.1.INSTANCE);
            this.state = State.NOT_LOADED;
        } else {
            ColorBufferProxyKt.access$getLogger$p().warn(retry.2.INSTANCE);
        }
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final ColorBufferLoader getLoader() {
        return this.loader;
    }

    public final boolean getPersistent() {
        return this.persistent;
    }

    public ColorBufferProxy(@NotNull String url, @NotNull ColorBufferLoader loader, boolean persistent) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(loader, "loader");
        this.url = url;
        this.loader = loader;
        this.persistent = persistent;
        this.events = new Events();
        this.state = State.NOT_LOADED;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final ColorBufferLoader component2() {
        return this.loader;
    }

    public final boolean component3() {
        return this.persistent;
    }

    @NotNull
    public final ColorBufferProxy copy(@NotNull String url, @NotNull ColorBufferLoader loader, boolean persistent) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(loader, "loader");
        return new ColorBufferProxy(url, loader, persistent);
    }

    public static /* synthetic */ ColorBufferProxy copy$default(ColorBufferProxy colorBufferProxy, String string, ColorBufferLoader colorBufferLoader2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = colorBufferProxy.url;
        }
        if ((n & 2) != 0) {
            colorBufferLoader2 = colorBufferProxy.loader;
        }
        if ((n & 4) != 0) {
            bl = colorBufferProxy.persistent;
        }
        return colorBufferProxy.copy(string, colorBufferLoader2, bl);
    }

    @NotNull
    public String toString() {
        return "ColorBufferProxy(url=" + this.url + ", loader=" + this.loader + ", persistent=" + this.persistent + ")";
    }

    public int hashCode() {
        String string = this.url;
        ColorBufferLoader colorBufferLoader2 = this.loader;
        int n = ((string != null ? string.hashCode() : 0) * 31 + (colorBufferLoader2 != null ? colorBufferLoader2.hashCode() : 0)) * 31;
        int n2 = this.persistent ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorBufferProxy)) break block3;
                ColorBufferProxy colorBufferProxy = (ColorBufferProxy)object;
                if (!Intrinsics.areEqual(this.url, colorBufferProxy.url) || !Intrinsics.areEqual(this.loader, colorBufferProxy.loader) || this.persistent != colorBufferProxy.persistent) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$ProxyEvent;", "", "()V", "openrndr-core"})
    public static final class ProxyEvent {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$Events;", "", "()V", "error", "Lorg/openrndr/events/Event;", "Lorg/openrndr/draw/ColorBufferProxy$ProxyEvent;", "getError", "()Lorg/openrndr/events/Event;", "loaded", "getLoaded", "retry", "getRetry", "unloaded", "getUnloaded", "openrndr-core"})
    public static final class Events {
        @NotNull
        private final Event<ProxyEvent> loaded = new Event(null, false, 3, null);
        @NotNull
        private final Event<ProxyEvent> unloaded = new Event(null, false, 3, null);
        @NotNull
        private final Event<ProxyEvent> retry = new Event(null, false, 3, null);
        @NotNull
        private final Event<ProxyEvent> error = new Event(null, false, 3, null);

        @NotNull
        public final Event<ProxyEvent> getLoaded() {
            return this.loaded;
        }

        @NotNull
        public final Event<ProxyEvent> getUnloaded() {
            return this.unloaded;
        }

        @NotNull
        public final Event<ProxyEvent> getRetry() {
            return this.retry;
        }

        @NotNull
        public final Event<ProxyEvent> getError() {
            return this.error;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$State;", "", "(Ljava/lang/String;I)V", "NOT_LOADED", "QUEUED", "LOADED", "RETRY", "ERROR", "openrndr-core"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_LOADED;
        public static final /* enum */ State QUEUED;
        public static final /* enum */ State LOADED;
        public static final /* enum */ State RETRY;
        public static final /* enum */ State ERROR;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[5];
            State[] stateArray2 = stateArray;
            stateArray[0] = NOT_LOADED = new State();
            stateArray[1] = QUEUED = new State();
            stateArray[2] = LOADED = new State();
            stateArray[3] = RETRY = new State();
            stateArray[4] = ERROR = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

