/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferTextureFileFormat;
import org.openrndr.draw.BufferTextureShadow;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 ,2\u00020\u0001:\u0001,J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H&J\b\u0010\u0019\u001a\u00020\u0017H&J!\u0010\u001a\u001a\u00020\u00032\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00170\u001c\u00a2\u0006\u0002\b\u001eH\u0016J$\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003H&J\u001a\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0016J$\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lorg/openrndr/draw/BufferTexture;", "", "elementCount", "", "getElementCount", "()I", "format", "Lorg/openrndr/draw/ColorFormat;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "shadow", "Lorg/openrndr/draw/BufferTextureShadow;", "getShadow", "()Lorg/openrndr/draw/BufferTextureShadow;", "type", "Lorg/openrndr/draw/ColorType;", "getType", "()Lorg/openrndr/draw/ColorType;", "bind", "", "unit", "destroy", "put", "putter", "Lkotlin/Function1;", "Lorg/openrndr/draw/BufferWriter;", "Lkotlin/ExtensionFunctionType;", "read", "target", "Ljava/nio/ByteBuffer;", "offset", "elementReadCount", "saveToFile", "file", "Ljava/io/File;", "fileFormat", "Lorg/openrndr/draw/BufferTextureFileFormat;", "write", "source", "elementWriteCount", "Companion", "openrndr-core"})
public interface BufferTexture {
    public static final Companion Companion = org.openrndr.draw.BufferTexture$Companion.$$INSTANCE;

    @Nullable
    public Session getSession();

    @NotNull
    public BufferTextureShadow getShadow();

    @NotNull
    public ColorFormat getFormat();

    @NotNull
    public ColorType getType();

    public int getElementCount();

    public void destroy();

    public void bind(int var1);

    public int put(@NotNull Function1<? super BufferWriter, Unit> var1);

    public void read(@NotNull ByteBuffer var1, int var2, int var3);

    public void write(@NotNull ByteBuffer var1, int var2, int var3);

    public void saveToFile(@NotNull File var1, @NotNull BufferTextureFileFormat var2);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static int put(@NotNull BufferTexture $this, @NotNull Function1<? super BufferWriter, Unit> putter) {
            Intrinsics.checkNotNullParameter(putter, "putter");
            BufferWriter w = $this.getShadow().writer();
            w.rewind();
            putter.invoke(w);
            int count2 = w.getPositionElements();
            $this.getShadow().upload(0, w.getPosition());
            w.rewind();
            return count2;
        }

        public static /* synthetic */ void read$default(BufferTexture bufferTexture, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = bufferTexture.getElementCount();
            }
            bufferTexture.read(byteBuffer, n, n2);
        }

        public static /* synthetic */ void write$default(BufferTexture bufferTexture, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = bufferTexture.getElementCount();
            }
            bufferTexture.write(byteBuffer, n, n2);
        }

        public static void saveToFile(@NotNull BufferTexture $this, @NotNull File file, @NotNull BufferTextureFileFormat fileFormat) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter((Object)fileFormat, "fileFormat");
            ByteBuffer buffer2 = ByteBuffer.allocateDirect($this.getElementCount() * $this.getFormat().getComponentCount() * $this.getType().getComponentSize());
            ByteBuffer header = ByteBuffer.allocateDirect(12);
            header.order(ByteOrder.nativeOrder());
            header.putInt(buffer2.capacity());
            header.putInt($this.getFormat().ordinal());
            header.putInt($this.getType().ordinal());
            buffer2.order(ByteOrder.nativeOrder());
            ByteBuffer byteBuffer = buffer2;
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "buffer");
            DefaultImpls.read$default($this, byteBuffer, 0, 0, 6, null);
            buffer2.rewind();
            header.rewind();
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileChannel chan = raf.getChannel();
            chan.write(header);
            chan.write(buffer2);
            chan.close();
            raf.close();
        }

        public static /* synthetic */ void saveToFile$default(BufferTexture bufferTexture, File file, BufferTextureFileFormat bufferTextureFileFormat, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveToFile");
            }
            if ((n & 2) != 0) {
                bufferTextureFileFormat = BufferTextureFileFormat.ORB;
            }
            bufferTexture.saveToFile(file, bufferTextureFileFormat);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/draw/BufferTexture$Companion;", "", "()V", "create", "Lorg/openrndr/draw/BufferTexture;", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "openrndr-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final BufferTexture create(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type2, @Nullable Session session) {
            BufferTexture bufferTexture;
            block0: {
                Intrinsics.checkNotNullParameter((Object)format, "format");
                Intrinsics.checkNotNullParameter((Object)type2, "type");
                bufferTexture = Driver.DefaultImpls.createBufferTexture$default(Driver.Companion.getInstance(), elementCount, format, type2, null, 8, null);
                Session session2 = session;
                if (session2 == null) break block0;
                session2.track(bufferTexture);
            }
            return bufferTexture;
        }

        public static /* synthetic */ BufferTexture create$default(Companion companion, int n, ColorFormat colorFormat, ColorType colorType, Session session, int n2, Object object) {
            if ((n2 & 2) != 0) {
                colorFormat = ColorFormat.RGBa;
            }
            if ((n2 & 4) != 0) {
                colorType = ColorType.FLOAT32;
            }
            if ((n2 & 8) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.create(n, colorFormat, colorType, session);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

