/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.Linearity;
import org.openrndr.color.OpacifiableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001.B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005H\u0096\u0002J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0000J\b\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006/"}, d2={"Lorg/openrndr/color/ColorXYZa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/OpacifiableColor;", "Lorg/openrndr/color/AlgebraicColor;", "x", "", "y", "z", "a", "(DDDD)V", "getA", "()D", "minValue", "getMinValue", "getX", "getY", "getZ", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "minus", "opacify", "factor", "plus", "times", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "Companion", "openrndr-color"})
public final class ColorXYZa
implements ConvertibleToColorRGBa,
OpacifiableColor<ColorXYZa>,
AlgebraicColor<ColorXYZa> {
    private final double x;
    private final double y;
    private final double z;
    private final double a;
    @NotNull
    private static final ColorXYZa SO2_A;
    @NotNull
    private static final ColorXYZa SO2_C;
    @NotNull
    private static final ColorXYZa SO2_D65;
    @NotNull
    private static final ColorXYZa SO2_F2;
    @NotNull
    private static final ColorXYZa SO2_TL4;
    @NotNull
    private static final ColorXYZa SO2_UL3000;
    @NotNull
    private static final ColorXYZa SO2_D50;
    @NotNull
    private static final ColorXYZa SO2_D60;
    @NotNull
    private static final ColorXYZa SO2_D75;
    @NotNull
    private static final ColorXYZa SO10_A;
    @NotNull
    private static final ColorXYZa SO10_C;
    @NotNull
    private static final ColorXYZa SO10_D65;
    @NotNull
    private static final ColorXYZa SO10_F2;
    @NotNull
    private static final ColorXYZa SO10_TL4;
    @NotNull
    private static final ColorXYZa SO10_UL3000;
    @NotNull
    private static final ColorXYZa SO10_D50;
    @NotNull
    private static final ColorXYZa SO10_D60;
    @NotNull
    private static final ColorXYZa SO10_D75;
    @NotNull
    private static final ColorXYZa NEUTRAL;
    public static final Companion Companion;

    public final double getMinValue() {
        double d = this.x;
        double d2 = this.y;
        boolean bl = false;
        d = Math.min(d, d2);
        d2 = this.z;
        bl = false;
        return Math.min(d, d2);
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLABa.Companion.fromXYZa(this, ref);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLUVa.Companion.fromXYZa(this, ref);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        double r = 3.2406 * this.x - 1.5372 * this.y - 0.4986 * this.z;
        double g = -0.9689 * this.x + 1.8758 * this.y + 0.0415 * this.z;
        double b = 0.0557 * this.x - 0.204 * this.y + 1.057 * this.z;
        return new ColorRGBa(r, g, b, this.a, Linearity.LINEAR);
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toRGBa().toHSVa();
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return this.toRGBa().toHSLa();
    }

    @Override
    @NotNull
    public ColorXYZa plus(@NotNull ColorXYZa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.x + other.x, this.y + other.y, this.z + other.z, this.a + other.a);
    }

    @Override
    @NotNull
    public ColorXYZa minus(@NotNull ColorXYZa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.x - other.x, this.y - other.y, this.z - other.z, this.a - other.a);
    }

    @Override
    @NotNull
    public ColorXYZa times(double factor) {
        return this.copy(this.x * factor, this.y * factor, this.z * factor, this.a * factor);
    }

    @Override
    @NotNull
    public ColorXYZa opacify(double factor) {
        return ColorXYZa.copy$default(this, 0.0, 0.0, 0.0, this.a * factor, 7, null);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getA() {
        return this.a;
    }

    public ColorXYZa(double x, double y, double z, double a2) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.a = a2;
    }

    public /* synthetic */ ColorXYZa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    static {
        Companion = new Companion(null);
        SO2_A = new ColorXYZa(109.83, 100.0, 35.55, 0.0, 8, null);
        SO2_C = new ColorXYZa(98.04, 100.0, 118.11, 0.0, 8, null);
        SO2_D65 = new ColorXYZa(95.02, 100.0, 108.82, 0.0, 8, null);
        SO2_F2 = new ColorXYZa(98.09, 100.0, 67.53, 0.0, 8, null);
        SO2_TL4 = new ColorXYZa(101.4, 100.0, 65.9, 0.0, 8, null);
        SO2_UL3000 = new ColorXYZa(107.99, 100.0, 33.91, 0.0, 8, null);
        SO2_D50 = new ColorXYZa(107.99, 100.0, 82.45, 0.0, 8, null);
        SO2_D60 = new ColorXYZa(107.99, 100.0, 100.86, 0.0, 8, null);
        SO2_D75 = new ColorXYZa(107.99, 100.0, 122.53, 0.0, 8, null);
        SO10_A = new ColorXYZa(111.16, 100.0, 35.19, 0.0, 8, null);
        SO10_C = new ColorXYZa(97.3, 100.0, 116.14, 0.0, 8, null);
        SO10_D65 = new ColorXYZa(94.83, 100.0, 107.38, 0.0, 8, null);
        SO10_F2 = new ColorXYZa(102.12, 100.0, 69.37, 0.0, 8, null);
        SO10_TL4 = new ColorXYZa(103.82, 100.0, 66.9, 0.0, 8, null);
        SO10_UL3000 = new ColorXYZa(111.12, 100.0, 35.21, 0.0, 8, null);
        SO10_D50 = new ColorXYZa(96.72, 100.0, 81.45, 0.0, 8, null);
        SO10_D60 = new ColorXYZa(95.21, 100.0, 99.6, 0.0, 8, null);
        SO10_D75 = new ColorXYZa(94.45, 100.0, 120.7, 0.0, 8, null);
        NEUTRAL = Companion.fromRGBa(new ColorRGBa(1.0, 1.0, 1.0, 0.0, null, 24, null));
    }

    @Override
    @NotNull
    public ColorXYZa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    @Override
    @NotNull
    public ColorXYZa mix(@NotNull ColorXYZa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return (ColorXYZa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorXYZa copy(double x, double y, double z, double a2) {
        return new ColorXYZa(x, y, z, a2);
    }

    public static /* synthetic */ ColorXYZa copy$default(ColorXYZa colorXYZa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorXYZa.x;
        }
        if ((n & 2) != 0) {
            d2 = colorXYZa.y;
        }
        if ((n & 4) != 0) {
            d3 = colorXYZa.z;
        }
        if ((n & 8) != 0) {
            d4 = colorXYZa.a;
        }
        return colorXYZa.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorXYZa(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", a=" + this.a + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = Double.doubleToLongBits(this.a);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorXYZa)) break block3;
                ColorXYZa colorXYZa = (ColorXYZa)object;
                if (Double.compare(this.x, colorXYZa.x) != 0 || Double.compare(this.y, colorXYZa.y) != 0 || Double.compare(this.z, colorXYZa.z) != 0 || Double.compare(this.a, colorXYZa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006\u00a8\u0006."}, d2={"Lorg/openrndr/color/ColorXYZa$Companion;", "", "()V", "NEUTRAL", "Lorg/openrndr/color/ColorXYZa;", "getNEUTRAL", "()Lorg/openrndr/color/ColorXYZa;", "SO10_A", "getSO10_A", "SO10_C", "getSO10_C", "SO10_D50", "getSO10_D50", "SO10_D60", "getSO10_D60", "SO10_D65", "getSO10_D65", "SO10_D75", "getSO10_D75", "SO10_F2", "getSO10_F2", "SO10_TL4", "getSO10_TL4", "SO10_UL3000", "getSO10_UL3000", "SO2_A", "getSO2_A", "SO2_C", "getSO2_C", "SO2_D50", "getSO2_D50", "SO2_D60", "getSO2_D60", "SO2_D65", "getSO2_D65", "SO2_D75", "getSO2_D75", "SO2_F2", "getSO2_F2", "SO2_TL4", "getSO2_TL4", "SO2_UL3000", "getSO2_UL3000", "fromRGBa", "rgba", "Lorg/openrndr/color/ColorRGBa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorXYZa getSO2_A() {
            return SO2_A;
        }

        @NotNull
        public final ColorXYZa getSO2_C() {
            return SO2_C;
        }

        @NotNull
        public final ColorXYZa getSO2_D65() {
            return SO2_D65;
        }

        @NotNull
        public final ColorXYZa getSO2_F2() {
            return SO2_F2;
        }

        @NotNull
        public final ColorXYZa getSO2_TL4() {
            return SO2_TL4;
        }

        @NotNull
        public final ColorXYZa getSO2_UL3000() {
            return SO2_UL3000;
        }

        @NotNull
        public final ColorXYZa getSO2_D50() {
            return SO2_D50;
        }

        @NotNull
        public final ColorXYZa getSO2_D60() {
            return SO2_D60;
        }

        @NotNull
        public final ColorXYZa getSO2_D75() {
            return SO2_D75;
        }

        @NotNull
        public final ColorXYZa getSO10_A() {
            return SO10_A;
        }

        @NotNull
        public final ColorXYZa getSO10_C() {
            return SO10_C;
        }

        @NotNull
        public final ColorXYZa getSO10_D65() {
            return SO10_D65;
        }

        @NotNull
        public final ColorXYZa getSO10_F2() {
            return SO10_F2;
        }

        @NotNull
        public final ColorXYZa getSO10_TL4() {
            return SO10_TL4;
        }

        @NotNull
        public final ColorXYZa getSO10_UL3000() {
            return SO10_UL3000;
        }

        @NotNull
        public final ColorXYZa getSO10_D50() {
            return SO10_D50;
        }

        @NotNull
        public final ColorXYZa getSO10_D60() {
            return SO10_D60;
        }

        @NotNull
        public final ColorXYZa getSO10_D75() {
            return SO10_D75;
        }

        @NotNull
        public final ColorXYZa getNEUTRAL() {
            return NEUTRAL;
        }

        @NotNull
        public final ColorXYZa fromRGBa(@NotNull ColorRGBa rgba) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            double x = 0.4124 * rgba.getR() + 0.3576 * rgba.getG() + 0.1805 * rgba.getB();
            double y = 0.2126 * rgba.getR() + 0.7152 * rgba.getG() + 0.0722 * rgba.getB();
            double z = 0.0193 * rgba.getR() + 0.1192 * rgba.getG() + 0.9505 * rgba.getB();
            return new ColorXYZa(x, y, z, rgba.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

