/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABaKt;
import org.openrndr.color.ColorLSHABa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.OpacifiableColor;
import org.openrndr.color.ShadableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 32\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u00013B1\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0096\u0002J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001J\u0006\u00102\u001a\u00020\fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lorg/openrndr/color/ColorLCHABa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/OpacifiableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "c", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "getAlpha", "()D", "getC", "getH", "getL", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "minus", "mix", "factor", "opacify", "plus", "shade", "shiftHue", "shiftInDegrees", "times", "toLABa", "Lorg/openrndr/color/ColorLABa;", "toLSHABa", "Lorg/openrndr/color/ColorLSHABa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXYZa", "Companion", "openrndr-color"})
public final class ColorLCHABa
implements ConvertibleToColorRGBa,
ShadableColor<ColorLCHABa>,
OpacifiableColor<ColorLCHABa>,
HueShiftableColor<ColorLCHABa>,
AlgebraicColor<ColorLCHABa> {
    private final double l;
    private final double c;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorLABa toLABa() {
        double d = Math.toRadians(this.h);
        boolean bl = false;
        double a2 = this.c * Math.cos(d);
        double d2 = Math.toRadians(this.h);
        boolean bl2 = false;
        double b = this.c * Math.sin(d2);
        return new ColorLABa(this.l, a2, b, this.alpha, this.ref);
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toLABa().toXYZa();
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toLABa().toXYZa().toRGBa();
    }

    @NotNull
    public final ColorLSHABa toLSHABa() {
        return ColorLSHABa.Companion.fromLCHABa(this);
    }

    @Override
    @NotNull
    public ColorLCHABa opacify(double factor) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, 0.0, this.alpha * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLCHABa shade(double factor) {
        return ColorLCHABa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLCHABa shiftHue(double shiftInDegrees) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, this.h + shiftInDegrees, 0.0, null, 27, null);
    }

    @Override
    @NotNull
    public ColorLCHABa plus(@NotNull ColorLCHABa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHABa.copy$default(this, this.l + other.l, this.c + other.c, this.h + other.h, this.alpha + other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa minus(@NotNull ColorLCHABa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHABa.copy$default(this, this.l - other.l, this.c - other.c, this.h - other.h, this.alpha - other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa times(double factor) {
        return ColorLCHABa.copy$default(this, this.l * factor, this.c * factor, this.h * factor, this.alpha * factor, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHABa mix(@NotNull ColorLCHABa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHABaKt.mix(this, other, factor);
    }

    public final double getL() {
        return this.l;
    }

    public final double getC() {
        return this.c;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa getRef() {
        return this.ref;
    }

    public ColorLCHABa(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLCHABa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    @Override
    @NotNull
    public ColorLCHABa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.c;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLCHABa copy(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLCHABa(l, c, h, alpha, ref);
    }

    public static /* synthetic */ ColorLCHABa copy$default(ColorLCHABa colorLCHABa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLCHABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLCHABa.c;
        }
        if ((n & 4) != 0) {
            d3 = colorLCHABa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorLCHABa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLCHABa.ref;
        }
        return colorLCHABa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLCHABa(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.l);
        long l2 = Double.doubleToLongBits(this.c);
        long l3 = Double.doubleToLongBits(this.h);
        long l4 = Double.doubleToLongBits(this.alpha);
        ColorXYZa colorXYZa = this.ref;
        return ((((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (colorXYZa != null ? ((Object)colorXYZa).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorLCHABa)) break block3;
                ColorLCHABa colorLCHABa = (ColorLCHABa)object;
                if (Double.compare(this.l, colorLCHABa.l) != 0 || Double.compare(this.c, colorLCHABa.c) != 0 || Double.compare(this.h, colorLCHABa.h) != 0 || Double.compare(this.alpha, colorLCHABa.alpha) != 0 || !Intrinsics.areEqual(this.ref, colorLCHABa.ref)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/color/ColorLCHABa$Companion;", "", "()V", "findMaxChroma", "", "l", "h", "ref", "Lorg/openrndr/color/ColorXYZa;", "fromLABa", "Lorg/openrndr/color/ColorLCHABa;", "laba", "Lorg/openrndr/color/ColorLABa;", "openrndr-color"})
    public static final class Companion {
        public final double findMaxChroma(double l, double h, @NotNull ColorXYZa ref) {
            boolean rightValid;
            boolean middleValid;
            boolean leftValid;
            Intrinsics.checkNotNullParameter(ref, "ref");
            double left = 0.0;
            double right = 2000.0;
            double bestGuess = left;
            do {
                if (right - left < 1.0E-4) {
                    return bestGuess;
                }
                ColorLCHABa leftTry = new ColorLCHABa(l, left, h, 1.0, ref);
                ColorLCHABa rightTry = new ColorLCHABa(l, right, h, 1.0, ref);
                double middle = (left + right) / (double)2;
                ColorLCHABa middleTry = new ColorLCHABa(l, middle, h, 1.0, ref);
                ColorRGBa colorRGBa = leftTry.toRGBa();
                boolean bl = false;
                boolean bl2 = false;
                ColorRGBa it = colorRGBa;
                boolean bl3 = false;
                leftValid = it.getMinValue() >= 0.0 && it.getMaxValue() <= 1.0;
                ColorRGBa colorRGBa2 = rightTry.toRGBa();
                bl2 = false;
                boolean bl4 = false;
                ColorRGBa it22 = colorRGBa2;
                boolean bl5 = false;
                rightValid = it22.getMinValue() >= 0.0 && it22.getMaxValue() <= 1.0;
                ColorRGBa colorRGBa3 = middleTry.toRGBa();
                bl4 = false;
                boolean it22 = false;
                ColorRGBa it3 = colorRGBa3;
                boolean bl6 = false;
                boolean bl7 = middleValid = it3.getMinValue() >= 0.0 && it3.getMaxValue() <= 1.0;
                if (leftValid && middleValid && !rightValid) {
                    double newLeft = middle;
                    double newRight = right;
                    bestGuess = middle;
                    left = newLeft;
                    right = newRight;
                }
                if (!leftValid || middleValid || rightValid) continue;
                double newLeft = left;
                double newRight = middle;
                left = newLeft;
                right = newRight;
            } while (leftValid != middleValid || middleValid != rightValid);
            return bestGuess;
        }

        @NotNull
        public final ColorLCHABa fromLABa(@NotNull ColorLABa laba) {
            Intrinsics.checkNotNullParameter(laba, "laba");
            double l = laba.getL();
            double d = laba.getA() * laba.getA() + laba.getB() * laba.getB();
            boolean bl = false;
            double c = Math.sqrt(d);
            double d2 = laba.getB();
            double d3 = laba.getA();
            boolean bl2 = false;
            double h = Math.atan2(d2, d3);
            if (h < 0.0) {
                h += Math.PI * 2;
            }
            h = Math.toDegrees(h);
            return new ColorLCHABa(l, c, h, laba.getAlpha(), laba.getRef());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

