/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.egl.EXTDeviceEnumeration;
import org.lwjgl.egl.EXTDeviceQuery;
import org.lwjgl.system.Checks;
import org.lwjgl.system.NativeType;

public class EXTDeviceBase {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;

    protected EXTDeviceBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryDeviceAttribEXT, caps.eglQueryDeviceStringEXT, caps.eglQueryDisplayAttribEXT, caps.eglQueryDevicesEXT);
    }

    public static int neglQueryDeviceAttribEXT(long device, int attribute, long value) {
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(device, attribute, value);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDeviceAttribEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        return EXTDeviceQuery.eglQueryDeviceAttribEXT(device, attribute, value);
    }

    public static long neglQueryDeviceStringEXT(long device, int name) {
        return EXTDeviceQuery.neglQueryDeviceStringEXT(device, name);
    }

    @Nullable
    @NativeType(value="char *")
    public static String eglQueryDeviceStringEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int name) {
        return EXTDeviceQuery.eglQueryDeviceStringEXT(device, name);
    }

    public static int neglQueryDisplayAttribEXT(long dpy, int attribute, long value) {
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(dpy, attribute, value);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDisplayAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        return EXTDeviceQuery.eglQueryDisplayAttribEXT(dpy, attribute, value);
    }

    public static int neglQueryDevicesEXT(int max_devices, long devices, long num_devices) {
        return EXTDeviceEnumeration.neglQueryDevicesEXT(max_devices, devices, num_devices);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDevicesEXT(@Nullable @NativeType(value="EGLDeviceEXT *") PointerBuffer devices, @NativeType(value="EGLint *") IntBuffer num_devices) {
        return EXTDeviceEnumeration.eglQueryDevicesEXT(devices, num_devices);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDevicesEXT(@Nullable @NativeType(value="EGLDeviceEXT *") PointerBuffer devices, @NativeType(value="EGLint *") int[] num_devices) {
        return EXTDeviceEnumeration.eglQueryDevicesEXT(devices, num_devices);
    }
}

