/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import jouvieje.bass.utils.MiscJNI;
import jouvieje.bass.utils.Pointer;
import jouvieje.bass.utils.SizeOfPrimitive;

public class BufferUtils
implements SizeOfPrimitive {
    public static ByteBuffer newByteBuffer(int nbElements) {
        ByteBuffer buffer2 = ByteBuffer.allocateDirect(nbElements);
        buffer2.order(ByteOrder.nativeOrder());
        return buffer2;
    }

    public static CharBuffer newCharBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 2);
        return buffer2.asCharBuffer();
    }

    public static ShortBuffer newShortBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 2);
        return buffer2.asShortBuffer();
    }

    public static IntBuffer newIntBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 4);
        return buffer2.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 8);
        return buffer2.asLongBuffer();
    }

    public static FloatBuffer newFloatBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 4);
        return buffer2.asFloatBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(int nbElements) {
        ByteBuffer buffer2 = BufferUtils.newByteBuffer(nbElements * 8);
        return buffer2.asDoubleBuffer();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer src) {
        ByteBuffer dest = BufferUtils.newByteBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer src) {
        ShortBuffer dest = BufferUtils.newShortBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static IntBuffer copyIntBuffer(IntBuffer src) {
        IntBuffer dest = BufferUtils.newIntBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static LongBuffer copyLongBuffer(LongBuffer src) {
        LongBuffer dest = BufferUtils.newLongBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer src) {
        FloatBuffer dest = BufferUtils.newFloatBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer src) {
        DoubleBuffer dest = BufferUtils.newDoubleBuffer(src.capacity());
        src.rewind();
        dest.put(src);
        return dest;
    }

    public static int getCapacityInBytes(Buffer buffer2) {
        if (buffer2 instanceof ByteBuffer) {
            return buffer2.capacity();
        }
        if (buffer2 instanceof CharBuffer) {
            return buffer2.capacity() * 2;
        }
        if (buffer2 instanceof ShortBuffer) {
            return buffer2.capacity() * 2;
        }
        if (buffer2 instanceof IntBuffer) {
            return buffer2.capacity() * 4;
        }
        if (buffer2 instanceof LongBuffer) {
            return buffer2.capacity() * 8;
        }
        if (buffer2 instanceof FloatBuffer) {
            return buffer2.capacity() * 4;
        }
        if (buffer2 instanceof DoubleBuffer) {
            return buffer2.capacity() * 8;
        }
        return -1;
    }

    public static int getPositionInBytes(Buffer buffer2) {
        if (buffer2 != null) {
            if (buffer2 instanceof ByteBuffer) {
                return buffer2.position();
            }
            if (buffer2 instanceof CharBuffer) {
                return buffer2.position() * 2;
            }
            if (buffer2 instanceof ShortBuffer) {
                return buffer2.position() * 2;
            }
            if (buffer2 instanceof IntBuffer) {
                return buffer2.position() * 4;
            }
            if (buffer2 instanceof LongBuffer) {
                return buffer2.position() * 8;
            }
            if (buffer2 instanceof FloatBuffer) {
                return buffer2.position() * 4;
            }
            if (buffer2 instanceof DoubleBuffer) {
                return buffer2.position() * 8;
            }
        }
        return -1;
    }

    public static String toString(ByteBuffer buffer2) {
        long address = MiscJNI.getBufferAddress(buffer2, BufferUtils.getPositionInBytes(buffer2));
        return address == 0L ? null : MiscJNI.Pointer_toString(address);
    }

    public static String toString(ByteBuffer buffer2, int offset2, int length2) {
        byte[] bytes = new byte[length2];
        int position = buffer2.position();
        buffer2.position(position + offset2);
        buffer2.get(bytes, 0, length2);
        buffer2.rewind();
        buffer2.position(position);
        return new String(bytes);
    }

    public static String toString(CharBuffer charBuffer) {
        char[] cs = new char[charBuffer.capacity()];
        charBuffer.get(cs).rewind();
        int i = 0;
        while (i < cs.length) {
            if (i == 0) break;
            ++i;
        }
        return new String(cs, 0, i);
    }

    public static ByteBuffer fromString(String s2) {
        return BufferUtils.fromByteArray(s2.getBytes(), 1);
    }

    public static ByteBuffer fromStringUTF16(String s2) {
        byte[] bytes = null;
        try {
            bytes = s2.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return BufferUtils.fromByteArray(bytes, 2);
    }

    private static ByteBuffer fromByteArray(byte[] bytes, int numTerminal) {
        ByteBuffer buff = BufferUtils.newByteBuffer(bytes.length + numTerminal);
        buff.put(bytes);
        int i = 0;
        while (i < numTerminal) {
            BufferUtils.putNullTerminal(buff);
            ++i;
        }
        buff.rewind();
        return buff;
    }

    public static void putString(ByteBuffer buffer2, String s2) {
        buffer2.put(s2.getBytes());
    }

    public static void putString(ByteBuffer buffer2, String s2, String charset) {
        try {
            buffer2.put(s2.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void putNullTerminal(ByteBuffer buffer2) {
        buffer2.put((byte)0);
    }

    public static Pointer asPointer(Buffer buffer2) {
        long address = MiscJNI.getBufferAddress(buffer2, BufferUtils.getPositionInBytes(buffer2));
        return address == 0L ? null : new Pointer(address);
    }
}

