/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import io.lacuna.bifurcan.LinearMap;
import java.util.function.Function;

public class Functions {
    public static <U, V> Function<U, V> memoize(Function<U, V> f) {
        if (f instanceof MemoizedFunction) {
            return f;
        }
        return new MemoizedFunction<U, V>(f);
    }

    private static class MemoizedFunction<U, V>
    implements Function<U, V> {
        private final LinearMap<U, V> cache = new LinearMap();
        private final Function<U, V> f;

        MemoizedFunction(Function<U, V> f) {
            this.f = f;
        }

        @Override
        public V apply(U u) {
            return (V)this.cache.getOrCreate(u, () -> this.f.apply(u));
        }
    }
}

