/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Lists;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;

public class Combinatorics {
    public static final int MAX_RESULTS = 32;

    public static <V> void swap(V[] ary, int i, int j) {
        V tmp = ary[i];
        ary[i] = ary[j];
        ary[j] = tmp;
    }

    public static <V> V randNth(IList<V> list) {
        return list.nth(ThreadLocalRandom.current().nextInt((int)list.size()));
    }

    public static <V> IList<V> shuffle(IList<V> values2) {
        Object[] ary = values2.toArray();
        ThreadLocalRandom gen = ThreadLocalRandom.current();
        for (int i = ary.length - 1; i > 0; --i) {
            Combinatorics.swap(ary, gen.nextInt(i + 1), i);
        }
        return Lists.from(ary);
    }

    public static <V> IList<IList<V>> permutations(IList<V> values2) {
        if (values2.size() > 4L) {
            return IntStream.range(0, 32).mapToObj(i -> Combinatorics.shuffle(values2)).collect(Lists.linearCollector());
        }
        LinearList<IList<IList<Object>>> result2 = new LinearList<IList<IList<Object>>>();
        Object[] ary = values2.toArray();
        int[] c = new int[ary.length];
        int i2 = 0;
        result2.addLast(Lists.from((Object[])ary.clone()));
        while (i2 < ary.length) {
            if (c[i2] < i2) {
                Combinatorics.swap(ary, i2 % 2 == 0 ? 0 : c[i2], i2);
                result2.addLast(Lists.from((Object[])ary.clone()));
                int n = i2;
                c[n] = c[n] + 1;
                i2 = 0;
                continue;
            }
            c[i2] = 0;
            ++i2;
        }
        return result2;
    }

    public static <V> IList<IList<V>> combinations(IList<IList<V>> paths) {
        long count2 = paths.stream().mapToLong(IList::size).reduce(1L, (a2, b) -> a2 * b);
        if (count2 == 0L) {
            return Lists.EMPTY;
        }
        if (count2 == 1L) {
            return LinearList.of(paths.stream().map(IList::first).collect(Lists.linearCollector()));
        }
        if (count2 > 32L) {
            return IntStream.range(0, 32).mapToObj(i -> paths.stream().map(Combinatorics::randNth).collect(Lists.linearCollector())).collect(Lists.linearCollector());
        }
        int[] indices = new int[(int)paths.size()];
        LinearList result2 = new LinearList();
        block0: while ((long)indices[0] < paths.first().size()) {
            int i2;
            LinearList<V> path = new LinearList<V>(indices.length);
            for (i2 = 0; i2 < indices.length; ++i2) {
                path.addLast(paths.nth(i2).nth(indices[i2]));
            }
            result2.addLast(path);
            for (i2 = indices.length - 1; i2 >= 0; --i2) {
                int n = i2;
                indices[n] = indices[n] + 1;
                if ((long)indices[n] < paths.nth(i2).size()) continue block0;
                if (i2 <= 0) continue;
                indices[i2] = 0;
            }
        }
        return result2;
    }
}

