class logobounce {
  constructor(bottom, imgwidth, imgheight, x, y, vx, vy, leftx, rightx, image) {

    this.Friction = 0.09;
    this.width = imgwidth
    this.height = imgheight
    this.x = x 
    this.y = y 
    this.vx = vx
    this.vy = vy
    this.bottom = bottom
    this.leftx = leftx
    this.rightx = rightx
    this.ttl = 0
    this.image = image
  }



  move() {


    this.ttl++
    this.x += map(this.vx, 0, 1, 0, width / 1200)
    this.y += map(this.vy, 0, 1, 0, height / 1200)
    this.vy += this.gravity
    if (this.x < this.leftx || this.x > this.rightx && this.ttl > 20) {

      this.vx *= -1
      this.ttl = 0 // Resets bounce Time To Live to avoid stucking in edges
    }

    if (this.y + this.height / 2 > this.bottom) {
      this.y = this.bottom - this.height / 2
      this.vy *= -this.bounce


    }

    if (this.vy < 0 && this.vy > -2.1) {
      this.vy = 0

    }


    if (this.vx > 0) {
      this.vx = this.vx - this.Friction;
    }
    if (this.vx < 0) {
      this.vx = this.vx + this.Friction;
    }


  }


  display() {

    image(this.image, this.x, this.y)
  }
}


// Bouncing algorithm based on https://www.youtube.com/watch?v=F9LUPoH400M
// Collision detection based on https://www.youtube.com/watch?v=GY-c2HO2liA&t
// and https://www.youtube.com/watch?v=789weryntzM&
// FFT based on https://www.youtube.com/watch?v=2O3nm0Nvbi4

/**
 * Rotates coordinate system for velocities
 *
 * Takes velocities and alters them as if the coordinate system they're on was rotated
 *
 * @param  Object | velocity | The velocity of an individual particle
 * @param  Float  | angle    | The angle of collision between two objects in radians
 * @return Object | The altered x and y velocities after the coordinate system has been rotated
 */

function rotat(velocity, angle) {
  const rotatedVelocities = {
    x: velocity.x * Math.cos(angle) - velocity.y * Math.sin(angle),
    y: velocity.x * Math.sin(angle) + velocity.y * Math.cos(angle)
  };

  return rotatedVelocities;
}

/**
 * Swaps out two colliding particles' x and y velocities after running through
 * an elastic collision reaction equation
 *
 * @param  Object | particle      | A particle object with x and y coordinates, plus velocity
 * @param  Object | otherParticle | A particle object with x and y coordinates, plus velocity
 * @return Null | Does not return a value
 *
 * https://gist.github.com/christopher4lis/f9ccb589ee8ecf751481f05a8e59b1dc
 */

function resolveCollision(particle, otherParticle) {
  const xVelocityDiff = particle.velocity.x - otherParticle.velocity.x;
  const yVelocityDiff = particle.velocity.y - otherParticle.velocity.y;

  const xDist = otherParticle.x - particle.x;
  const yDist = otherParticle.y - particle.y;

  // Prevent accidental overlap of particles
  if (xVelocityDiff * xDist + yVelocityDiff * yDist >= 0) {

    // Grab angle between the two colliding particles
    const angle = -Math.atan2(otherParticle.y - particle.y, otherParticle.x - particle.x);

    // Store mass in var for better readability in collision equation
    const m1 = particle.mass;
    const m2 = otherParticle.mass;

    // Velocity before equation
    const u1 = rotat(particle.velocity, angle);
    const u2 = rotat(otherParticle.velocity, angle);

    // Velocity after 1d collision equation
    const v1 = {
      x: u1.x * (m1 - m2) / (m1 + m2) + u2.x * 2 * m2 / (m1 + m2),
      y: u1.y
    };
    const v2 = {
      x: u2.x * (m1 - m2) / (m1 + m2) + u1.x * 2 * m2 / (m1 + m2),
      y: u2.y
    };

    // Final velocity after rotating axis back to original location
    const vFinal1 = rotat(v1, -angle);
    const vFinal2 = rotat(v2, -angle);

    // Swap particle velocities for realistic bounce effect
    particle.velocity.x = vFinal1.x;
    particle.velocity.y = vFinal1.y;

    otherParticle.velocity.x = vFinal2.x;
    otherParticle.velocity.y = vFinal2.y;
  }
}

function ball(x, y, radius, mass, gravity, bounce, bottom, vx, objectx, objecty, objectw, objecth) {



  this.mass = mass;
  this.gravity = gravity 
  this.bounce = bounce 
  this.Friction = 0.09;
  this.radius = radius
  this.x = x
  this.y = y
  this.bottom = bottom
  this.ttl = 0
  this.velocity = {
    x: vx,
    y: 0
  };
  this.roof = objecty

  this.intersects = function(other) {
    let d = dist(this.x, this.y, other.x, other.y)
    if (d - this.radius * 2 < 0) {
      return true;
    } else {
      return false;
    }
  }


  this.move = function() {
    this.x += this.velocity.x
    this.y += this.velocity.y
    this.velocity.y += this.gravity
    this.ttl++
    if (this.x < 0 + (this.radius) && this.ttl > 20) {
      this.x = 0 + this.radius
      this.velocity.x *= -this.bounce * this.mass
      this.ttl = 0

    } else if (this.x > width - (this.radius) && this.ttl > 20) {
      this.x = width - this.radius
      this.velocity.x *= -this.bounce
      this.ttl = 0
    }


    if (this.y + this.radius > this.bottom) {
      this.y = this.bottom - this.radius
      this.velocity.y *= -this.bounce
      this.hit = true
    }

    if (this.y + this.radius < this.roof) {
      this.y = this.roof - this.radius
      this.velocity.y *= -this.bounce * this.mass
      this.hit = true
    } // Roof




    if (this.velocity.y < 0 && this.velocity.y > -2.1) {
      this.velocity.y = 0

    }


    if (this.velocity.x > 0)
      this.velocity.x = this.velocity.x - this.Friction;
    if (this.velocity.x < 0)
      this.velocity.x = this.velocity.x + this.Friction;


  }

  this.display = function() {
   fill(map(this.y, 0, height, 0, 128), 255, map(this.x, 0, width, 32, 255))
    noStroke()
    if (this.hit === true) {
      strokeWeight(width / 400)
      stroke(128, 0, 255, 0.2)
      fill(map(this.y, 0, height, 0, 128), 0, map(this.x, 0, width, 32, 255))
    }
    circle(this.x, this.y, this.radius * 2)
    this.hit = false
  }
}


