#include "common_fs.glsl"


uniform vec4 factores ;


// ------------------------------------------------------------------------------------------------
//
//
void main()
{
  highp vec4 valor_textura = texture2D(shader_texture_ids[0], text_coord[0]) ;

  if(valor_textura.a < 0.1) discard ;
  gl_FragColor = valor_textura ;


    float resx = 1920.0 ;
    float resy = 1080.0 ;

    float normx = (gl_FragCoord.x - 0.5) / resx ;
    float normy = (gl_FragCoord.y - 0.5) / resy ;

                         
    float rOffset = 0.01 * factores.r * sin(normx * 60.28) * 1.5 ;
    float gOffset = 0.00 * factores.g * cos(normx * 16.28) ;
    float bOffset = 0.01 * factores.b * normy * cos(normx * 16.28) ;

    vec4 rValue = texture2D(shader_texture_ids[0], text_coord[0] - rOffset);  
    vec4 gValue = texture2D(shader_texture_ids[0], text_coord[0] - gOffset);
    vec4 bValue = texture2D(shader_texture_ids[0], text_coord[0] - bOffset);  

    // Combine the offset colors.
    gl_FragColor = vec4(rValue.r, gValue.g, bValue.b, valor_textura.a);
}
