/**************************************************************************************************

                                        Datos comunes entre vertex y fragment

**************************************************************************************************/


//#define highp
//#define lowp



// ------------------------------------------------------------------------------------------------
//                                      Estructuras de datos
// ------------------------------------------------------------------------------------------------

struct MATERIAL
{
  //// Indica si el material tiene parmetros de luz ambiente.
  //highp int bAmbient ;

  //// Valores RGB de la luz ambiente.
  //highp vec3 ambient ;

  //// Indica si el material tiene parmetros de luz difusa.
  //highp int bDiffuse ;

  //// Valores RGB de la luz difusa.
  //highp vec3 diffuse ;

  //// Indica si el material tiene parmetros de luz especular.
  //highp int bSpecular ;

  // Valores RGB de la luz especular.
  lowp vec3 specular ;

  //// Indica si el material tiene parmetros de shininess.
  //highp int bShininess ;

  //// Valor de shininess.
  //highp int shininess ;

  //// Indica si el material tiene parmetros de luz de emisin.
  //highp int bEmission ;

  // Valores RGB de la luz de emisin.
  lowp vec3 emission ;

  // Indica si el material tiene parmetros de reflexin.
  //bool bReflective ;

  // Valores RGB de la luz de reflexin.
  //highp vec3 reflective ;

  // Transparencia
  lowp float transparency ;

  // numero de texturas activas
  lowp int numTextures ;

  // indica si se usa o no la iluminacion
  lowp int useLights ;

  vec2 offset_animacion0 ;
  vec2 offset_animacion1 ;
} ;


struct LIGHT
{
  // --------------------------------------------------------------------------------------------------------------------------
  // The diffuse lighting in OpenGL assumes that the light is perceived with the same intensity regardless 
  // if the viewers position. Its intensity is proportional to both the lights diffuse intensity as well as 
  // materials diffuse reflection coefficient. The intensity is also proportional to the angle between the 
  // light direction and the normal of the surface
  //
  // Frmula de la ley del coseno de Lambert: 
  //
  // Intensidad.RGB = Luz.diffuse.RGB * Material.diffuse.RGB * cos(angulo de la superficie con la direccin de la luz)

  // RGB = color de la luz
  lowp vec3 diffuse ;
  highp float attenuation_start ;

  highp vec3 position ;
  highp float attenuation_end ;

  lowp vec3 direction ;
  highp float hotspot_beam ;

  highp float falloff ;

  // tipo de luz (punto, direccional...)
  lowp int type ;
} ;


struct LightModelParameters
{
  lowp vec3 ambient ;
} ;



// ------------------------------------------------------------------------------------------------
//                                          Uniforms
// ------------------------------------------------------------------------------------------------

uniform highp mat4 NormalMatrix ;                       // Segn la especificacin esto era la "transpose of the inverse of the upper leftmost 3x3 of WorldMatrix"
uniform highp mat4 ModelViewProjectionMatrix ;
//uniform highp mat4 InverseModelViewProjectionMatrix ;
uniform highp mat4 WorldMatrix ;
uniform highp mat4 ProjectionMatrix ;
uniform highp vec3 posicion_camara_world ;

// luces activas
uniform LIGHT g_Lights[MAX_LIGHTS] ;

// iluminacion global
uniform LightModelParameters g_LightModel ;

// material actual
uniform MATERIAL g_DatosMaterial ;

// indices de texturas
uniform highp sampler2D shader_texture_ids[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL] ;        // Se puede cambiar tranquilamente por un lowp



// ------------------------------------------------------------------------------------------------
//                                          Variables
// ------------------------------------------------------------------------------------------------

// Variables de iluminacin


// ------------------------------------------------------------------------------------------------
//
//                      Varying's (con cuidado hay poca memoria para esto)
//
// Nota:
//   Se optimizan los que no se usan en la pareja linkada de vertex+fragment
//   no se optimizan arrays ni datos internos de structura
// ------------------------------------------------------------------------------------------------

#ifdef DEBUGUEAR_SHADERS
  varying lowp vec4 debug_color ;    // .a = bHayError
  varying lowp vec4 color_influencias ;
#endif

varying lowp vec4  color_final_BLUR ;

// coordenadas de textura
varying /*lowp*/ vec2 text_coord[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL] ;

// Variables de iluminacin
varying lowp vec3 light_final_intensity ;
varying lowp vec3 light_final_specular ;
