MMC3_CTRL	=$8000
MMC3_DATA	=$8001
MMC3_MIRROR	=$a000
MMC3_PRGRAM	=$a001

MMC3_IRQ_LATCH	=$c000
MMC3_IRQ_RELOAD	=$c001
MMC3_IRQ_DISABLE=$e000
MMC3_IRQ_ENABLE =$e001


.segment "ZEROPAGE"

MMC3_PRG_SLOT:			.res 1
MMC3_CTRL_VAR:			.res 1
MMC3_PRG_PREV:			.res 1
MMC3_CHR_SLOTS:			.res 6



.segment "FIXED"

;------------------------------------------------------------------------------

;void __fastcall__ mmc3_irq_enable(unsigned char line);

.export _mmc3_irq_enable

_mmc3_irq_enable:

	sta <IRQ_START_LINE

	rts
	
	
	
;------------------------------------------------------------------------------

;void __fastcall__ mmc3_chr_bank(unsigned char bank,unsigned char page);
;page=0,1 first 4K in 2K parts, 5,6,7,8 next 4K in 1K parts

.export _mmc3_chr_bank

_mmc3_chr_bank:

	tax
	jsr popa
	sta <MMC3_CHR_SLOTS,x

	rts

;------------------------------------------------------------------------------

;void __fastcall__ mmc3_set_mirroring(unsigned char mode);

.export _mmc3_set_mirroring

_mmc3_set_mirroring:

	sta MMC3_MIRROR

	rts

;------------------------------------------------------------------------------

mmc3_set_prg:

	sta <MMC3_PRG_SLOT

mmc3_set_prg_temp:

	asl a
	tay
	ldx #6
	stx <MMC3_CTRL_VAR
	stx MMC3_CTRL
	sty MMC3_DATA
	inx
	iny
	stx <MMC3_CTRL_VAR
	stx MMC3_CTRL
	sty MMC3_DATA

	rts

;------------------------------------------------------------------------------

mmc3_restore_prg:

	lda <MMC3_PRG_SLOT
	asl a
	tay

	ldx #6
	stx MMC3_CTRL
	sty MMC3_DATA
	iny
	inx
	stx MMC3_CTRL
	sty MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL

	rts
