#include "data/back_a.h"
#include "data/back_b.h"



const unsigned char snow_palette_bg[16*6]={
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x23,0x23,0x23,0x13,0x22,0x22,0x22,0x13,0x22,0x22,0x22,0x13,0x22,0x22,0x22,
	0x13,0x23,0x34,0x34,0x13,0x22,0x22,0x22,0x13,0x22,0x22,0x22,0x13,0x22,0x22,0x22,
	0x13,0x23,0x34,0x30,0x13,0x11,0x11,0x11,0x13,0x01,0x11,0x22,0x13,0x11,0x11,0x11,
	0x13,0x23,0x34,0x30,0x13,0x02,0x11,0x02,0x13,0x02,0x11,0x22,0x13,0x02,0x02,0x02,
	0x13,0x23,0x34,0x30,0x13,0x02,0x11,0x37,0x13,0x01,0x11,0x22,0x13,0x02,0x21,0x30
};

const unsigned char snow_palette_spr[16]={ 0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30 };



const signed char snow_off[256]={
	0,0,1,2,3,3,4,5,6,7,7,8,9,10,10,11,12,12,13,14,15,15,16,17,17,18,19,19,20,20,21,22,22,23,23,24,24,25,25,26,26,27,27,27,28,28,28,29,29,29,30,30,30,30,31,31,31,31,31,31,31,31,31,31,32,31,31,31,31,31,31,31,31,31,31,30,30,30,30,29,29,29,28,28,28,27,27,27,26,26,25,25,24,24,23,23,22,22,21,20,20,19,19,18,17,17,16,15,15,14,13,12,12,11,10,10,9,8,7,7,6,5,4,3,3,2,1,0,0,-1,-2,-3,-4,-4,-5,-6,-7,-8,-8,-9,-10,-11,-11,-12,-13,-13,-14,-15,-16,-16,-17,-18,-18,-19,-20,-20,-21,-21,-22,-23,-23,-24,-24,-25,-25,-26,-26,-27,-27,-28,-28,-28,-29,-29,-29,-30,-30,-30,-31,-31,-31,-31,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-31,-31,-31,-31,-30,-30,-30,-29,-29,-29,-28,-28,-28,-27,-27,-26,-26,-25,-25,-24,-24,-23,-23,-22,-21,-21,-20,-20,-19,-18,-18,-17,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-9,-8,-8,-7,-6,-5,-4,-4,-3,-2,-1,
};

const unsigned char back_height[7]={2,2,5,5,4,4,4};

#define SNOWFLAKES_ALL	32


#pragma bssseg (push,"SHAREDRAM3")
#pragma dataseg(push,"SHAREDRAM3")

unsigned char snow_x       [SNOWFLAKES_ALL];
unsigned int  snow_y       [SNOWFLAKES_ALL];
unsigned char snow_dx      [SNOWFLAKES_ALL];
  signed char snow_dxx     [SNOWFLAKES_ALL];
  signed int  snow_dy      [SNOWFLAKES_ALL];
unsigned char snow_frame   [SNOWFLAKES_ALL];
  signed char snow_frame_dx[SNOWFLAKES_ALL];
unsigned char snow_tile    [SNOWFLAKES_ALL];

unsigned int back_x [7];
unsigned int back_dx[7];

unsigned char snowflakes_cnt;

#pragma dataseg(pop);
#pragma bssseg (pop);


void set_snowflake(void)
{
	signed char fx;
	
	snow_x       [_i]=16+(rand8()%224);
	snow_y       [_i]=0;
	snow_dx      [_i]=0;
	snow_dxx     [_i]=-4+(rand8()&7);
	snow_dy      [_i]=64+(rand16()&127);
	snow_frame   [_i]=rand8();
	
	fx=-32+(rand8()&63);
	
	if(fx>-8&&fx< 0) fx=-8;
	if(fx< 8&&fx>=0) fx= 8;
	
	snow_frame_dx[_i]=fx;
	
	switch(rand8()&3)
	{
	case 1: snow_tile[_i]=0xa1; break;
	case 2: snow_tile[_i]=0xc1; break;
	default:
		    snow_tile[_i]=0xe1;
	}
}



void snow_update(void);
/*
void snow_update(void)
{
	unsigned char add;
	
	add=0;
	
	for(_i=0;_i<snowflakes_cnt;++_i)
	{
		_sy=snow_y[_i]>>8;
		
		if(_sy>=240)	//change
		{
			if(!add)
			{
				++add;
				set_snowflake();
			}
			
			continue;
		}
		
		_sx=snow_x[_i]+snow_off[snow_dx[_i]];
		_spr=((snow_frame[_i]>>5)<<2)+snow_tile[_i];
		
		oam_spr(_sx,_sy,_spr,0,oam_off); oam_off+=4; _sx+=8; _spr+=2;
		oam_spr(_sx,_sy,_spr,0,oam_off); oam_off+=4;
		
		snow_y [_i]+=snow_dy [_i];
		snow_dx[_i]+=snow_dxx[_i];
		
		snow_frame[_i]+=snow_frame_dx[_i];
	}
}	
*/


void e_snow(void)
{
	unsigned char ofl,ofh,step,cnt;
	unsigned int off;

	bank_bg(0);
	bank_spr(1);
	
	oam_clear_fast();
	oam_size(1);
	oam_update();

	_chr=CHR_BACK;
	
	mmc3_chr_bank(_chr+0,0);
	mmc3_chr_bank(_chr+2,1);
	
	_chr=CHR_SPRITES;
	
	mmc3_chr_bank(_chr+0,2);
	mmc3_chr_bank(_chr+1,3);
	mmc3_chr_bank(_chr+2,4);
	mmc3_chr_bank(_chr+3,5);
	
	mmc3_set_mirroring(M_VERTICAL);
	
	for(_i=0;_i<16;++_i)
	{
		pal_scr[_i]=0x0f;
		pal_req[_i]=0x0f;
	}
	
	pal_bg (pal_scr);
	pal_spr(snow_palette_spr);

	vram_adr(NAMETABLE_A);
	vram_write((unsigned char*)back_a,1024);
	vram_adr(NAMETABLE_B);
	vram_write((unsigned char*)back_b,1024);
	
	scroll(0,0);
	
	memfill(update_list,0,sizeof(update_list));	//used as a split scroll list

	set_rand(4);
	
	for(_i=0;_i<SNOWFLAKES_ALL;++_i) set_snowflake();
		
	for(_i=0;_i<7;++_i)
	{
		back_x [_i]=0;
		back_dx[_i]=(_i<3)?((3-_i)*24):(64+(_i-3)*64);
	}

	snowflakes_cnt=1;
	
	_frame=0;
	_bright=4;
	_done=0;
	
	step=0;
	cnt=0;
	
	set_irq_handler(IRQ_ROW_FULLX);
	set_nmi_handler(NMI_NORMAL);
	mmc3_irq_enable(14);	
	
	pal_bright(_bright);
	ppu_on_all();
	
	ft_prev_frame=ft_current_frame;
	ft_prev_row=ft_current_row;
	
	while(!_done||_bright)
	{		
		if(ft_current_row!=ft_prev_row)
		{
			ft_prev_row=ft_current_row;
			
			if(step==7&&ft_prev_row==56) _done=TRUE;
			
			if(ft_prev_row==31||ft_prev_row==63)
			{
				if(step<6)
				{
					switch(step)
					{
						case 0: memcpy(pal_req,&snow_palette_bg[0*16],sizeof(pal_req)); break;
						case 1: memcpy(pal_req,&snow_palette_bg[1*16],sizeof(pal_req)); break;
						case 2: memcpy(pal_req,&snow_palette_bg[2*16],sizeof(pal_req)); break;
						case 3: memcpy(pal_req,&snow_palette_bg[3*16],sizeof(pal_req)); break;
						case 4: memcpy(pal_req,&snow_palette_bg[4*16],sizeof(pal_req)); break;
						case 5: memcpy(pal_req,&snow_palette_bg[5*16],sizeof(pal_req)); break;
					}
				}
				
				++step;
			}
		}

		if(!_done)
		{
			if((_frame&7)==3)
			{
				morph_palette();
				pal_bg(pal_scr);
			}
		}
		else
		{
			if((_frame&7)==2)
			{
				--_bright;
				
				pal_bright(_bright);
			}
		}
		
		_ptr=0;
		
		for(_i=0;_i<7;++_i)
		{
			off=back_x[_i]>>7;
			ofl=off&255;
			ofh=off>>8;
			
			_row=back_height[_i];
			
			for(_j=0;_j<_row;++_j)
			{
				update_list[_ptr++]=ofl;
				update_list[_ptr++]=ofh;
			}
		}
		
		//oam_clear_fast();
		
		oam_off=0;
		
		snow_update();
	
		if(oam_off) oam_hide_rest(oam_off);
		
		oam_update();
		
		ppu_wait_nmi();

		for(_i=0;_i<7;++_i) back_x[_i]+=back_dx[_i];
	
		++cnt;
		
		if(cnt>=40)
		{
			cnt=0;
			
			if(snowflakes_cnt<SNOWFLAKES_ALL) ++snowflakes_cnt;
		}
	
		++_frame;
	}
	
	ppu_off();
	
	mmc3_irq_enable(0);
}