;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;               RTX (256b intro)
;
;______________________________________________________
;
;	CODE:	        svoy
;______________________________________________________
;
;         Decrunch 2020
;         Atari XL/XE intro (256b, compo filler)
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow
; some stable undocumented opcodes used here (lax, isb, sax)
; https://xxl.atari.pl/sally-6502c/



RT20	equ $14
;MYBASE	equ $50
MYBASE	equ $6c ; will it work?
FRMCNT	equ $82
COLOR	equ $83
TEMP1	equ $84 ; size index
TEMP2	equ $85 ; size index

curad_l equ $e1 ; current screen line address
curad_h	equ $e2


; OS values:
VCOUNT	equ $D40B
WSYNC	equ $D40a

AUDF1	equ $D200
AUDC1	equ $D201
AUDF2	equ $D202
AUDC2	equ $D203
AUDF3	equ $D204
AUDC3	equ $D205
AUDF4	equ $D206
AUDC4	equ $D207
AUDCTL 	equ $D208 ;
SKCTL	equ $D20f;

ROWCRS	equ $54		;Row of cursor, 1 byte
COLCRS	equ $55		;Column of cursor, 2 bytes

OLDROW  equ $5A
OLDCOL  equ $5B     ; 2 bytes

FILFLG 	equ $2B7
FILDAT 	equ $2fD

VVBLKD  equ $0224
XITVBV  equ $e462

; Aliases, because orig reg names are hard to remember ;)
PCOLOR	    equ $2fb	;Color for graphics operations
cursor_y    equ ROWCRS
cursor_x    equ COLCRS
prev_y      equ OLDROW
prev_x      equ OLDCOL

; OS functions
openmode  equ $ef9c
drawpoint equ $f1d8
drawto    equ $f9c2
putline   equ $c642
print     equ $f1a4



	opt h+	
	
	org $3500

; data bytes: 22b+7b -> 29b
cyoffda	dta b(16*8+1, 15*8+1, 14*8+2, 13*8+2, 12*8+2, 12*8+3, 11*8+3, 11*8+3, 10*8+3, 10*8+4, 10*8+4, 10*8+4, 10*8+4, 10*8+5, 11*8+5, 11*8+5, 12*8+5, 12*8+6, 13*8+6, 14*8+6, 15*8+7, 16*8+7);;lamp	dta b(16,146,68,16,68,146,16); ver1
lamp	dta b(16,84,56,254,56,84,16); ver3 - best?

start:
	; create/setup mode f, using OS routines, and we are going to mess with it later (multimode, move to a different place in memory)

	lda #10
	sta FILFLG ; use it for fill flag later (>0 for fill)
	jsr $EF9C ; set GTIA10
	
	;jmp linesdraw ; debug only
	;jmp frame ; debug only (sound)
; fill screen with 8s....
	;ldx #0
	;stx prev_x ; looks like not needed?
	;stx prev_y
	;dex
	;stx cursor_y ; so it is at 255, seems to work
	dey ; risky?
	sty prev_x
	sty prev_y
	dey
	sty cursor_y
	lda #8
	sta FILDAT
	sta PCOLOR
	;lda #192
	;sta cursor_y
	jsr drawto
		
	
	;ldx #0	
	;stx FILFLG
	;lsr ; 8 is in A=0, after drawtow, so we get 4, that is close enough to 3 :P
	lsr PCOLOR; 8->4

	;lda #3
	;sta $D20f
;linesdraw:		
; generate and draw grid lines
	lda #79
	sta prev_x
	sta TEMP1
	lda #110
	;sta TEMP2

; enable PMG	
	;lda #62 ; narrow screen, PM enabled, single line PMG
	;lda #%111110 ; single line PMG
	;lda #%01101110 ; double line PMG = 110
	sta 559
	;lda #2
	sta $D01D; enable players
		
	;lda #MYBASE ; set the pmbase
	sta $D407 ; 2e, but accepts $2c	

	pha ; use stack instead of temp2 value
linesloop:	
	lda TEMP1
	;sbc frmcnt
	isb frmcnt ; inc frmcnt, then A=A-frmcnt
	sta TEMP1
	sta cursor_y
	sta prev_y
	lda #0
	sta FILFLG ; set regular drawto, reuse this precious #0 here ... :P
	sta cursor_x
	;sta 712 ; set back color
	jsr drawto	
	;lda TEMP2
	pla
	adc frmcnt
	;sta TEMP2
	pha
	sta prev_y
	sta cursor_y
	sta cursor_x
	jsr drawto
	;inc frmcnt
	lda frmcnt
	cmp #11
	bne linesloop	

					
; fill the cylinder data (column-based-iterator)
	
; draw cylinder
	;lda #21
	;sta FRMCNT
cylloop:
	;ldy FRMCNT
	;lda cyoffda,y
	lda $3515
	;tax
	;and #%00000111
	;sta PCOLOR
	;txa
	ldx #%00000111 
	stx $D20f ; init audio, otherwise it will not play .... :/
	sax PCOLOR ; undocumented, and A with X and store into mem (PCOLOR)
	; fetch offset
	lsr
	lsr	
	sta temp1
	lsr
	sta prev_y
	;asl
	;sta temp1
	lda #192
	sbc temp1
	sta cursor_y
	lda cylloop+1
	adc #28
	sta cursor_x
	sta prev_x
	jsr drawto
	dec cylloop+1
	bpl cylloop		
		

	; so here we have X=0 here, populate the color table
	;sec
	;ldx #0 
	;dex ; X=1 here? - skip a we can iterate with -1 down there	
	lda #16
	ldy #7	
colpop:
	sbc #2
	sta $4005-8,y
	sta $400c-1-8,x
	sta 704-1,x ; on the first iteration we can use the val of 14 in A for lamp color	
	inx
	dey
	bne colpop
											
frame:
	; AUDCTL 					
	;lda #%00101000 ; good value? actually this is a default one ($28) on realHW 
	;sta $D208
	;7      Makes the 17 bit poly counter into nine bit poly (see below)
     	;6      Clock channel one with 1.79 MHz
     	;5      Clock channel three with 1.79 MHz
     	;4      Join channels two and one (16 bit)
     	;3      Join channels four and three (16 bit)
     	;2      Insert high pass filter into channel one, clocked by channel two
     	;1      Insert high pass filter into channel two, clocked by channel four
     	;0      Switch main clock base from 64 KHz to 15 KHz

	lda VCOUNT ; X=0 used in several effects reached by jsr
	bne frame ; wait for new frame

;	lda #%10101111
;	sta AUDC2
; now set the new colors
	; set colors
	;lda FRMCNT
	lax 20 ; RTCLOCK
	eor #%10000000 ; to align the color change with sound a bit....		
	bne skipcolchange
	; evrey 4.5s randomize the colors for cylinder
	lda $D20a	
	and #%11110000
	sta COLOR		
skipcolchange:
	txa		
	sbc #128
	;sta AUDF4 ; v.1b			
        bcs skipneg ; we want offset to be > 0
	eor #$FF ; negation if needed 
	;adc #1 	       	
skipneg:
	; A - 0 - 7F
	tay
	; position the lamp PMG, so it follows the shading...
	sta AUDF4 ; v.1 ------------	
	;eor #$FF	 		
	;sbc #65 ; this gives lamp positions between 60 and 190
	sbc #195	 
	;sta AUDF2 ; joined channels 3+4, so push to 4th - good v.3
	sta $D000
	; now cycle the colors properly
	tya
	lsr ; max 64
	lsr ; max 32
	lsr ; max 16
	tay	
	; 0 -F
	;ora #%10101011 ; v.1 ----------------
	ora #%10101011
	sta AUDC4 ; v.1 --------------
	;     7    6    5
     	;0    0    0  five bit, then 17 bit, polys ; noise
     	;0    0    1  five bit poly only
     	;0    1    0  five bit, then four bit, polys ; metalic-noisy
     	;0    1    1  five bit poly only ; almost pure
     	;1    0    0  l7 bit poly only ; nice whitenoise
     	;1    0    1  no poly counters (pure tone)
    	;1    1    0  four bit poly only
    	;1    1    1  no poly counters (pure tone)	
	ldx #6	
popcol:	
	lda $4000-1-6,y		
	ora COLOR	
	sta 705,x ; 704 is used for PMG0 (lamp)		
	lda lamp,x ; use that loop to populate lamp data
	;lda $e000+10*8,x ; charset based, but bulky 
	sta 256*MYBASE+512+60,x ; double line
	;dey
	iny
	dex
	bpl popcol
	;  0     1   2    3    4    5    6    7 
	; 705, 706, 707, 708, 709, 710, 711, 712	

	bne frame
	
;	org $4006 ; this is now generated in the code 			
;cols	dta b(2,4,6,8,10,12,14,12,10,8,6,4,2); 13b

	;run $3500;
	run start
	end	
		
	