#version 330 core
layout(location = 0) in vec2 aPos;
layout(location = 1) in vec3 aOffset;
layout(location = 2) in vec3 aColor;

uniform mat4 model;      // Model view matrix
uniform mat4 view;       // View matrix
uniform mat4 projection; // projection matrix
uniform mat4 inverseViewNoTrans;

out vec3 fColor;
out vec2 texCoord;

void main()
{
    fColor = aColor;

    // Used for texture atlas if needed
    if ((gl_VertexID % 6) == 0)
    {
        texCoord = vec2(0.0, 1.0);
    }
    else if ((gl_VertexID % 6) == 1)
    {
        texCoord = vec2(0.0, 0.0);
    }
    else if ((gl_VertexID % 6) == 2)
    {
        texCoord = vec2(1.0, 1.0);
    }
    else if ((gl_VertexID % 6) == 3)
    {
        texCoord = vec2(1.0, 0.0);
    }
    else if ((gl_VertexID % 6) == 4)
    {
        texCoord = vec2(0.0, 0.0);
    }
    else if ((gl_VertexID % 6) == 5)
    {
        texCoord = vec2(1.0, 1.0);
    }

    vec3 newPos = vec3(aPos, 0.0) + aOffset;
    gl_Position = projection * view * model * inverseViewNoTrans * vec4(newPos, 1.0);
}