XPHASE EQU SI-4+0
YPHASE EQU SI-4+1
FX EQU SI-8
FY EQU SI-6

ORG 256
 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

 MOV AL,13H
 INT 10H
colors:
 MOV CH,48
 IMUL DX,BX,64
 MOV AX,1010H
 INT 10H
 INC BL
 JNZ colors

 MOV BH,0A0H
 PUSH BX
 POP ES
costab:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FCOS                   ; COS(counter*PI/128)
 FIMUL WORD [SI]        ; 127*COS(counter*PI/128)
 FISTP WORD [BX+SI]     ; -
 INC BX
 INC BYTE [DI]          ; loop 256x
 JNZ costab             ; BX = cosinus table

nextframe:
nextpixel:              ; XPhase=0.9, YPhase=0.7
 MOV BP,77*77/4
 FLDZ
 FSTP DWORD [SI]        ; f=0, i=0
fori:
 MOV AX,0CCCDH
 MUL DI
 NOT DH

 MOV AL,6
 MUL DL
 MOV BL,AL
 MOV AL,[BX]
 XCHG DX,AX
 MOV AL,5
 MUL AH
 MOV BL,AL
 MOV AL,[BX]
 IMUL DL
 IMUL BP
 ADD [SI],DX

 MOV AL,[SI+1]
 NEG AL
 JZ .1
 CBW
 MOV [SI],AH
.1:


 SHR BP,1

; ADD WORD [SI+1],20+256*26
; JNS fori

 MOVSB
 DEC SI
 TEST DI,DI
 JNE nextpixel

; IN AL,60H
; DAS
; JC nextframe
 MOV AH,1
 INT 16H
 JZ nextframe

RETN
