/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.SequentialData;
import com.jsyn.exceptions.ChannelMismatchException;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.QueueDataEvent;
import com.jsyn.ports.UnitPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.LinkedList;

public class UnitDataQueuePort
extends UnitPort {
    private final LinkedList<QueuedBlock> blocks = new LinkedList();
    private QueueDataCommand currentBlock;
    private int frameIndex;
    private int numChannels = 1;
    private double normalizedRate;
    private long framesMoved;
    private boolean autoStopPending;
    private boolean targetValid;
    private QueueDataCommand finishingBlock;
    private QueueDataCommand loopingBlock;
    public static final int LOOP_IF_LAST = -1;

    public UnitDataQueuePort(String string) {
        super(string);
    }

    protected void setupCrossFade(QueueDataCommand queueDataCommand, int n, QueueDataCommand queueDataCommand2) {
        int n2 = queueDataCommand2.getCrossFadeIn();
        SequentialData sequentialData = queueDataCommand.getCurrentData();
        SequentialData sequentialData2 = queueDataCommand2.getCurrentData();
        int n3 = sequentialData.getNumFrames() - n;
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 > 0) {
            int n4 = sequentialData2.getNumFrames() - queueDataCommand2.getStartFrame();
            queueDataCommand2.crossfadeData.setup(sequentialData, n, n2, sequentialData2, queueDataCommand2.getStartFrame(), n4);
            queueDataCommand2.currentData = queueDataCommand2.crossfadeData;
            queueDataCommand2.startFrame = 0;
        }
    }

    public QueueDataCommand createQueueDataCommand(SequentialData sequentialData) {
        return this.createQueueDataCommand(sequentialData, 0, sequentialData.getNumFrames());
    }

    public QueueDataCommand createQueueDataCommand(SequentialData sequentialData, int n, int n2) {
        if (sequentialData.getChannelsPerFrame() != this.numChannels) {
            throw new ChannelMismatchException("Tried to queue " + sequentialData.getChannelsPerFrame() + " channel data to a " + this.numChannels + " channel port.");
        }
        return new QueuedBlock(sequentialData, n, n2);
    }

    public QueueDataCommand getEndBlock() {
        if (this.blocks.size() > 0) {
            return this.blocks.getLast();
        }
        if (this.currentBlock != null) {
            return this.currentBlock;
        }
        return null;
    }

    public void setCurrentBlock(QueueDataCommand queueDataCommand) {
        this.currentBlock = queueDataCommand;
    }

    public void firePendingCallbacks() {
        if (this.loopingBlock != null) {
            if (this.loopingBlock.getCallback() != null) {
                this.loopingBlock.getCallback().looped(this.currentBlock);
            }
            this.loopingBlock = null;
        }
        if (this.finishingBlock != null) {
            if (this.finishingBlock.getCallback() != null) {
                this.finishingBlock.getCallback().finished(this.currentBlock);
            }
            this.finishingBlock = null;
        }
    }

    public boolean hasMore() {
        return this.currentBlock != null || this.blocks.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBlock() {
        if (this.currentBlock == null) {
            LinkedList<QueuedBlock> linkedList = this.blocks;
            synchronized (linkedList) {
                this.setCurrentBlock(this.blocks.remove());
                this.frameIndex = this.currentBlock.getStartFrame();
                this.currentBlock.loopsLeft = this.currentBlock.getNumLoops();
                if (this.currentBlock.getCallback() != null) {
                    this.currentBlock.getCallback().started(this.currentBlock);
                }
            }
        }
    }

    private void advanceFrameIndex() {
        ++this.frameIndex;
        ++this.framesMoved;
        if (this.frameIndex >= this.currentBlock.getStartFrame() + this.currentBlock.getNumFrames()) {
            if (this.currentBlock.loopsLeft > 0) {
                --this.currentBlock.loopsLeft;
                this.loopToStart();
            } else if (this.blocks.size() == 0 && this.currentBlock.loopsLeft < 0) {
                this.loopToStart();
            } else {
                if (this.currentBlock.isAutoStop()) {
                    this.autoStopPending = true;
                }
                this.finishingBlock = this.currentBlock;
                this.setCurrentBlock(null);
            }
        }
    }

    private void loopToStart() {
        if (this.currentBlock.getCrossFadeIn() > 0) {
            this.setupCrossFade(this.currentBlock, this.frameIndex, this.currentBlock);
        }
        this.frameIndex = this.currentBlock.getStartFrame();
        this.loopingBlock = this.currentBlock;
    }

    public double getNormalizedRate() {
        return this.normalizedRate;
    }

    public double readCurrentChannelDouble(int n) {
        return this.currentBlock.currentData.readDouble(this.frameIndex * this.numChannels + n);
    }

    public void writeCurrentChannelDouble(int n, double d) {
        this.currentBlock.currentData.writeDouble(this.frameIndex * this.numChannels + n, d);
    }

    public void beginFrame(double d) {
        this.checkBlock();
        this.normalizedRate = this.currentBlock.currentData.getRateScaler(this.frameIndex, d);
    }

    public void endFrame() {
        this.advanceFrameIndex();
        this.targetValid = true;
    }

    public double readNextMonoDouble(double d) {
        this.beginFrame(d);
        double d2 = this.currentBlock.currentData.readDouble(this.frameIndex);
        this.endFrame();
        return d2;
    }

    protected void addQueuedBlock(QueueDataEvent queueDataEvent) {
        this.blocks.add((QueuedBlock)queueDataEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueue() {
        LinkedList<QueuedBlock> linkedList = this.blocks;
        synchronized (linkedList) {
            this.blocks.clear();
            this.setCurrentBlock(null);
            this.targetValid = false;
            this.autoStopPending = false;
        }
    }

    public void queue(SequentialData sequentialData, int n, int n2, TimeStamp timeStamp) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        this.scheduleCommand(timeStamp, queueDataCommand);
    }

    public void queueImmediate(SequentialData sequentialData, int n, int n2, TimeStamp timeStamp) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        queueDataCommand.setImmediate(true);
        this.scheduleCommand(timeStamp, queueDataCommand);
    }

    public void queueLoop(SequentialData sequentialData, int n, int n2, TimeStamp timeStamp) {
        this.queueLoop(sequentialData, n, n2, -1, timeStamp);
    }

    public void queueLoop(SequentialData sequentialData, int n, int n2, int n3, TimeStamp timeStamp) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        queueDataCommand.setNumLoops(n3);
        this.scheduleCommand(timeStamp, queueDataCommand);
    }

    public void queueLoop(SequentialData sequentialData) {
        this.queueLoop(sequentialData, 0, sequentialData.getNumFrames());
    }

    public void queueLoop(SequentialData sequentialData, int n, int n2) {
        this.queueLoop(sequentialData, n, n2, -1);
    }

    public void queueLoop(SequentialData sequentialData, int n, int n2, int n3) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        queueDataCommand.setNumLoops(n3);
        this.queueCommand(queueDataCommand);
    }

    public void queueStop(SequentialData sequentialData, int n, int n2, TimeStamp timeStamp) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        queueDataCommand.setAutoStop(true);
        this.scheduleCommand(timeStamp, queueDataCommand);
    }

    public void queue(SequentialData sequentialData, int n, int n2) {
        QueueDataCommand queueDataCommand = this.createQueueDataCommand(sequentialData, n, n2);
        this.queueCommand(queueDataCommand);
    }

    public void queue(SequentialData sequentialData) {
        this.queue(sequentialData, 0, sequentialData.getNumFrames());
    }

    public void queueOn(SequentialData sequentialData) {
        this.queueOn(sequentialData, this.getSynthesisEngine().createTimeStamp());
    }

    public void queueOff(SequentialData sequentialData) {
        this.queueOff(sequentialData, false);
    }

    public void queueOff(SequentialData sequentialData, boolean bl) {
        this.queueOff(sequentialData, bl, this.getSynthesisEngine().createTimeStamp());
    }

    public void queueOn(SequentialData sequentialData, TimeStamp timeStamp) {
        if (sequentialData.getSustainBegin() < 0) {
            if (sequentialData.getReleaseBegin() < 0) {
                this.queueImmediate(sequentialData, 0, sequentialData.getNumFrames(), timeStamp);
            } else {
                this.queueImmediate(sequentialData, 0, sequentialData.getReleaseEnd(), timeStamp);
                int n = sequentialData.getReleaseEnd() - sequentialData.getReleaseBegin();
                this.queueLoop(sequentialData, sequentialData.getReleaseBegin(), n, timeStamp);
            }
        } else if (sequentialData.getSustainEnd() > 0) {
            int n = sequentialData.getSustainBegin();
            int n2 = sequentialData.getSustainEnd() - sequentialData.getSustainBegin();
            if (n > 0) {
                this.queueImmediate(sequentialData, 0, n, timeStamp);
            }
            if ((n2 = sequentialData.getSustainEnd() - sequentialData.getSustainBegin()) > 0) {
                this.queueLoop(sequentialData, sequentialData.getSustainBegin(), n2, timeStamp);
            }
        }
    }

    public void queueOff(SequentialData sequentialData, boolean bl, TimeStamp timeStamp) {
        if (sequentialData.getSustainBegin() >= 0) {
            int n = sequentialData.getReleaseEnd() - sequentialData.getReleaseBegin();
            if (sequentialData.getReleaseBegin() < 0) {
                int n2 = sequentialData.getSustainEnd();
                int n3 = sequentialData.getNumFrames() - n2;
                if (n3 <= 0) {
                    n3 = 1;
                    n2 = sequentialData.getNumFrames() - 1;
                }
                if (bl) {
                    this.queueStop(sequentialData, n2, n3, timeStamp);
                } else {
                    this.queue(sequentialData, n2, n3, timeStamp);
                }
            } else if (sequentialData.getReleaseBegin() > sequentialData.getSustainEnd()) {
                this.queue(sequentialData, sequentialData.getSustainEnd(), sequentialData.getReleaseEnd() - sequentialData.getSustainEnd(), timeStamp);
                if (n > 0) {
                    this.queueLoop(sequentialData, sequentialData.getReleaseBegin(), n, timeStamp);
                }
            } else if (n > 0) {
                this.queueLoop(sequentialData, sequentialData.getReleaseBegin(), n, timeStamp);
            }
        }
    }

    public void clear(TimeStamp timeStamp) {
        ClearQueueCommand clearQueueCommand = new ClearQueueCommand();
        this.scheduleCommand(timeStamp, clearQueueCommand);
    }

    public void clear() {
        ClearQueueCommand clearQueueCommand = new ClearQueueCommand();
        this.queueCommand(clearQueueCommand);
    }

    public void writeNextDouble(double d) {
        this.checkBlock();
        this.currentBlock.currentData.writeDouble(this.frameIndex, d);
        this.advanceFrameIndex();
    }

    public long getFrameCount() {
        return this.framesMoved;
    }

    public boolean testAndClearAutoStop() {
        boolean bl = this.autoStopPending;
        this.autoStopPending = false;
        return bl;
    }

    public boolean isTargetValid() {
        return this.targetValid;
    }

    public void setNumChannels(int n) {
        this.numChannels = n;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    class ClearQueueCommand
    implements ScheduledCommand {
        ClearQueueCommand() {
        }

        @Override
        public void run() {
            UnitDataQueuePort.this.clearQueue();
        }
    }

    private class QueuedBlock
    extends QueueDataCommand {
        public QueuedBlock(SequentialData sequentialData, int n, int n2) {
            super(UnitDataQueuePort.this, sequentialData, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = UnitDataQueuePort.this.blocks;
            synchronized (linkedList) {
                QueueDataEvent queueDataEvent;
                if (UnitDataQueuePort.this.blocks.size() > 0 && (queueDataEvent = (QueueDataEvent)UnitDataQueuePort.this.blocks.getLast()).isSkipIfOthers()) {
                    UnitDataQueuePort.this.blocks.removeLast();
                }
                if (this.getCrossFadeIn() > 0) {
                    if (this.isImmediate()) {
                        if (UnitDataQueuePort.this.currentBlock != null) {
                            UnitDataQueuePort.this.setupCrossFade(UnitDataQueuePort.this.currentBlock, UnitDataQueuePort.this.frameIndex, this);
                        }
                    } else {
                        queueDataEvent = UnitDataQueuePort.this.getEndBlock();
                        if (queueDataEvent != null) {
                            UnitDataQueuePort.this.setupCrossFade((QueueDataCommand)queueDataEvent, queueDataEvent.getStartFrame() + queueDataEvent.getNumFrames(), this);
                        }
                    }
                }
                if (this.isImmediate()) {
                    UnitDataQueuePort.this.clearQueue();
                }
                UnitDataQueuePort.this.blocks.add(this);
            }
        }
    }
}

