import moonlander.library.*;
import processing.sound.*;

Moonlander moonlander;
TimeController mlController = new TimeController(4);
int muuttuja, stepSize, baseSpeed, lapCount=1;
float angle, shear = 0.0, frequency = 200;
boolean warpSpeed = false, sound1Playing, sound2Playing, sound3Playing;
SinOsc sound0, sound1, sound2, sound3;

void setup()
{
  moonlander = new Moonlander(this, mlController);
  colorMode(HSB, 360, 100, 100);
  //size(800,800);
  fullScreen();
  noCursor();
  moonlander.start();
//  noiseSeed(42);
  sound0 = new SinOsc(this);
  sound0.freq(100);
  sound0.amp(1.0);
  sound0.play();
  sound1 = new SinOsc(this);
  sound2 = new SinOsc(this);
  sound3 = new SinOsc(this);
}

void draw()
{
  moonlander.update();
  double currentRow = moonlander.getCurrentRow();
  if(warpSpeed && currentRow >= 20 && !sound2Playing){
    sound0.stop();
    sound2Playing = true;
    sound2.play();
  }
  if(warpSpeed && currentRow >= 40 && !sound3Playing){
    sound3Playing = true;
    //sound3.play();
  }
  if(currentRow >=60) {
    mlController.setCurrentRow(0, true);
    lapCount += 2;
    warpSpeed = true;
    if(shear < 0.6)
      shear += 0.1;
    if(!sound1Playing){
      sound1Playing = true;
      sound1.play();
      sound0.amp(0.5);
    }
  } else {
    sound0.freq(moonlander.getIntValue("sound0pitch"));
  }
  
  baseSpeed = warpSpeed ? 30 : moonlander.getIntValue("speed");
  angle = (angle +baseSpeed + pow(lapCount, 2)) % 360 ;
  
  frequency = moonlander.getIntValue("sound1pitch");
  sound1.freq(frequency);
  float vol = (float)moonlander.getValue("sound1vol");
  sound1.amp(vol);
  
  frequency = moonlander.getIntValue("sound2pitch");
  sound2.freq(frequency);
  vol = (float)moonlander.getValue("sound2vol");
  sound2.amp(vol);
  frequency = moonlander.getIntValue("sound3pitch");
  sound3.freq(frequency);
  vol = (float)moonlander.getValue("sound3vol");
  sound3.amp(vol);
  
  muuttuja = moonlander.getIntValue("muuttuja");
  stepSize = moonlander.getIntValue("stepsize");
  
  translate(width/2,height/2);
  
  shearX(shear);
  rotate(radians(angle));

//(215,27,68); //vaaleansininen
//(111, 59, 50); //metsävihreä
//(17, 42,66); //makkaraväri

  background(moonlander.getIntValue("bghue"), moonlander.getIntValue("bgsaturation"), moonlander.getIntValue("bgluminance"));
  stroke(moonlander.getIntValue("hue"), moonlander.getIntValue("saturation"), moonlander.getIntValue("luminance")); 
  noFill();

  for(int u=0; u<110; u+=stepSize)
  {
    strokeWeight(u*4);
    beginShape();
    for(int i=u-1+muuttuja;i<=u+stepSize-muuttuja;i++) // eka ja vika koordinaatti overlappaa, jotta käyrä koskee viereisiin
    {
      curveVertex((i*i/10)*sin(i/5.0),(i*i/10)*cos(i/5.0));
    }
    endShape();
  }
  
  if(millis() >60000){
    sound1.stop();
    sound2.stop();
    sound3.stop();
    exit();
  }
}
