#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
layout (location=4) in vec3 vertexPos2;
layout (location=5) in vec3 vertexNormal2;

out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

uniform float g_meshMorph = 0.0;



void main() {
    vec3 p = vertexPosition;
    vec3 n = vertexNormal;

    if (abs(g_meshMorph)>0.001) {
        p = vertexPosition*(1.0-g_meshMorph)+vertexPos2*g_meshMorph;
        n = vertexNormal*(1.0-g_meshMorph)+vertexNormal2*g_meshMorph;
    }
  gl_Position = vec4(p, 1.0);

//  instPos = instPosition*1.0;
//  instVel = vInstVel;
//  instAge = vInstAge;
//  instRec = vInstRec;


  vec4 posse = gl_Position;
  origPos = posse;

  normal = n;
  tangent = vertexTangent;
  uv = vertexUV;

}
