import QtQuick 2.4

import AdaptDemoSystem 1.0

GroupBase {
    id: groupBase

   // pm: effectName
    pm: name

    property string effectBaseName: effectName


    property var valMap: []

    Component {
        id: sb
        SyncBlock {

        }
    }

    function getEffectNameFromTrack(trackName) {
      var s = trackName;
      var sa = s.split(".");
      if (sa.length > 1) {
        return sa[1];
      }
      return "";
    }

    Connections {
      target: getRootRocket()
      onTrackFocused: {
        if (effectName !== "Group") {
          var effectTrackName = groupBase.name

          var rocketEffectTrackName = getEffectNameFromTrack(trackName);

          console.log("track focused in scene, effectTrackName:"+effectTrackName+" rocketEffectTrackName:"+rocketEffectTrackName+ " effectName:"+effectName)

          if (effectTrackName === rocketEffectTrackName) {
            root.focusedToEffectBaseName(effectName);
          }
        }
      }

    }


    function blendSel(rn) {
      var v = syncRoot(rn+".blendMode", 0.0);
      root.addEffectTrack(effectName, rn+".blendMode")
      return blendSelBase(v);
    }



    function syncWithBlockFixed(track, i) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        return sbu.getFixedValue(i);
    }

    function writeBlockFixedValue(track, i, value) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        sbu.setFixedValue(i, value);
    }


    function syncWithBlock(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        if (!root.bReleaseVer) {
            if (defaultValue !== undefined && defaultValue !== "" && sbu.value===0.0) {
                var trackKeys = getRootRocket().getTrackNumKeys(sk);
             //   console.log("track num keys:"+trackKeys+" for track:"+track);
                if (trackKeys === 0) {
                    // console.log("setting track first value to:"+defaultValue);
                    getRootRocket().setTrackFirstValue(sk, defaultValue);
                    return defaultValue;
                }
            }
        }
        return sbu.value;
    }

    function syncWithBlockTrigger(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
//        if (!root.bReleaseVer) {
//            if (defaultValue !== undefined && defaultValue !== "" && sbu.valueTrigger===0.0) {
//                var trackKeys = getRootRocket().getTrackNumKeys(track);
//                if (trackKeys === 0) {
//                    getRootRocket().setTrackFirstValue(track, defaultValue);
//                    return defaultValue;
//                }
//            }
//        }
        return sbu.valueTrigger;
    }


    function sync(track, defaultValue) {
        if (sceneName === "") return 1.0;
        root.addEffectTrack(effectName, track, defaultValue)

        if (track.indexOf("ON")!==-1) {
//            console.log("syncing ON track:"+track)
        }

        if (fxFromTL(effectName, track)) {
//            console.log("found value for ON track:"+track)
            return fxV(track);
        }
        return syncWithBlock(track, defaultValue);
    }



    function syncRoot(track, defaultValue) {
        return sync(track, defaultValue);
    }
    function meshSel(rn) {
      var v = syncRoot(rn+".meshIndex", 0).toFixed(0);
      return meshSelBase(v);
    }

    function meshSel2(rn) {
      var v = syncRoot(rn+".meshIndex2", 0).toFixed(0);
      if (v<1000) {
        return "";
      }
      return meshSelBase(v);
    }


    function syncGroup(track, defaultValue) {
        if (sceneName == "") return 1.0;
        root.addEffectTrack(effectName, track, defaultValue)
        if (fxFromTL(effectName, track)) {
            return fxV(track);
        }
        return syncWithBlock(track, defaultValue);
    }

    function syncTrigger(track) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            if (track.indexOf(".ON") !== -1) {
                return 1.0;
            } else {
                return 0.0;
            }
        }

        if (fxFromTL(effectName, track)) {
            return fxVTrig(track);
        }

        root.addEffectTrack(effectName, track)
        var a = getRootRocket().syncTrigger(sceneName+"."+track);
        var b = groupBase.effectSyncUpdate;
        // console.log("syncTrigger for track:"+track, "gives:"+a);
        return a;
       // return syncWithBlockTrigger(track, 0.0);
    }


    function syncTime(track, t) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            if (track.indexOf(".ON") !== -1) {
                return 1.0;
            } else {
                return 0.0;
            }
        }
        root.addEffectTrack(effectName, track)
        var a = getRootRocket().syncTime(sceneName+"."+track, t);
    //    var b = groupBase.effectSyncUpdate;
        return a;
    }

    function syncTriggerTime(track, t) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }
        root.addEffectTrack(effectName, track)
        var a = getRootRocket().syncTrigger(sceneName+"."+track, t);
        var b = groupBase.effectSyncUpdate;
        // console.log("syncTrigger for track:"+track, "gives:"+a);
        return a;
       // return syncWithBlockTrigger(track, 0.0);
    }


    function syncOsc(track, defaultValue) {
        root.addEffectTrack(effectName, track, defaultValue)
        return syncOscBase(track, "-osc", defaultValue, syncGroup);
    }
    function syncFFT(track, defaultValue) {
      // return syncFFTBase(track, "-fft", defaultValue, syncGroup);
      root.addEffectTrack(effectName, track, defaultValue)
      return syncFFTBaseImage(track, "-fft", defaultValue, syncGroup);
    }
    function getTexImageFFT(track) {
      return getFFTBaseTexImage(track, "-fft", syncGroup)
    }

    function syncOscFFT(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue, syncGroup)+syncFFTBaseImage(track, "-fft", defaultValue, syncGroup)-syncGroup(track, defaultValue);
    }


}
